/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall.render;

import net.sourceforge.wurfl.wall.context.WallDevice;
import net.sourceforge.wurfl.wall.render.ChtmlTagsHandler;
import net.sourceforge.wurfl.wall.render.TagsHandler;
import net.sourceforge.wurfl.wall.render.TagsHandlerFactory;
import net.sourceforge.wurfl.wall.render.WmlTagsHandler;
import net.sourceforge.wurfl.wall.render.XhtmlMPTagsHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultTagsHandlerFactory
implements TagsHandlerFactory {
    private final Log log = LogFactory.getLog((Class)DefaultTagsHandlerFactory.class);

    public TagsHandler getInstance(WallDevice device) {
        if (device.isWml()) {
            return new WmlTagsHandler();
        }
        if (device.isChtml()) {
            return new ChtmlTagsHandler();
        }
        if (device.isXhtml()) {
            return new XhtmlMPTagsHandler();
        }
        this.log.warn((Object)("No right TagsHandler found for device: " + device.getId() + ". Returning WMLTagsHandler."));
        return new WmlTagsHandler();
    }
}

