/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall.render;

import java.io.Serializable;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import net.sourceforge.wurfl.wall.TagUtil;
import net.sourceforge.wurfl.wall.WallA;
import net.sourceforge.wurfl.wall.WallAlternate_img;
import net.sourceforge.wurfl.wall.WallB;
import net.sourceforge.wurfl.wall.WallBlock;
import net.sourceforge.wurfl.wall.WallBody;
import net.sourceforge.wurfl.wall.WallBr;
import net.sourceforge.wurfl.wall.WallCaller;
import net.sourceforge.wurfl.wall.WallCell;
import net.sourceforge.wurfl.wall.WallCool_menu;
import net.sourceforge.wurfl.wall.WallCool_menu_css;
import net.sourceforge.wurfl.wall.WallDocument;
import net.sourceforge.wurfl.wall.WallFont;
import net.sourceforge.wurfl.wall.WallForm;
import net.sourceforge.wurfl.wall.WallHead;
import net.sourceforge.wurfl.wall.WallHeadingHelper;
import net.sourceforge.wurfl.wall.WallHr;
import net.sourceforge.wurfl.wall.WallImg;
import net.sourceforge.wurfl.wall.WallInput;
import net.sourceforge.wurfl.wall.WallMarquee;
import net.sourceforge.wurfl.wall.WallMenu;
import net.sourceforge.wurfl.wall.WallMenu_css;
import net.sourceforge.wurfl.wall.WallOption;
import net.sourceforge.wurfl.wall.WallScript;
import net.sourceforge.wurfl.wall.WallSelect;
import net.sourceforge.wurfl.wall.WallStyle;
import net.sourceforge.wurfl.wall.WallTitle;
import net.sourceforge.wurfl.wall.WallXmlpidtd;
import net.sourceforge.wurfl.wall.context.WallDevice;
import net.sourceforge.wurfl.wall.render.TagsHandler;
import net.sourceforge.wurfl.wall.utils.MarkupBuilder;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DefaultWallTagsHandler
implements TagsHandler,
Serializable {
    private static final long serialVersionUID = 10L;
    private final Log log = LogFactory.getLog(this.getClass());

    public String generateAnchorStartTag(WallA a) {
        boolean isInsideMenu;
        boolean bl = isInsideMenu = a.getMenu() != null;
        if (isInsideMenu) {
            return this.generateAnchorMenuStartTag(a);
        }
        return this.generateAnchorDefaultStartTag(a);
    }

    protected abstract String generateAnchorDefaultStartTag(WallA var1);

    protected abstract String generateAnchorMenuStartTag(WallA var1);

    public String generateAnchorEndTag(WallA a) {
        boolean isInsideMenu;
        boolean bl = isInsideMenu = TagSupport.findAncestorWithClass((Tag)a, (Class)WallMenu.class) != null;
        if (isInsideMenu) {
            return this.generateAnchorMenuEndTag(a);
        }
        return this.generateAnchorDefaultEndTag(a);
    }

    protected String generateAnchorDefaultEndTag(WallA a) {
        return "</a>";
    }

    protected abstract String generateAnchorMenuEndTag(WallA var1);

    public String generateAlternateImgStartTag(WallAlternate_img alternateImg) {
        return "";
    }

    public String generateAlternateImgEndTag(WallAlternate_img alternateImg) {
        return "";
    }

    public String generateBlockStartTag(WallBlock block) throws JspException {
        return "<p>";
    }

    public String generateBlockEndTag(WallBlock block) throws JspException {
        return "</p>";
    }

    public String generateBoldStartTag(WallB b) {
        return "<b>";
    }

    public String generateBoldEndTag(WallB b) {
        return "</b>";
    }

    public String generateBodyStartTag(WallBody body) throws JspException {
        return "<body>";
    }

    public String generateBodyEndTag(WallBody body) throws JspException {
        return "</body>";
    }

    public String generateBrStartTag(WallBr br) {
        return "<br/>";
    }

    public String generateBrEndTag(WallBr br) {
        return "";
    }

    public String generateCallerStartTag(WallCaller tag) {
        boolean isInsideMenu;
        boolean bl = isInsideMenu = TagSupport.findAncestorWithClass((Tag)tag, (Class)WallMenu.class) != null;
        if (isInsideMenu) {
            return this.generateCallerMenuStartTag(tag);
        }
        return this.generateCallerDefaultStartTag(tag);
    }

    protected abstract String generateCallerDefaultStartTag(WallCaller var1);

    protected abstract String generateCallerMenuStartTag(WallCaller var1);

    public String generateCallerEndTag(WallCaller tag) {
        boolean isInsideMenu;
        boolean bl = isInsideMenu = tag.getMenu() != null;
        if (isInsideMenu) {
            return this.generateCallerMenuEndTag(tag);
        }
        return this.generateCallerDefaultEndTag(tag);
    }

    protected String generateCallerDefaultEndTag(WallCaller tag) {
        return "</a>";
    }

    protected abstract String generateCallerMenuEndTag(WallCaller var1);

    public String generateCellStartTag(WallCell cell) {
        boolean performTabularization;
        boolean bl = performTabularization = cell.getCoolMenu().isTabularize() && cell.getDevice().isTableSupported();
        if (performTabularization) {
            return this.generateCellTabularStartTag(cell);
        }
        return this.generateCellDefaultStartTag(cell);
    }

    protected String generateCellDefaultStartTag(WallCell cell) {
        return "";
    }

    protected String generateCellTabularStartTag(WallCell cell) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        if (cell.isFirstRowCell()) {
            tagBuilder.openElement("tr");
        }
        tagBuilder.openElement("td");
        return tagBuilder.toMarkup();
    }

    public String generateCellEndTag(WallCell cell) {
        boolean performTabularization;
        boolean bl = performTabularization = cell.getCoolMenu().isTabularize() && cell.getDevice().isTableSupported();
        if (performTabularization) {
            return this.generateCellTabularEndTag(cell);
        }
        return this.generateCellDefaultEndTag(cell);
    }

    protected String generateCellDefaultEndTag(WallCell cell) {
        return "<br/>";
    }

    protected String generateCellTabularEndTag(WallCell cell) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.closeElement("td");
        if (cell.isLastRowCell()) {
            tagBuilder.closeElement("tr");
        }
        return tagBuilder.toMarkup();
    }

    public String generateCoolMenuStartTag(WallCool_menu coolMenu) throws JspException {
        boolean performTabularization;
        boolean bl = performTabularization = coolMenu.isTabularize() && coolMenu.getDevice().isTableSupported();
        if (performTabularization) {
            return this.generateCoolMenuTabularStartTag(coolMenu);
        }
        return this.generateCoolMenuDefaultStartTag(coolMenu);
    }

    protected String generateCoolMenuDefaultStartTag(WallCool_menu coolMenu) throws JspException {
        return "<p>";
    }

    protected String generateCoolMenuTabularStartTag(WallCool_menu coolMenu) throws JspException {
        return "<table>";
    }

    public String generateCoolMenuEndTag(WallCool_menu coolMenu) {
        boolean performTabularization;
        boolean bl = performTabularization = coolMenu.isTabularize() && coolMenu.getDevice().isTableSupported();
        if (performTabularization) {
            return this.generateCoolMenuTabularEndTag(coolMenu);
        }
        return this.generateCoolMenuDefaultEndTag(coolMenu);
    }

    protected String generateCoolMenuDefaultEndTag(WallCool_menu coolMenu) {
        return "</p>";
    }

    protected String generateCoolMenuTabularEndTag(WallCool_menu coolMenu) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.appendText(this.generateCoolMenuTabularEmptyCells(coolMenu)).appendNewLine();
        tagBuilder.closeElement("table");
        return tagBuilder.toMarkup();
    }

    protected String generateCoolMenuTabularEmptyCells(WallCool_menu coolMenu) {
        int columns;
        MarkupBuilder tagBuilder = new MarkupBuilder();
        int cells = coolMenu.getCells();
        int nextColumn = cells % (columns = coolMenu.getColumns());
        if (nextColumn % columns != 0) {
            while (nextColumn > 0) {
                tagBuilder.appendText(this.generateCoolMenuTabularEmptyCell(coolMenu));
                nextColumn = (nextColumn + 1) % columns;
            }
            tagBuilder.appendNewLine();
            tagBuilder.closeElement("tr");
        }
        return tagBuilder.toString();
    }

    protected String generateCoolMenuTabularEmptyCell(WallCool_menu coolMenu) {
        return "<td></td>";
    }

    public String generateCoolMenuCssStartTag(WallCool_menu_css coolMenuCss) throws JspException {
        return "";
    }

    public String generateCoolMenuCssEndTag(WallCool_menu_css coolMenuCss) throws JspException {
        return "";
    }

    public String generateDocumentStartTag(WallDocument document) {
        return "";
    }

    public String generateDocumentEndTag(WallDocument document) {
        return "</html>";
    }

    public String generateFontStartTag(WallFont font) {
        return "";
    }

    public String generateFontEndTag(WallFont font) {
        return "";
    }

    public String generateFormStartTag(WallForm tag) throws JspException {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("form").appendAttribute("action", tag.getAction()).appendAttribute("method", tag.getMethod()).endOpenElement().appendNewLine();
        return tagBuilder.toMarkup();
    }

    public String generateFormEndTag(WallForm tag) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.closeElement("form");
        return tagBuilder.toMarkup();
    }

    public String generateHStartTag(WallHeadingHelper heading) {
        return new MarkupBuilder().openElement(this.generateHeadingName(heading)).toMarkup();
    }

    public String generateHEndTag(WallHeadingHelper heading) {
        return new MarkupBuilder().closeElement(this.generateHeadingName(heading)).toMarkup();
    }

    protected String generateHeadingName(WallHeadingHelper heading) {
        StrBuilder nameBuilder = new StrBuilder("h");
        nameBuilder.append(heading.getLevel());
        return nameBuilder.toString();
    }

    public String generateHeadEndTag(WallHead head) {
        return "</head>";
    }

    public String generateHrStartTag(WallHr hr) {
        return "";
    }

    public String generateHrEndTag(WallHr hr) {
        return "<hr/>";
    }

    public String generateImgStartTag(WallImg img) throws JspException {
        return "";
    }

    public String generateImgEndTag(WallImg img) throws JspException {
        boolean isInsideCoolMenu;
        boolean bl = isInsideCoolMenu = TagSupport.findAncestorWithClass((Tag)img, (Class)WallCool_menu.class) != null;
        if (isInsideCoolMenu) {
            return this.generateImgEndInsideCoolMenuTag(img);
        }
        return this.generateImgEndDefaultTag(img);
    }

    protected String generateImgEndDefaultTag(WallImg img) {
        return this.generateImgTag(img);
    }

    protected String generateImgEndInsideCoolMenuTag(WallImg img) {
        boolean performTabularization;
        WallCool_menu coolMenu = (WallCool_menu)TagSupport.findAncestorWithClass((Tag)img, (Class)WallCool_menu.class);
        boolean tableSupported = coolMenu.getDevice().isTableSupported();
        boolean bl = performTabularization = tableSupported && coolMenu.isTabularize();
        if (performTabularization) {
            return this.generateImgEndInsideCoolMenuTabularTag(img);
        }
        return this.generateImgEndInsideCoolMenuDefaultTag(img);
    }

    protected String generateImgEndInsideCoolMenuDefaultTag(WallImg img) {
        return this.generateImgTag(img);
    }

    protected String generateImgEndInsideCoolMenuTabularTag(WallImg img) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.appendText(this.generateImgTag(img));
        tagBuilder.openCloseElement("br");
        return tagBuilder.toMarkup();
    }

    protected String generateImgTag(WallImg img) {
        MarkupBuilder builder = new MarkupBuilder();
        if (img.getRenderAs() == 1) {
            builder.startOpenElement("img");
            builder.appendAttribute("src", img.getSrc());
            builder.appendAttribute("alt", img.getAlt());
            builder.endOpenCloseElement();
        } else if (img.getRenderAs() == 0) {
            builder.startOpenElement("img");
            builder.appendAttribute("localsrc", img.getIconSrc());
            builder.appendAttribute("alt", img.getAlt());
            builder.endOpenCloseElement();
        } else {
            this.log.debug((Object)"No image can be displayed");
        }
        return builder.toMarkup();
    }

    public String generateInputStartTag(WallInput tag) {
        if (StringUtils.equals((String)"submit", (String)tag.getType())) {
            return this.generateInputSubmitStartTag(tag);
        }
        if (StringUtils.equals((String)"hidden", (String)tag.getType())) {
            return this.generateInputHiddenStartTag(tag);
        }
        return this.generateInputDefaultStartTag(tag);
    }

    protected String generateInputSubmitStartTag(WallInput tag) {
        return "";
    }

    protected String generateInputHiddenStartTag(WallInput tag) {
        return this.generateInputDefaultStartTag(tag);
    }

    protected String generateInputDefaultStartTag(WallInput tag) {
        return "";
    }

    public String generateInputEndTag(WallInput input) throws JspException {
        return "";
    }

    public String generateMarqueeStartTag(WallMarquee marquee) {
        return "";
    }

    public String generateMarqueeEndTag(WallMarquee marquee) {
        return "";
    }

    public String generateMenuCssStartTag(WallMenu_css menuCss) {
        return "";
    }

    public String generateMenuCssEndTag(WallMenu_css menuCss) {
        return "";
    }

    public String generateOptionStartTag(WallOption tag) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("option").appendAttribute("value", ObjectUtils.toString((Object)tag.getValue())).endOpenElement();
        return tagBuilder.toString();
    }

    public String generateOptionEndTag(WallOption tag) {
        return "</option>";
    }

    public String generateSelectStartTag(WallSelect tag) {
        String multiple = null;
        if (StringUtils.trimToEmpty((String)tag.getMultiple()).equals("multiple")) {
            multiple = "multiple";
        }
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("select").appendAttribute("name", tag.getName()).appendAttribute("title", tag.getTitle()).appendAttribute("multiple", multiple).appendAttribute("size", tag.getSize()).endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateSelectEndTag(WallSelect tag) {
        return "</select>";
    }

    public String generateScriptStartTag(WallScript script) throws JspException {
        return "";
    }

    public String generateScriptEndTag(WallScript script) throws JspException {
        return "";
    }

    public String generateStyleStartTag(WallStyle style) throws JspException {
        return "";
    }

    public String generateStyleEndTag(WallStyle style) throws JspException {
        return "";
    }

    public String generateTitleStartTag(WallTitle title) {
        return "<title>";
    }

    public String generateTitleEndTag(WallTitle title) {
        MarkupBuilder builder = new MarkupBuilder();
        builder.appendText(title.getTitle()).closeElement("title");
        return builder.toMarkup();
    }

    public String generateXmlPIDTDStartTag(WallXmlpidtd dtd) {
        return "";
    }

    public String generateXmlPIDTDEndTag(WallXmlpidtd dtd) {
        StrBuilder tagBuilder = new StrBuilder("<?xml version=\"1.0\"");
        TagUtil.appendAttribute(tagBuilder, "encoding", dtd.getEncoding());
        tagBuilder.append("?>\n");
        String doctype = this.generateXmlPIDTDDocType(dtd);
        tagBuilder.append(doctype);
        return tagBuilder.toString();
    }

    protected String generateXmlPIDTDDocType(WallXmlpidtd dtd) {
        return "";
    }

    public boolean isAccessKeySupported(WallDevice device) {
        boolean supported = BooleanUtils.toBoolean((String)device.getCapability("access_key_support"));
        return supported;
    }

    public boolean isBackButtonSupported(WallDevice device) {
        boolean supported = BooleanUtils.toBoolean((String)device.getCapability("built_in_back_button_support"));
        return supported;
    }
}

