/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall.render;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import net.sourceforge.wurfl.core.Device;
import net.sourceforge.wurfl.wall.WallA;
import net.sourceforge.wurfl.wall.WallB;
import net.sourceforge.wurfl.wall.WallBlock;
import net.sourceforge.wurfl.wall.WallBody;
import net.sourceforge.wurfl.wall.WallCaller;
import net.sourceforge.wurfl.wall.WallCell;
import net.sourceforge.wurfl.wall.WallCool_menu;
import net.sourceforge.wurfl.wall.WallDocument;
import net.sourceforge.wurfl.wall.WallForm;
import net.sourceforge.wurfl.wall.WallHead;
import net.sourceforge.wurfl.wall.WallHeadingHelper;
import net.sourceforge.wurfl.wall.WallHr;
import net.sourceforge.wurfl.wall.WallInput;
import net.sourceforge.wurfl.wall.WallMenu;
import net.sourceforge.wurfl.wall.WallSelect;
import net.sourceforge.wurfl.wall.WallTitle;
import net.sourceforge.wurfl.wall.WallXmlpidtd;
import net.sourceforge.wurfl.wall.render.DefaultWallTagsHandler;
import net.sourceforge.wurfl.wall.utils.MarkupBuilder;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WmlTagsHandler
extends DefaultWallTagsHandler {
    private static final long serialVersionUID = 10L;
    private final Log log = LogFactory.getLog(this.getClass());

    protected String generateAnchorDefaultStartTag(WallA a) {
        boolean isAccessKeySupported = this.isAccessKeySupported(a.getDevice());
        boolean usingWmlExtension = a.getDocument().isUseWmlExtensions();
        boolean addAccessKey = isAccessKeySupported && usingWmlExtension;
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("a");
        tagBuilder.appendAttribute("href", a.getHref());
        tagBuilder.appendAttribute("title", a.getTitle());
        if (addAccessKey) {
            tagBuilder.appendAttribute("accesskey", a.getAccesskey());
        }
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    protected String generateAnchorMenuStartTag(WallA a) {
        boolean useSelect = this.isMenuWithSelectRecommended(a.getDevice());
        if (useSelect) {
            return this.generateAnchorMenuSelectStartTag(a);
        }
        return this.generateAnchorMenuDefaultStartTag(a);
    }

    protected String generateAnchorMenuDefaultStartTag(WallA a) {
        WallMenu menu = (WallMenu)TagSupport.findAncestorWithClass((Tag)a, (Class)WallMenu.class);
        boolean isAccessKeySupported = this.isAccessKeySupported(a.getDevice());
        boolean usingWmlExtension = a.getDocument().isUseWmlExtensions();
        boolean addAccessKey = isAccessKeySupported && usingWmlExtension;
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("a");
        tagBuilder.appendAttribute("href", a.getHref());
        tagBuilder.appendAttribute("title", a.getTitle());
        if (addAccessKey) {
            String accessKey = null;
            accessKey = menu.isAutonumber() ? String.valueOf(a.getMenuIndex() + 1) : a.getAccesskey();
            tagBuilder.appendAttribute("accesskey", accessKey);
        }
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    protected String generateAnchorMenuSelectStartTag(WallA a) {
        boolean addIcon = a.getDocument().isUseOpenWaveExtension() && StringUtils.isNotBlank((String)a.getOpwv_icon());
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("option");
        tagBuilder.appendAttribute("onpick", a.getHref());
        tagBuilder.appendAttribute("title", a.getTitle());
        tagBuilder.endOpenElement();
        if (addIcon) {
            tagBuilder.startOpenElement("img");
            tagBuilder.appendAttribute("localsrc", a.getOpwv_icon());
            tagBuilder.appendAttribute("src", "");
            tagBuilder.appendAttribute("alt", "");
            tagBuilder.endOpenCloseElement();
        }
        return tagBuilder.toMarkup();
    }

    protected String generateAnchorMenuEndTag(WallA a) {
        boolean useSelect = this.isMenuWithSelectRecommended(a.getDevice());
        if (useSelect) {
            return this.generateAnchorMenuSelectEndTag(a);
        }
        return this.generateAnchorMenuDefaultEndTag(a);
    }

    protected String generateAnchorMenuDefaultEndTag(WallA a) {
        return "</a><br/>";
    }

    protected String generateAnchorMenuSelectEndTag(WallA a) {
        return "</option>";
    }

    public String generateBoldStartTag(WallB b) {
        boolean insideA;
        boolean bl = insideA = TagSupport.findAncestorWithClass((Tag)b, (Class)WallA.class) != null;
        if (!insideA) {
            return "<b>";
        }
        return "";
    }

    public String generateBoldEndTag(WallB b) {
        boolean insideA;
        boolean bl = insideA = TagSupport.findAncestorWithClass((Tag)b, (Class)WallA.class) != null;
        if (!insideA) {
            return "</b>";
        }
        return "";
    }

    public String generateBlockStartTag(WallBlock block) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("p");
        if (StringUtils.equals((String)block.getAlign(), (String)"middle")) {
            tagBuilder.appendAttribute("align", "center");
        } else if (StringUtils.isNotBlank((String)block.getAlign())) {
            tagBuilder.appendAttribute("align", block.getAlign());
        }
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateBodyStartTag(WallBody body) {
        boolean isBackButtonSupported = this.isBackButtonSupported(body.getDevice());
        boolean isCardTitleSupported = this.isCardTitleSupported(body.getDevice());
        String title = body.getDocument().getTitle();
        MarkupBuilder tagBuilder = new MarkupBuilder();
        if (isBackButtonSupported && !body.isDisable_wml_template()) {
            tagBuilder.openElement("template");
            tagBuilder.startOpenElement("do");
            tagBuilder.appendAttribute("type", "prev");
            tagBuilder.appendAttribute("label", body.getWml_back_button_label());
            tagBuilder.endOpenElement();
            tagBuilder.openCloseElement("prev");
            tagBuilder.closeElement("do");
            tagBuilder.closeElement("template");
        }
        tagBuilder.startOpenElement("card");
        tagBuilder.appendAttribute("id", "w");
        tagBuilder.appendAttribute("title", title);
        if (body.isNewcontext()) {
            tagBuilder.appendAttribute("newcontext", "true");
        }
        tagBuilder.endOpenElement();
        if (!isCardTitleSupported && body.getDocument().isEnforceTitle()) {
            tagBuilder.appendNewLine();
            tagBuilder.openElement("p");
            tagBuilder.appendText(title);
            tagBuilder.closeElement("p");
        }
        return tagBuilder.toMarkup();
    }

    public String generateBodyEndTag(WallBody body) {
        return "</card>";
    }

    protected String generateCallerDefaultStartTag(WallCaller tag) {
        boolean isAccessKeySupported = this.isAccessKeySupported(tag.getDevice());
        boolean usingWmlExtension = tag.getDocument().isUseWmlExtensions();
        boolean addAccessKey = isAccessKeySupported && usingWmlExtension;
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("a");
        String callerPrefix = tag.getDevice().getCapability("wml_make_phone_call_string");
        if (StringUtils.equals((String)callerPrefix, (String)"none")) {
            tagBuilder.appendAttribute("href", "#");
            tagBuilder.endOpenElement();
            tagBuilder.appendText(tag.getAlt());
        } else {
            String href = new StrBuilder(callerPrefix).append(tag.getTel()).toString();
            tagBuilder.appendAttribute("href", href);
            tagBuilder.endOpenElement();
        }
        if (addAccessKey) {
            tagBuilder.appendAttribute("accesskey", tag.getAccesskey());
        }
        return tagBuilder.toMarkup();
    }

    protected String generateCallerMenuStartTag(WallCaller tag) {
        boolean useSelect = this.isMenuWithSelectRecommended(tag.getDevice());
        if (useSelect) {
            return this.generateCallerMenuSelectStartTag(tag);
        }
        return this.generateCallerMenuDefaultStartTag(tag);
    }

    protected String generateCallerMenuDefaultStartTag(WallCaller tag) {
        WallMenu menu = (WallMenu)TagSupport.findAncestorWithClass((Tag)tag, (Class)WallMenu.class);
        boolean isAccessKeySupported = this.isAccessKeySupported(tag.getDevice());
        boolean usingWmlExtension = tag.getDocument().isUseWmlExtensions();
        boolean addAccessKey = isAccessKeySupported && usingWmlExtension;
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("a");
        String callerPrefix = tag.getDevice().getCapability("wml_make_phone_call_string");
        if (StringUtils.equals((String)callerPrefix, (String)"none")) {
            tagBuilder.appendAttribute("href", "#");
            tagBuilder.endOpenElement();
            tagBuilder.appendText(tag.getAlt());
        } else {
            String href = new StrBuilder(callerPrefix).append(tag.getTel()).toString();
            tagBuilder.appendAttribute("href", href);
            tagBuilder.endOpenElement();
        }
        if (addAccessKey) {
            String accessKey = null;
            accessKey = menu.isAutonumber() ? String.valueOf(tag.getMenuIndex() + 1) : tag.getAccesskey();
            tagBuilder.appendAttribute("accesskey", accessKey);
        }
        return tagBuilder.toMarkup();
    }

    protected String generateCallerMenuSelectStartTag(WallCaller tag) {
        boolean addIcon = tag.getDocument().isUseOpenWaveExtension() && StringUtils.isNotBlank((String)tag.getOpwv_icon());
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("option");
        String callerPrefix = tag.getDevice().getCapability("wml_make_phone_call_string");
        if (StringUtils.equals((String)callerPrefix, (String)"none")) {
            tagBuilder.appendAttribute("onpick", "#");
            tagBuilder.endOpenElement();
            tagBuilder.appendText(tag.getAlt());
        } else {
            String href = new StrBuilder(callerPrefix).append(tag.getTel()).toString();
            tagBuilder.appendAttribute("onpick", href);
            tagBuilder.endOpenElement();
        }
        if (addIcon) {
            tagBuilder.startOpenElement("img");
            tagBuilder.appendAttribute("localsrc", tag.getOpwv_icon());
            tagBuilder.appendAttribute("src", "");
            tagBuilder.appendAttribute("alt", "");
            tagBuilder.endOpenCloseElement();
        }
        return tagBuilder.toMarkup();
    }

    protected String generateCallerMenuEndTag(WallCaller tag) {
        boolean useSelect = this.isMenuWithSelectRecommended(tag.getDevice());
        if (useSelect) {
            return this.generateCallerMenuSelectEndTag(tag);
        }
        return this.generateCallerMenuDefaultEndTag(tag);
    }

    protected String generateCallerMenuDefaultEndTag(WallCaller tag) {
        return "</a><br/>";
    }

    protected String generateCallerMenuSelectEndTag(WallCaller tag) {
        return "</option>";
    }

    public String generateCellStartTag(WallCell cell) {
        return "";
    }

    public String generateCellEndTag(WallCell cell) {
        return "<br/>";
    }

    public String generateCoolMenuStartTag(WallCool_menu coolMenu) throws JspException {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("p");
        tagBuilder.appendAttribute("align", "left");
        tagBuilder.appendAttribute("mode", "nowrap");
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateCoolMenuEndTag(WallCool_menu coolMenu) {
        return "</p>";
    }

    public String generateDocumentEndTag(WallDocument document) {
        return "</wml>";
    }

    public String generateFormStartTag(WallForm tag) throws JspException {
        if (tag.isEnable_wml()) {
            return "<p>";
        }
        return "<p>This page is not available to WAP 1.X devices.\nIf you think this is an error, please contact your service provider.</p>";
    }

    public String generateFormEndTag(WallForm tag) {
        if (tag.isEnable_wml()) {
            return "</p>";
        }
        return "";
    }

    public String generateHStartTag(WallHeadingHelper heading) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.openElement("p").openElement("b");
        return tagBuilder.toMarkup();
    }

    public String generateHEndTag(WallHeadingHelper heading) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.closeElement("b").closeElement("p");
        return tagBuilder.toMarkup();
    }

    public String generateHeadStartTag(WallHead head) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.openElement("wml").openElement("head");
        if (head.getDocument().isDisableCache()) {
            tagBuilder.appendNewLine();
            tagBuilder.startOpenElement("meta");
            tagBuilder.appendAttribute("forua", "true");
            tagBuilder.appendAttribute("http-equiv", "Cache-Control");
            tagBuilder.appendAttribute("content", "max-age=0");
            tagBuilder.endOpenCloseElement();
        }
        return tagBuilder.toMarkup();
    }

    public String generateHrEndTag(WallHr hr) {
        return new MarkupBuilder().openElement("p").appendText("---").closeElement("p").toMarkup();
    }

    protected String generateInputSubmitStartTag(WallInput tag) {
        String value;
        String name;
        String formAction = tag.getForm().getAction();
        String formMethod = tag.getForm().getMethod();
        boolean isSoftkeySupported = this.isSoftkeySupported(tag.getDevice());
        boolean isWwml13 = this.isWml13(tag.getDevice());
        boolean useSoftkey = isSoftkeySupported && !isWwml13;
        MarkupBuilder tagBuilder = new MarkupBuilder();
        if (useSoftkey) {
            tagBuilder.startOpenElement("do").appendAttribute("type", "accept").appendAttribute("label", tag.getValue()).endOpenElement().appendNewLine();
        } else {
            tagBuilder.openElement("anchor").appendText(tag.getValue()).appendNewLine();
        }
        tagBuilder.startOpenElement("go").appendAttribute("href", formAction).appendAttribute("method", formMethod).endOpenElement().appendNewLine();
        Iterator hiddenFieldsIterator = tag.getForm().getHiddenFields().entrySet().iterator();
        while (hiddenFieldsIterator.hasNext()) {
            Map.Entry hiddenField = hiddenFieldsIterator.next();
            name = (String)hiddenField.getKey();
            value = (String)hiddenField.getValue();
            this.addPostField(tagBuilder, name, value);
        }
        Iterator fieldsIterator = tag.getForm().getFields().iterator();
        while (fieldsIterator.hasNext()) {
            name = (String)fieldsIterator.next();
            value = new StrBuilder("$").append(name).toString();
            this.addPostField(tagBuilder, name, value);
        }
        tagBuilder.closeElement("go").appendNewLine();
        if (useSoftkey) {
            tagBuilder.closeElement("do").appendNewLine();
        } else {
            tagBuilder.closeElement("anchor").appendNewLine();
        }
        return tagBuilder.toMarkup();
    }

    protected void addPostField(MarkupBuilder builder, String name, String value) {
        this.log.debug((Object)("Adding postfield: " + name + " with value: " + value + "."));
        builder.startOpenElement("postfield");
        builder.appendAttribute("name", name);
        builder.appendAttribute("value", value);
        builder.endOpenCloseElement();
        builder.appendNewLine();
    }

    protected String generateInputHiddenStartTag(WallInput tag) {
        return "";
    }

    protected String generateInputDefaultStartTag(WallInput tag) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("input");
        tagBuilder.appendAttribute("type", tag.getType());
        tagBuilder.appendAttribute("name", tag.getName());
        tagBuilder.appendAttribute("value", tag.getValue());
        tagBuilder.appendAttribute("title", tag.getTitle());
        if (tag.getDevice().isAccessKeySupported()) {
            tagBuilder.appendAttribute("acceskey", tag.getAccesskey());
        }
        if (StringUtils.isNotBlank((String)tag.getEmptyok())) {
            tagBuilder.appendAttribute("emptyok", "false");
        }
        tagBuilder.appendAttribute("format", tag.getFormat());
        tagBuilder.appendAttribute("maxlength", tag.getMaxlength());
        tagBuilder.appendAttribute("size", tag.getSize());
        tagBuilder.endOpenCloseElement();
        return tagBuilder.toMarkup();
    }

    public String generateMenuStartTag(WallMenu menu) {
        boolean useSelect = this.isMenuWithSelectRecommended(menu.getDevice());
        if (useSelect) {
            return this.generateMenuSelectStartTag(menu);
        }
        return this.generateMenuDefaultStartTag(menu);
    }

    protected String generateMenuDefaultStartTag(WallMenu menu) {
        return "<p>";
    }

    protected String generateMenuSelectStartTag(WallMenu menu) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("p").appendAttribute("align", "left").appendAttribute("mode", "nowrap").endOpenElement();
        tagBuilder.openElement("select");
        return tagBuilder.toMarkup();
    }

    public String generateMenuEndTag(WallMenu menu) {
        boolean useSelect = this.isMenuWithSelectRecommended(menu.getDevice());
        if (useSelect) {
            return this.generateMenuSelectEndTag(menu);
        }
        return this.generateMenuDefaultEndTag(menu);
    }

    public String generateMenuSelectEndTag(WallMenu menu) {
        return "</select></p>";
    }

    public String generateMenuDefaultEndTag(WallMenu menu) {
        return "</p>";
    }

    public String generateSelectStartTag(WallSelect tag) {
        String multiple = null;
        if (StringUtils.trimToEmpty((String)tag.getMultiple()).equals("multiple")) {
            multiple = "true";
        }
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("select").appendAttribute("name", tag.getName()).appendAttribute("title", tag.getTitle()).appendAttribute("multiple", multiple).endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateTitleStartTag(WallTitle title) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("meta");
        tagBuilder.appendAttribute("name", "taglib");
        tagBuilder.appendAttribute("content", "WALL");
        tagBuilder.endOpenCloseElement();
        return tagBuilder.toMarkup();
    }

    public String generateTitleEndTag(WallTitle title) {
        return "";
    }

    protected String generateXmlPIDTDDocType(WallXmlpidtd dtd) {
        StrBuilder tagBuilder = new StrBuilder();
        boolean useOpwvDTD = dtd.getDocument().isUseWmlExtensions();
        if (useOpwvDTD) {
            tagBuilder.append("<!DOCTYPE wml PUBLIC \"-//OPENWAVE.COM//DTD WML 1.1//EN\" ");
            tagBuilder.append("\"http://www.openwave.com/dtd/wml11.dtd\" >");
        } else {
            tagBuilder.append("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" ");
            tagBuilder.append("\"http://www.wapforum.org/DTD/wml_1.1.xml\">");
        }
        return tagBuilder.toString();
    }

    public boolean isAccessKeySupported(Device device) {
        return false;
    }

    public boolean isMenuWithSelectRecommended(Device device) {
        boolean useSelect = BooleanUtils.toBoolean((String)device.getCapability("menu_with_select_element_recommended"));
        return useSelect;
    }

    public boolean isCardTitleSupported(Device device) {
        boolean supported = BooleanUtils.toBoolean((String)device.getCapability("card_title_support"));
        return supported;
    }

    public boolean isSoftkeySupported(Device device) {
        boolean supported = BooleanUtils.toBoolean((String)device.getCapability("softkey_support"));
        return supported;
    }

    public boolean isWml13(Device device) {
        boolean supported = BooleanUtils.toBoolean((String)device.getCapability("wml_1_3"));
        return supported;
    }
}

