/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall.render;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import net.sourceforge.wurfl.core.Device;
import net.sourceforge.wurfl.wall.WallA;
import net.sourceforge.wurfl.wall.WallB;
import net.sourceforge.wurfl.wall.WallBlock;
import net.sourceforge.wurfl.wall.WallBody;
import net.sourceforge.wurfl.wall.WallBr;
import net.sourceforge.wurfl.wall.WallCaller;
import net.sourceforge.wurfl.wall.WallCell;
import net.sourceforge.wurfl.wall.WallCool_menu;
import net.sourceforge.wurfl.wall.WallCool_menu_css;
import net.sourceforge.wurfl.wall.WallFont;
import net.sourceforge.wurfl.wall.WallForm;
import net.sourceforge.wurfl.wall.WallHead;
import net.sourceforge.wurfl.wall.WallHeadingHelper;
import net.sourceforge.wurfl.wall.WallHr;
import net.sourceforge.wurfl.wall.WallImg;
import net.sourceforge.wurfl.wall.WallInput;
import net.sourceforge.wurfl.wall.WallMarquee;
import net.sourceforge.wurfl.wall.WallMenu;
import net.sourceforge.wurfl.wall.WallMenu_css;
import net.sourceforge.wurfl.wall.WallOption;
import net.sourceforge.wurfl.wall.WallScript;
import net.sourceforge.wurfl.wall.WallXmlpidtd;
import net.sourceforge.wurfl.wall.render.DefaultWallTagsHandler;
import net.sourceforge.wurfl.wall.utils.CssStyleBuilder;
import net.sourceforge.wurfl.wall.utils.MarkupBuilder;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XhtmlMPTagsHandler
extends DefaultWallTagsHandler {
    private static final long serialVersionUID = 10L;
    private final Log log = LogFactory.getLog(this.getClass());

    protected String generateAnchorDefaultStartTag(WallA a) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("a");
        tagBuilder.appendAttribute("id", a.getId());
        tagBuilder.appendAttribute("class", a.getCssClass());
        tagBuilder.appendAttribute("style", a.getCssStyle());
        tagBuilder.appendAttribute("href", a.getHref());
        tagBuilder.appendAttribute("title", a.getTitle());
        tagBuilder.appendAttribute("accesskey", a.getAccesskey());
        tagBuilder.endOpenElement();
        return tagBuilder.toString();
    }

    protected String generateAnchorMenuStartTag(WallA a) {
        boolean createFancyAnchor;
        WallMenu menu = a.getMenu();
        boolean bl = createFancyAnchor = menu.isColorize() && this.isCssTableSupported(a.getDevice());
        if (createFancyAnchor) {
            return this.generateAnchorMenuFancyStartTag(a);
        }
        return this.generateAnchorMenuDefaultStartTag(a);
    }

    protected String generateAnchorMenuFancyStartTag(WallA a) {
        WallMenu menu = a.getMenu();
        boolean mustGenerateIcon = StringUtils.isNotBlank((String)a.getOpwv_icon()) && a.getDocument().isUseXhtmlExtensions();
        String cssClass = null;
        cssClass = StringUtils.isNotBlank((String)a.getCssClass()) ? a.getCssClass() : (a.getMenuIndex() % 2 == 0 ? "bgcolor1" : "bgcolor2");
        String accessKey = null;
        accessKey = menu.isAutonumber() ? String.valueOf(a.getMenuIndex() + 1) : a.getAccesskey();
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.openElement("tr").appendNewLine();
        tagBuilder.startOpenElement("td");
        tagBuilder.appendAttribute("class", cssClass);
        tagBuilder.endOpenElement();
        if (mustGenerateIcon) {
            tagBuilder.startOpenElement("img");
            tagBuilder.appendAttribute("localsrc", a.getOpwv_icon());
            tagBuilder.appendAttribute("src", "");
            tagBuilder.appendAttribute("alt", "");
            tagBuilder.endOpenCloseElement();
        }
        if (StringUtils.isNotBlank((String)accessKey)) {
            tagBuilder.appendText(" ").appendText(accessKey).appendText(" ");
        }
        tagBuilder.startOpenElement("a");
        tagBuilder.appendAttribute("id", a.getId());
        tagBuilder.appendAttribute("class", a.getCssClass());
        tagBuilder.appendAttribute("style", a.getCssStyle());
        tagBuilder.appendAttribute("href", a.getHref());
        tagBuilder.appendAttribute("title", a.getTitle());
        tagBuilder.appendAttribute("accesskey", accessKey);
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    protected String generateAnchorMenuDefaultStartTag(WallA a) {
        WallMenu menu = a.getMenu();
        boolean mustGenerateIcon = StringUtils.isNotBlank((String)a.getOpwv_icon()) && a.getDocument().isUseXhtmlExtensions();
        String accessKey = null;
        accessKey = menu.isAutonumber() ? String.valueOf(a.getMenuIndex() + 1) : a.getAccesskey();
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.openElement("li");
        if (mustGenerateIcon) {
            tagBuilder.startOpenElement("img");
            tagBuilder.appendAttribute("localsrc", a.getOpwv_icon());
            tagBuilder.appendAttribute("src", "");
            tagBuilder.appendAttribute("alt", "");
            tagBuilder.endOpenCloseElement();
        }
        tagBuilder.startOpenElement("a");
        tagBuilder.appendAttribute("id", a.getId());
        tagBuilder.appendAttribute("class", a.getCssClass());
        tagBuilder.appendAttribute("style", a.getCssStyle());
        tagBuilder.appendAttribute("href", a.getHref());
        tagBuilder.appendAttribute("title", a.getTitle());
        tagBuilder.appendAttribute("accesskey", accessKey);
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateAnchorMenuEndTag(WallA a) {
        boolean createFancyAnchor;
        WallMenu menu = (WallMenu)TagSupport.findAncestorWithClass((Tag)a, (Class)WallMenu.class);
        boolean bl = createFancyAnchor = menu.isColorize() && this.isCssTableSupported(a.getDevice());
        if (createFancyAnchor) {
            return this.generateAnchorMenuFancyEndTag(a);
        }
        return this.generateAnchorMenuDefaultEndTag(a);
    }

    public String generateAnchorMenuFancyEndTag(WallA a) {
        return new MarkupBuilder().closeElement("a").closeElement("td").appendNewLine().closeElement("tr").toMarkup();
    }

    public String generateAnchorMenuDefaultEndTag(WallA a) {
        return "</a></li>";
    }

    public String generateBoldStartTag(WallB b) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("b");
        tagBuilder.appendAttribute("id", b.getId());
        tagBuilder.appendAttribute("class", b.getCssClass());
        tagBuilder.appendAttribute("style", b.getCssStyle());
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateBrStartTag(WallBr br) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("br");
        tagBuilder.appendAttribute("id", br.getId());
        tagBuilder.appendAttribute("class", br.getCssClass());
        tagBuilder.appendAttribute("style", br.getCssStyle());
        tagBuilder.endOpenCloseElement();
        return tagBuilder.toString();
    }

    public String generateBodyStartTag(WallBody body) {
        CssStyleBuilder styleBuilder = new CssStyleBuilder();
        styleBuilder.appendProperty("color", body.getText());
        styleBuilder.appendProperty("background-color", body.getBgcolor());
        styleBuilder.appendStyle(body.getCssStyle());
        String style = styleBuilder.toCssStyle();
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("body");
        tagBuilder.appendAttribute("id", body.getId());
        tagBuilder.appendAttribute("class", body.getCssClass());
        tagBuilder.appendAttribute("style", style);
        tagBuilder.endOpenElement();
        if (body.getDocument().isEnforceTitle() && !this.isTitleSupported(body.getDevice())) {
            tagBuilder.appendNewLine();
            tagBuilder.openElement("p");
            tagBuilder.appendText(body.getDocument().getTitle());
            tagBuilder.closeElement("p");
        }
        return tagBuilder.toMarkup();
    }

    public String generateBlockStartTag(WallBlock block) {
        CssStyleBuilder styleBuilder = new CssStyleBuilder();
        if (StringUtils.equals((String)block.getAlign(), (String)"middle")) {
            styleBuilder.appendProperty("text-align", "center");
        } else if (StringUtils.isNotBlank((String)block.getAlign())) {
            styleBuilder.appendProperty("text-align", block.getAlign());
        }
        styleBuilder.appendStyle(block.getCssStyle());
        String style = styleBuilder.toCssStyle();
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("p");
        tagBuilder.appendAttribute("id", block.getId());
        tagBuilder.appendAttribute("class", block.getCssClass());
        tagBuilder.appendAttribute("style", style);
        tagBuilder.endOpenElement();
        return tagBuilder.toString();
    }

    protected String generateCallerDefaultStartTag(WallCaller tag) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        String callPrefix = tag.getDevice().getCapability("xhtml_make_phone_call_string");
        if (StringUtils.equals((String)callPrefix, (String)"none")) {
            String href = "#";
            tagBuilder.startOpenElement("a");
            tagBuilder.appendAttribute("id", tag.getId());
            tagBuilder.appendAttribute("class", tag.getCssClass());
            tagBuilder.appendAttribute("style", tag.getCssStyle());
            tagBuilder.appendAttribute("href", href);
            tagBuilder.appendAttribute("accesskey", tag.getAccesskey());
            tagBuilder.endOpenElement();
            tagBuilder.appendText(tag.getAlt());
        } else {
            String href = new StrBuilder(callPrefix).append(tag.getTel()).toString();
            tagBuilder.startOpenElement("a");
            tagBuilder.appendAttribute("id", tag.getId());
            tagBuilder.appendAttribute("class", tag.getCssClass());
            tagBuilder.appendAttribute("style", tag.getCssStyle());
            tagBuilder.appendAttribute("href", href);
            tagBuilder.appendAttribute("accesskey", tag.getAccesskey());
            tagBuilder.endOpenElement();
        }
        return tagBuilder.toString();
    }

    protected String generateCallerMenuStartTag(WallCaller tag) {
        boolean createFancyAnchor;
        WallMenu menu = (WallMenu)TagSupport.findAncestorWithClass((Tag)tag, (Class)WallMenu.class);
        boolean bl = createFancyAnchor = menu.isColorize() && this.isCssTableSupported(tag.getDevice());
        if (createFancyAnchor) {
            return this.generateCallerMenuFancyStartTag(tag);
        }
        return this.generateCallerMenuDefaultStartTag(tag);
    }

    protected String generateCallerMenuFancyStartTag(WallCaller tag) {
        String callPrefix;
        WallMenu menu = (WallMenu)TagSupport.findAncestorWithClass((Tag)tag, (Class)WallMenu.class);
        boolean mustGenerateIcon = StringUtils.isNotBlank((String)tag.getOpwv_icon()) && tag.getDocument().isUseXhtmlExtensions();
        String cssClass = null;
        cssClass = StringUtils.isNotBlank((String)tag.getCssClass()) ? tag.getCssClass() : (tag.getMenuIndex() % 2 == 0 ? "bgcolor1" : "bgcolor2");
        String accessKey = null;
        accessKey = menu.isAutonumber() ? String.valueOf(tag.getMenuIndex() + 1) : tag.getAccesskey();
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.openElement("tr").appendNewLine();
        tagBuilder.startOpenElement("td");
        tagBuilder.appendAttribute("class", cssClass);
        tagBuilder.endOpenElement();
        if (mustGenerateIcon) {
            tagBuilder.startOpenElement("img");
            tagBuilder.appendAttribute("localsrc", tag.getOpwv_icon());
            tagBuilder.appendAttribute("src", "");
            tagBuilder.appendAttribute("alt", "");
            tagBuilder.endOpenCloseElement();
        }
        if (StringUtils.isNotBlank((String)accessKey)) {
            tagBuilder.appendText(" ").appendText(accessKey).appendText(" ");
        }
        if (StringUtils.equals((String)(callPrefix = tag.getDevice().getCapability("xhtml_make_phone_call_string")), (String)"none")) {
            String href = "#";
            tagBuilder.startOpenElement("a");
            tagBuilder.appendAttribute("id", tag.getId());
            tagBuilder.appendAttribute("class", cssClass);
            tagBuilder.appendAttribute("style", tag.getCssStyle());
            tagBuilder.appendAttribute("href", href);
            tagBuilder.appendAttribute("accesskey", accessKey);
            tagBuilder.endOpenElement();
            tagBuilder.appendText(tag.getAlt());
        } else {
            String href = new StrBuilder(callPrefix).append(tag.getTel()).toString();
            tagBuilder.startOpenElement("a");
            tagBuilder.appendAttribute("id", tag.getId());
            tagBuilder.appendAttribute("class", cssClass);
            tagBuilder.appendAttribute("style", tag.getCssStyle());
            tagBuilder.appendAttribute("href", href);
            tagBuilder.appendAttribute("accesskey", accessKey);
            tagBuilder.endOpenElement();
        }
        return tagBuilder.toMarkup();
    }

    protected String generateCallerMenuDefaultStartTag(WallCaller tag) {
        String callPrefix;
        WallMenu menu = (WallMenu)TagSupport.findAncestorWithClass((Tag)tag, (Class)WallMenu.class);
        boolean mustGenerateIcon = StringUtils.isNotBlank((String)tag.getOpwv_icon()) && tag.getDocument().isUseXhtmlExtensions();
        String accessKey = null;
        accessKey = menu.isAutonumber() ? String.valueOf(tag.getMenuIndex() + 1) : tag.getAccesskey();
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.openElement("li");
        if (mustGenerateIcon) {
            tagBuilder.startOpenElement("img");
            tagBuilder.appendAttribute("localsrc", tag.getOpwv_icon());
            tagBuilder.appendAttribute("src", "");
            tagBuilder.appendAttribute("alt", "");
            tagBuilder.endOpenCloseElement();
        }
        if (StringUtils.equals((String)(callPrefix = tag.getDevice().getCapability("xhtml_make_phone_call_string")), (String)"none")) {
            String href = "#";
            tagBuilder.startOpenElement("a");
            tagBuilder.appendAttribute("id", tag.getId());
            tagBuilder.appendAttribute("class", tag.getCssClass());
            tagBuilder.appendAttribute("style", tag.getCssStyle());
            tagBuilder.appendAttribute("href", href);
            tagBuilder.appendAttribute("accesskey", accessKey);
            tagBuilder.endOpenElement();
            tagBuilder.appendText(tag.getAlt());
        } else {
            String href = new StrBuilder(callPrefix).append(tag.getTel()).toString();
            tagBuilder.startOpenElement("a");
            tagBuilder.appendAttribute("id", tag.getId());
            tagBuilder.appendAttribute("class", tag.getCssClass());
            tagBuilder.appendAttribute("style", tag.getCssStyle());
            tagBuilder.appendAttribute("href", href);
            tagBuilder.appendAttribute("accesskey", accessKey);
            tagBuilder.endOpenElement();
        }
        return tagBuilder.toMarkup();
    }

    public String generateCallerMenuEndTag(WallCaller tag) {
        boolean createFancyAnchor;
        WallMenu menu = (WallMenu)TagSupport.findAncestorWithClass((Tag)tag, (Class)WallMenu.class);
        boolean bl = createFancyAnchor = menu.isColorize() && this.isCssTableSupported(tag.getDevice());
        if (createFancyAnchor) {
            return this.generateCallerMenuFancyEndTag(tag);
        }
        return this.generateCallerMenuDefaultEndTag(tag);
    }

    public String generateCallerMenuFancyEndTag(WallCaller tag) {
        return new MarkupBuilder().closeElement("a").closeElement("td").appendNewLine().closeElement("tr").toMarkup();
    }

    public String generateCallerMenuDefaultEndTag(WallCaller tag) {
        return "</a></li>";
    }

    public String generateFormStartTag(WallForm tag) throws JspException {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("form");
        tagBuilder.appendAttribute("id", tag.getId());
        tagBuilder.appendAttribute("class", tag.getCssClass());
        tagBuilder.appendAttribute("style", tag.getCssStyle());
        tagBuilder.appendAttribute("action", tag.getAction());
        tagBuilder.appendAttribute("method", tag.getMethod());
        tagBuilder.endOpenElement();
        tagBuilder.appendNewLine();
        tagBuilder.startOpenElement("p");
        tagBuilder.appendAttribute("class", tag.getCssClass());
        tagBuilder.appendAttribute("style", tag.getCssStyle());
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateFormEndTag(WallForm tag) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.closeElement("p").appendNewLine().closeElement("form");
        return tagBuilder.toMarkup();
    }

    public String generateHStartTag(WallHeadingHelper heading) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement(this.generateHeadingName(heading));
        tagBuilder.appendAttribute("id", heading.getId());
        tagBuilder.appendAttribute("class", heading.getCssClass());
        tagBuilder.appendAttribute("style", heading.getCssStyle());
        tagBuilder.endOpenElement();
        return tagBuilder.toString();
    }

    public String generateHeadStartTag(WallHead head) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("html").appendAttribute("xmlns", "http://www.w3.org/1999/xhtml").appendAttribute("xml:lang", "en").endOpenElement().appendNewLine();
        tagBuilder.openElement("head").appendNewLine();
        if (head.getDocument().isDisableCache()) {
            tagBuilder.startOpenElement("meta").appendAttribute("http-equiv", "Cache-Control").appendAttribute("content", "max-age=0").endOpenCloseElement().appendNewLine();
            tagBuilder.startOpenElement("meta").appendAttribute("http-equiv", "Cache-Control").appendAttribute("content", "no-store").endOpenCloseElement().appendNewLine();
        }
        return tagBuilder.toMarkup();
    }

    public String generateHeadEndTag(WallHead head) {
        boolean hasStyle = StringUtils.isNotBlank((String)head.getStyle());
        MarkupBuilder tagBuilder = new MarkupBuilder();
        if (hasStyle) {
            tagBuilder.startOpenElement("style").appendAttribute("type", "text/css").endOpenElement().appendNewLine();
            tagBuilder.appendText(head.getStyle()).appendNewLine();
            tagBuilder.closeElement("style").appendNewLine();
        }
        tagBuilder.closeElement("head");
        return tagBuilder.toMarkup();
    }

    public String generateHrEndTag(WallHr hr) {
        CssStyleBuilder cssStyleBuilder = new CssStyleBuilder();
        cssStyleBuilder.appendProperty("border-color", hr.getColor());
        cssStyleBuilder.appendProperty("background-color", hr.getColor());
        cssStyleBuilder.appendStyle(hr.getCssStyle());
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("hr");
        tagBuilder.appendAttribute("id", hr.getId());
        tagBuilder.appendAttribute("class", hr.getCssClass());
        tagBuilder.appendAttribute("style", cssStyleBuilder.toString());
        tagBuilder.appendAttribute("color", hr.getColor());
        tagBuilder.endOpenCloseElement();
        return tagBuilder.toMarkup();
    }

    protected String generateInputDefaultStartTag(WallInput tag) {
        CssStyleBuilder styleBuilder = new CssStyleBuilder();
        if (StringUtils.isNotBlank((String)tag.getCssStyle())) {
            styleBuilder.appendStyle(tag.getCssStyle());
        }
        if (this.isFormatAsCssSupported(tag.getDevice())) {
            if (StringUtils.isNotBlank((String)tag.getFormat())) {
                String formatValue = new StrBuilder("'").append(tag.getFormat()).append("'").toString();
                styleBuilder.appendProperty("-wap-input-format", formatValue);
            }
            if (StringUtils.isNotBlank((String)tag.getEmptyok())) {
                styleBuilder.appendStyle("-wap-input-required");
            }
        }
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("input");
        tagBuilder.appendAttribute("id", tag.getId());
        tagBuilder.appendAttribute("class", tag.getCssClass());
        tagBuilder.appendAttribute("style", styleBuilder.toCssStyle());
        tagBuilder.appendAttribute("type", tag.getType());
        tagBuilder.appendAttribute("name", tag.getName());
        tagBuilder.appendAttribute("value", tag.getValue());
        tagBuilder.appendAttribute("title", tag.getTitle());
        tagBuilder.appendAttribute("checked", tag.getChecked());
        tagBuilder.appendAttribute("disabled", tag.getDisabled());
        tagBuilder.appendAttribute("acceskey", tag.getAccesskey());
        tagBuilder.appendAttribute("maxlength", tag.getMaxlength());
        tagBuilder.appendAttribute("size", tag.getSize());
        if (!this.isFormatAsCssSupported(tag.getDevice()) && this.isFormatAsAttributeSupported(tag.getDevice())) {
            tagBuilder.appendAttribute("format", tag.getFormat());
            tagBuilder.appendAttribute("emptyok", "emptyok");
        }
        tagBuilder.endOpenCloseElement();
        return tagBuilder.toMarkup();
    }

    protected String generateInputSubmitStartTag(WallInput tag) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("input");
        tagBuilder.appendAttribute("id", tag.getId());
        tagBuilder.appendAttribute("class", tag.getCssClass());
        tagBuilder.appendAttribute("style", tag.getCssStyle());
        tagBuilder.appendAttribute("type", "submit");
        tagBuilder.appendAttribute("value", tag.getValue());
        tagBuilder.endOpenCloseElement();
        return tagBuilder.toMarkup();
    }

    public String generateMarqueeStartTag(WallMarquee marquee) {
        boolean isNowrapModeSupported = this.isNowrapModeSupported(marquee.getDevice());
        boolean isMarqueeAsCssSupported = this.isMarqueeAsCssSupported(marquee.getDevice());
        MarkupBuilder tagBuilder = new MarkupBuilder();
        if (isMarqueeAsCssSupported) {
            tagBuilder.startOpenElement("div");
            tagBuilder.appendAttribute("id", marquee.getId());
            CssStyleBuilder styleBuilder = new CssStyleBuilder();
            styleBuilder.appendProperty("display", "-wap-marquee");
            styleBuilder.appendProperty("-wap-marquee-style", marquee.getBehavior());
            if (StringUtils.isNotBlank((String)marquee.getDirection())) {
                String direction = "ltr";
                if (StringUtils.equals((String)"left", (String)marquee.getDirection())) {
                    direction = "rtl";
                }
                styleBuilder.appendProperty("-wap-marquee-dir", direction);
            }
            styleBuilder.appendProperty("-wap-marquee-loop", marquee.getLoop());
            styleBuilder.appendProperty("background-color", marquee.getBgcolor());
            tagBuilder.appendAttribute("style", styleBuilder.toCssStyle());
            tagBuilder.endOpenElement();
        } else if (isNowrapModeSupported) {
            tagBuilder.startOpenElement("div");
            tagBuilder.appendAttribute("id", marquee.getId());
            tagBuilder.appendAttribute("mode", "nowrap");
            tagBuilder.endOpenElement();
        }
        return tagBuilder.toString();
    }

    public String generateMarqueeEndTag(WallMarquee marquee) {
        boolean isNowrapModeSupported = this.isNowrapModeSupported(marquee.getDevice());
        boolean isMarqueeAsCssSupported = this.isMarqueeAsCssSupported(marquee.getDevice());
        MarkupBuilder tagBuilder = new MarkupBuilder();
        if (isMarqueeAsCssSupported || isNowrapModeSupported) {
            tagBuilder.closeElement("div");
        }
        return tagBuilder.toString();
    }

    public String generateMenuCssEndTag(WallMenu_css menuCss) {
        StrBuilder tagBuilder = new StrBuilder();
        boolean generateCss = this.isCssTableSupported(menuCss.getDevice());
        if (generateCss) {
            String oddBackgroundColor = menuCss.getBgcolor1();
            String evenBackgroundColor = menuCss.getBgcolor2();
            if (StringUtils.isBlank((String)oddBackgroundColor)) {
                oddBackgroundColor = menuCss.getDevice().getCapability("xhtml_readable_background_color1");
            }
            if (StringUtils.isBlank((String)evenBackgroundColor)) {
                oddBackgroundColor = menuCss.getDevice().getCapability("xhtml_readable_background_color2");
            }
            tagBuilder.append("  .bgcolor1 { background-color:");
            tagBuilder.append(oddBackgroundColor);
            tagBuilder.append(";}\n");
            tagBuilder.append("  .bgcolor2 { background-color:");
            tagBuilder.append(evenBackgroundColor);
            tagBuilder.append(";}\n");
        }
        return tagBuilder.toString();
    }

    public String generateMenuStartTag(WallMenu menu) {
        boolean willGenerateCssTableMenu = menu.isColorize() && this.isCssTableSupported(menu.getDevice());
        MarkupBuilder tagBuilder = new MarkupBuilder();
        if (willGenerateCssTableMenu) {
            tagBuilder.startOpenElement("table");
        } else {
            tagBuilder.startOpenElement("ol");
        }
        tagBuilder.appendAttribute("id", menu.getId());
        tagBuilder.appendAttribute("class", menu.getCssClass());
        tagBuilder.appendAttribute("style", menu.getCssStyle());
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateMenuEndTag(WallMenu menu) {
        boolean willGenerateCssTableMenu;
        boolean bl = willGenerateCssTableMenu = menu.isColorize() && this.isCssTableSupported(menu.getDevice());
        if (willGenerateCssTableMenu) {
            return "</table>";
        }
        return "</ol>";
    }

    public String generateOptionStartTag(WallOption tag) {
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("option");
        tagBuilder.appendAttribute("id", tag.getId());
        tagBuilder.appendAttribute("class", tag.getCssClass());
        tagBuilder.appendAttribute("style", tag.getCssStyle());
        tagBuilder.appendAttribute("value", ObjectUtils.toString((Object)tag.getValue()));
        if (StringUtils.equals((String)"selected", (String)StringUtils.trimToNull((String)tag.getSelected()))) {
            tagBuilder.appendAttribute("selected", "selected");
        }
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    protected String generateCellTabularStartTag(WallCell tag) {
        String cssClass = "coolmenu";
        MarkupBuilder tagBuilder = new MarkupBuilder();
        if (tag.isFirstRowCell()) {
            tagBuilder.startOpenElement("tr");
            tagBuilder.appendAttribute("class", cssClass);
            tagBuilder.endOpenElement();
        }
        tagBuilder.startOpenElement("td");
        tagBuilder.appendAttribute("class", cssClass);
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateCoolMenuCssEndTag(WallCool_menu_css coolMenuCss) throws JspException {
        boolean willGenerateCssTableMenu;
        boolean bl = willGenerateCssTableMenu = coolMenuCss.isTabularize() && coolMenuCss.getDevice().isTableSupported();
        if (willGenerateCssTableMenu) {
            String width = new StrBuilder().append((int)(coolMenuCss.getWidth() * 100.0f)).append("%").toString();
            StrBuilder tagBuilder = new StrBuilder();
            tagBuilder.append(" table.coolmenu {width:100%}\n");
            tagBuilder.append(" td.coolmenu {").append("text-align: center; ").append("font-size: smaller; ").append("width: ").append(width).append("; ").append("vertical-align: top;");
            tagBuilder.append("}\n");
            tagBuilder.append(" img.coolmenu {vertical-align:top;}\n");
            coolMenuCss.getHead().appendStyle(tagBuilder.toString());
        }
        return "";
    }

    protected String generateCoolMenuDefaultStartTag(WallCool_menu tag) throws JspException {
        String cssClass = "coolmenu";
        MarkupBuilder markupBuilder = new MarkupBuilder();
        markupBuilder.startOpenElement("p");
        markupBuilder.appendAttribute("id", tag.getId());
        markupBuilder.appendAttribute("class", cssClass);
        markupBuilder.endOpenElement();
        return markupBuilder.toMarkup();
    }

    public String generateCoolMenuTabularStartTag(WallCool_menu tag) throws JspException {
        String cssClass = "coolmenu";
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("table").appendAttribute("id", tag.getId()).appendAttribute("class", cssClass).endOpenElement();
        return tagBuilder.toMarkup();
    }

    protected String generateCoolMenuTabularEmptyCell(WallCool_menu tag) {
        String cssClass = "coolmenu";
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("td").appendAttribute("class", cssClass).endOpenElement().closeElement("td");
        return tagBuilder.toMarkup();
    }

    protected String generateImgTag(WallImg img) {
        boolean isInsideCoolMenu;
        String cssClass = img.getCssClass();
        boolean bl = isInsideCoolMenu = TagSupport.findAncestorWithClass((Tag)img, (Class)WallCool_menu.class) != null;
        if (isInsideCoolMenu && StringUtils.isBlank((String)cssClass)) {
            WallCool_menu coolMenu = (WallCool_menu)TagSupport.findAncestorWithClass((Tag)img, (Class)WallCool_menu.class);
            cssClass = "coolmenu";
        }
        MarkupBuilder builder = new MarkupBuilder();
        if (img.getRenderAs() == 1) {
            builder.startOpenElement("img");
            builder.appendAttribute("id", img.getId());
            builder.appendAttribute("class", cssClass);
            builder.appendAttribute("style", img.getCssStyle());
            builder.appendAttribute("src", img.getSrc());
            builder.appendAttribute("alt", img.getAlt());
            builder.endOpenCloseElement();
        } else if (img.getRenderAs() == 0 && img.getDocument().isUseXhtmlExtensions()) {
            builder.startOpenElement("img");
            builder.appendAttribute("id", img.getId());
            builder.appendAttribute("class", cssClass);
            builder.appendAttribute("style", img.getCssStyle());
            builder.appendAttribute("localsrc", img.getIconSrc());
            builder.appendAttribute("alt", img.getAlt());
            builder.endOpenCloseElement();
        } else {
            this.log.debug((Object)"No image can be displayed");
        }
        return builder.toMarkup();
    }

    protected String generateXmlPIDTDDocType(WallXmlpidtd dtd) {
        return "<!DOCTYPE html PUBLIC \"-//WAPFORUM//DTD XHTML Mobile 1.0//EN\" \"http://www.wapforum.org/DTD/xhtml-mobile10.dtd\">";
    }

    public String generateScriptEndTag(WallScript script) throws JspException {
        if (this.isJavascriptSupported(script.getDevice())) {
            MarkupBuilder tagBuilder = new MarkupBuilder();
            tagBuilder.startOpenElement("script").appendAttribute("type", script.getType()).endOpenElement();
            tagBuilder.appendNewLine().appendText(script.getScript()).appendNewLine();
            tagBuilder.closeElement("script");
            return tagBuilder.toMarkup();
        }
        return "";
    }

    public String generateFontStartTag(WallFont font) {
        CssStyleBuilder styleBuilder = new CssStyleBuilder();
        styleBuilder.appendProperty("color", font.getColor());
        styleBuilder.appendProperty("font-family", font.getFace());
        if (StringUtils.equals((String)"+1", (String)font.getSize())) {
            styleBuilder.appendProperty("font-size", "larger");
        } else if (StringUtils.equals((String)"-1", (String)font.getSize())) {
            styleBuilder.appendProperty("font-size", "smaller");
        }
        styleBuilder.appendStyle(font.getCssStyle());
        MarkupBuilder tagBuilder = new MarkupBuilder();
        tagBuilder.startOpenElement("span");
        tagBuilder.appendAttribute("id", font.getId());
        tagBuilder.appendAttribute("class", font.getCssClass());
        tagBuilder.appendAttribute("style", styleBuilder.toCssStyle());
        tagBuilder.endOpenElement();
        return tagBuilder.toMarkup();
    }

    public String generateFontEndTag(WallFont font) {
        return "</span>";
    }

    protected boolean isCssTableSupported(Device device) {
        boolean isCssCellTableColoringSupported = BooleanUtils.toBoolean((String)device.getCapability("xhtml_supports_css_cell_table_coloring"));
        boolean isTableForLayoutSupported = BooleanUtils.toBoolean((String)device.getCapability("xhtml_supports_table_for_layout"));
        boolean isCssTableSupported = isCssCellTableColoringSupported && isTableForLayoutSupported;
        return isCssTableSupported;
    }

    protected boolean isTitleSupported(Device device) {
        return BooleanUtils.toBoolean((String)device.getCapability("xhtml_document_title_support"));
    }

    protected boolean isNowrapModeSupported(Device device) {
        boolean supported = BooleanUtils.toBoolean((String)device.getCapability("xhtml_nowrap_mode"));
        return supported;
    }

    protected boolean isMarqueeAsCssSupported(Device device) {
        boolean supported = BooleanUtils.toBoolean((String)device.getCapability("xhtml_marquee_as_css_property"));
        return supported;
    }

    public boolean isJavascriptSupported(Device device) {
        return BooleanUtils.toBoolean((String)device.getCapability("ajax_support_javascript"));
    }

    public boolean isFormatAsCssSupported(Device device) {
        boolean supported = BooleanUtils.toBoolean((String)device.getCapability("xhtml_format_as_css_property"));
        return supported;
    }

    public boolean isFormatAsAttributeSupported(Device device) {
        boolean supported = BooleanUtils.toBoolean((String)device.getCapability("xhtml_format_as_attribute"));
        return supported;
    }
}

