/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall.utils;

import java.io.Serializable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CssStyleBuilder
implements Serializable {
    private static final long serialVersionUID = 10L;
    private final Log log = LogFactory.getLog(this.getClass());
    private final StrBuilder buffer = new StrBuilder();

    public CssStyleBuilder appendProperty(String name, Object value) {
        String valueText = ObjectUtils.toString((Object)value);
        if (StringUtils.isNotBlank((String)valueText)) {
            if (!this.buffer.isEmpty() && !this.buffer.endsWith(";")) {
                this.buffer.append(";");
            }
            this.buffer.append(name).append(":").append(valueText);
        }
        return this;
    }

    public CssStyleBuilder appendStyle(String style) {
        if (StringUtils.isNotBlank((String)style)) {
            if (!this.buffer.isEmpty() && !this.buffer.endsWith(";")) {
                this.buffer.append(";");
            }
            this.buffer.append(style);
        }
        return this;
    }

    public CssStyleBuilder openSelector(String selector) {
        if (StringUtils.isNotBlank((String)selector)) {
            this.buffer.append(selector).append(" {\n");
        }
        return this;
    }

    public CssStyleBuilder closeSelector() {
        this.buffer.append("}\n");
        return this;
    }

    public String toCssStyle() {
        return this.buffer.toString();
    }

    public String toString() {
        return this.toCssStyle();
    }

    public boolean equals(Object obj) {
        EqualsBuilder builder = new EqualsBuilder();
        builder.appendSuper(this.getClass().isInstance(obj));
        if (builder.isEquals()) {
            CssStyleBuilder other = (CssStyleBuilder)obj;
            builder.append((Object)this.buffer, (Object)other.buffer);
        }
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.getClass()).append((Object)this.buffer);
        return builder.toHashCode();
    }
}

