/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wurfl.wall.utils;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.text.StrBuilder;

public class MarkupBuilder
implements Serializable {
    private static final long serialVersionUID = 10L;
    private final StrBuilder buffer = new StrBuilder();

    public MarkupBuilder startOpenElement(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            this.buffer.append("<").append(name);
        }
        return this;
    }

    public MarkupBuilder endOpenElement() {
        this.buffer.append(">");
        return this;
    }

    public MarkupBuilder openElement(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            this.buffer.append("<").append(name).append(">");
        }
        return this;
    }

    public MarkupBuilder closeElement(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            this.buffer.append("</").append(name).append(">");
        }
        return this;
    }

    public MarkupBuilder openCloseElement(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            this.buffer.append("<").append(name).append("/>");
        }
        return this;
    }

    public MarkupBuilder endOpenCloseElement() {
        this.buffer.append("/>");
        return this;
    }

    public MarkupBuilder appendText(String text) {
        if (StringUtils.isNotEmpty((String)text)) {
            this.buffer.append(text);
        }
        return this;
    }

    public MarkupBuilder appendNewLine() {
        this.buffer.append(SystemUtils.LINE_SEPARATOR);
        return this;
    }

    public MarkupBuilder appendAttribute(String name, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            if (!this.buffer.isEmpty() && !this.buffer.endsWith(" ")) {
                this.buffer.append(" ");
            }
            this.buffer.append(name).append("=\"").append(value).append("\"");
        }
        return this;
    }

    public String toMarkup() {
        return this.buffer.toString();
    }

    public String toString() {
        return this.toMarkup();
    }

    public boolean equals(Object obj) {
        EqualsBuilder builder = new EqualsBuilder();
        builder.appendSuper(this.getClass().isInstance(obj));
        if (builder.isEquals()) {
            MarkupBuilder other = (MarkupBuilder)obj;
            builder.append((Object)this.buffer, (Object)other.buffer);
        }
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.getClass()).append((Object)this.buffer);
        return builder.toHashCode();
    }
}

