/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.spy.memcached.KeyUtil;

public final class StringUtils {
    private static final Pattern decimalPattern = Pattern.compile("^-?\\d+$");
    private static final Matcher decimalMatcher = decimalPattern.matcher("");
    private static final int MAX_KEY_LENGTH = 250;
    private static final IllegalArgumentException KEY_TOO_LONG_EXCEPTION = new IllegalArgumentException("Key is too long (maxlen = 250)");
    private static final IllegalArgumentException KEY_EMPTY_EXCEPTION = new IllegalArgumentException("Key must contain at least one character.");

    private StringUtils() {
        throw new UnsupportedOperationException();
    }

    public static String join(Collection<String> chunks, String delimiter) {
        StringBuilder sb = new StringBuilder();
        if (!chunks.isEmpty()) {
            Iterator<String> itr = chunks.iterator();
            sb.append(itr.next());
            while (itr.hasNext()) {
                sb.append(delimiter);
                sb.append(itr.next());
            }
        }
        return sb.toString();
    }

    public static boolean isJsonObject(String s) {
        return s.startsWith("{") || s.startsWith("[") || "true".equals(s) || "false".equals(s) || "null".equals(s) || decimalMatcher.reset(s).matches();
    }

    public static void validateKey(String key, boolean binary) {
        byte[] keyBytes = KeyUtil.getKeyBytes(key);
        int keyLength = keyBytes.length;
        if (keyLength > 250) {
            throw KEY_TOO_LONG_EXCEPTION;
        }
        if (keyLength == 0) {
            throw KEY_EMPTY_EXCEPTION;
        }
        if (!binary) {
            for (byte b : keyBytes) {
                if (b != 32 && b != 10 && b != 13 && b != 0) continue;
                throw new IllegalArgumentException("Key contains invalid characters:  ``" + key + "''");
            }
        }
    }

    static {
        KEY_TOO_LONG_EXCEPTION.setStackTrace(new StackTraceElement[0]);
        KEY_EMPTY_EXCEPTION.setStackTrace(new StackTraceElement[0]);
    }
}

