/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.mustcall;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.checkerframework.checker.mustcall.qual.CreatesObligation;
import org.checkerframework.checker.mustcall.qual.InheritableMustCall;
import org.checkerframework.checker.mustcall.qual.MustCall;
import org.checkerframework.checker.mustcall.qual.MustCallAlias;
import org.checkerframework.checker.mustcall.qual.MustCallUnknown;
import org.checkerframework.checker.mustcall.qual.PolyMustCall;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.objectconstruction.qual.Owning;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.SubtypeIsSubsetQualifierHierarchy;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class MustCallAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror TOP;
    public final AnnotationMirror BOTTOM;
    final AnnotationMirror POLY;
    private final Set<Element> elementsIssuedInconsistentMustCallSubtypeErrors = new HashSet<Element>(this.getCacheSize());
    HashMap<Tree, LocalVariableNode> tempVars = new HashMap(this.getCacheSize());
    public final ExecutableElement mustCallValueElement = TreeUtils.getMethod(MustCall.class, (String)"value", (int)0, (ProcessingEnvironment)this.processingEnv);
    final ExecutableElement inheritableMustCallValueElement = TreeUtils.getMethod(InheritableMustCall.class, (String)"value", (int)0, (ProcessingEnvironment)this.processingEnv);
    public final ExecutableElement createsObligationListValueElement = TreeUtils.getMethod(CreatesObligation.List.class, (String)"value", (int)0, (ProcessingEnvironment)this.processingEnv);
    public final ExecutableElement createsObligationValueElement = TreeUtils.getMethod(CreatesObligation.class, (String)"value", (int)0, (ProcessingEnvironment)this.processingEnv);

    public MustCallAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.TOP = AnnotationBuilder.fromClass((Elements)this.elements, MustCallUnknown.class);
        this.BOTTOM = this.createMustCall(new String[0]);
        this.POLY = AnnotationBuilder.fromClass((Elements)this.elements, PolyMustCall.class);
        this.addAliasedTypeAnnotation(InheritableMustCall.class, MustCall.class, true, new String[0]);
        if (!checker.hasOption("noResourceAliases")) {
            this.addAliasedTypeAnnotation(MustCallAlias.class, this.POLY);
        }
        this.postInit();
    }

    public void setRoot(@Nullable CompilationUnitTree root) {
        super.setRoot(root);
        this.elementsIssuedInconsistentMustCallSubtypeErrors.clear();
        this.tempVars.clear();
    }

    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(MustCall.class, MustCallUnknown.class, PolyMustCall.class));
    }

    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(new TreeAnnotator[]{super.createTreeAnnotator(), new MustCallTreeAnnotator(this)});
    }

    protected void addComputedTypeAnnotations(Tree tree, AnnotatedTypeMirror type, boolean iUseFlow) {
        super.addComputedTypeAnnotations(tree, type, iUseFlow);
        if (TypesUtils.isPrimitiveOrBoxed((TypeMirror)type.getUnderlyingType())) {
            type.replaceAnnotation(this.BOTTOM);
        }
        if (this.isDeclaredInTryWithResources(TreeUtils.elementFromTree((Tree)tree))) {
            type.replaceAnnotation(this.withoutClose(type.getAnnotationInHierarchy(this.TOP)));
        }
    }

    public void addComputedTypeAnnotations(Element elt, AnnotatedTypeMirror type) {
        super.addComputedTypeAnnotations(elt, type);
        if (TypesUtils.isPrimitiveOrBoxed((TypeMirror)type.getUnderlyingType())) {
            type.replaceAnnotation(this.BOTTOM);
        }
        if (this.isDeclaredInTryWithResources(elt)) {
            type.replaceAnnotation(this.withoutClose(type.getAnnotationInHierarchy(this.TOP)));
        }
    }

    AnnotationMirror withoutClose(@Nullable AnnotationMirror anno) {
        if (anno == null || AnnotationUtils.areSame((AnnotationMirror)anno, (AnnotationMirror)this.BOTTOM)) {
            return this.BOTTOM;
        }
        if (!AnnotationUtils.areSameByName((AnnotationMirror)anno, (String)"org.checkerframework.checker.mustcall.qual.MustCall")) {
            return anno;
        }
        List values = AnnotationUtils.getElementValueArray((AnnotationMirror)anno, (ExecutableElement)this.mustCallValueElement, String.class);
        if (!values.contains("close")) {
            return anno;
        }
        return this.createMustCall((String[])values.stream().filter(s -> !"close".equals(s)).toArray(String[]::new));
    }

    private boolean isDeclaredInTryWithResources(@Nullable Element elt) {
        return elt != null && elt.getKind() == ElementKind.RESOURCE_VARIABLE;
    }

    public void methodFromUsePreSubstitution(ExpressionTree tree, AnnotatedTypeMirror.AnnotatedExecutableType type) {
        ExecutableElement declaration;
        if (tree instanceof MethodInvocationTree) {
            declaration = TreeUtils.elementFromUse((MethodInvocationTree)((MethodInvocationTree)tree));
        } else if (tree instanceof MemberReferenceTree) {
            declaration = (ExecutableElement)TreeUtils.elementFromTree((Tree)tree);
        } else {
            throw new BugInCF("unexpected type of method tree: " + (Object)((Object)tree.getKind()));
        }
        this.changeNonOwningParametersTypes(declaration, type);
        super.methodFromUsePreSubstitution(tree, type);
    }

    protected void constructorFromUsePreSubstitution(NewClassTree tree, AnnotatedTypeMirror.AnnotatedExecutableType type) {
        ExecutableElement declaration = TreeUtils.elementFromUse((NewClassTree)tree);
        this.changeNonOwningParametersTypes(declaration, type);
        super.constructorFromUsePreSubstitution(tree, type);
    }

    private void changeNonOwningParametersTypes(ExecutableElement declaration, AnnotatedTypeMirror.AnnotatedExecutableType type) {
        for (int i = 0; i < type.getParameterTypes().size(); ++i) {
            AnnotatedTypeMirror varargsType;
            Element paramDecl = declaration.getParameters().get(i);
            if (!this.checker.hasOption("noLightweightOwnership") && this.getDeclAnnotation(paramDecl, Owning.class) != null) continue;
            AnnotatedTypeMirror paramType = (AnnotatedTypeMirror)type.getParameterTypes().get(i);
            if (!paramType.hasAnnotation(this.POLY)) {
                paramType.replaceAnnotation(this.TOP);
            }
            if (!declaration.isVarArgs() || i != type.getParameterTypes().size() - 1 || paramType.getKind() != TypeKind.ARRAY || (varargsType = ((AnnotatedTypeMirror.AnnotatedArrayType)paramType).getComponentType()).hasAnnotation(this.POLY)) continue;
            varargsType.replaceAnnotation(this.TOP);
        }
    }

    public AnnotatedTypeMirror fromElement(Element elt) {
        AnnotationMirror inheritableMustCall;
        AnnotatedTypeMirror type = super.fromElement(elt);
        if (ElementUtils.isTypeElement((Element)elt) && (inheritableMustCall = this.getDeclAnnotation(elt, InheritableMustCall.class)) != null) {
            List mustCallVal = AnnotationUtils.getElementValueArray((AnnotationMirror)inheritableMustCall, (ExecutableElement)this.inheritableMustCallValueElement, String.class);
            AnnotationMirror inheritedMCAnno = this.createMustCall(mustCallVal.toArray(new String[0]));
            AnnotationMirror writtenMCAnno = type.getAnnotationInHierarchy(this.TOP);
            if (writtenMCAnno != null && !this.getQualifierHierarchy().isSubtype(inheritedMCAnno, writtenMCAnno)) {
                if (!this.elementsIssuedInconsistentMustCallSubtypeErrors.contains(elt) && !this.checker.shouldSkipUses(elt)) {
                    this.checker.reportError((Object)elt, "inconsistent.mustcall.subtype", new Object[]{elt.getSimpleName(), writtenMCAnno, inheritableMustCall});
                    this.elementsIssuedInconsistentMustCallSubtypeErrors.add(elt);
                }
            } else {
                type.replaceAnnotation(inheritedMCAnno);
            }
        }
        return type;
    }

    public AnnotationMirror createMustCall(String ... val) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, MustCall.class);
        Arrays.sort(val);
        builder.setValue((CharSequence)"value", (Object[])val);
        return builder.build();
    }

    public QualifierHierarchy createQualifierHierarchy() {
        return new SubtypeIsSubsetQualifierHierarchy((Collection)this.getSupportedTypeQualifiers(), this.getProcessingEnv());
    }

    public CFStore getStoreForBlock(boolean noSuccInfo, Block block, Block succ) {
        return noSuccInfo ? (CFStore)this.flowResult.getStoreAfter(block) : (CFStore)this.flowResult.getStoreBefore(succ);
    }

    public @Nullable LocalVariableNode getTempVar(Node node) {
        return this.tempVars.get(node.getTree());
    }

    private class MustCallTreeAnnotator
    extends TreeAnnotator {
        public MustCallTreeAnnotator(MustCallAnnotatedTypeFactory mustCallAnnotatedTypeFactory2) {
            super((AnnotatedTypeFactory)mustCallAnnotatedTypeFactory2);
        }

        public Void visitIdentifier(IdentifierTree node, AnnotatedTypeMirror type) {
            Element elt = TreeUtils.elementFromTree((Tree)node);
            if (elt.getKind() == ElementKind.PARAMETER && (MustCallAnnotatedTypeFactory.this.checker.hasOption("noLightweightOwnership") || MustCallAnnotatedTypeFactory.this.getDeclAnnotation(elt, Owning.class) == null)) {
                type.replaceAnnotation(MustCallAnnotatedTypeFactory.this.BOTTOM);
            }
            return (Void)super.visitIdentifier(node, (Object)type);
        }
    }
}

