/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.mustcall;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.mustcall.MustCallAnnotatedTypeFactory;
import org.checkerframework.checker.mustcall.qual.CreatesObligation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateAssignmentNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateNode;
import org.checkerframework.dataflow.cfg.node.TernaryExpressionNode;
import org.checkerframework.dataflow.expression.JavaExpression;
import org.checkerframework.dataflow.expression.Unknown;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFAbstractValue;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFTransfer;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.framework.source.SourceChecker;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.util.JavaExpressionParseUtil;
import org.checkerframework.framework.util.StringToJavaExpression;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreePathUtil;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;
import org.checkerframework.javacutil.trees.TreeBuilder;

public class MustCallTransfer
extends CFTransfer {
    private final TreeBuilder treeBuilder;
    private MustCallAnnotatedTypeFactory atypeFactory;
    protected long uid = 0L;

    public MustCallTransfer(CFAnalysis analysis) {
        super((CFAbstractAnalysis)analysis);
        this.atypeFactory = (MustCallAnnotatedTypeFactory)analysis.getTypeFactory();
        ProcessingEnvironment env = this.atypeFactory.getChecker().getProcessingEnvironment();
        this.treeBuilder = new TreeBuilder(env);
    }

    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<CFValue, CFStore> in) {
        TransferResult result = super.visitMethodInvocation(n, in);
        this.updateStoreWithTempVar((TransferResult<CFValue, CFStore>)result, (Node)n);
        if (!this.atypeFactory.getChecker().hasOption("noAccumulationFrames")) {
            Set<JavaExpression> targetExprs = MustCallTransfer.getCreatesObligationExpressions(n, this.atypeFactory);
            for (JavaExpression targetExpr : targetExprs) {
                AnnotationMirror defaultType = this.atypeFactory.getAnnotatedType(TypesUtils.getTypeElement((TypeMirror)targetExpr.getType())).getAnnotationInHierarchy(this.atypeFactory.TOP);
                if (result.containsTwoStores()) {
                    CFStore thenStore = (CFStore)result.getThenStore();
                    this.lubWithStoreValue(thenStore, targetExpr, defaultType);
                    CFStore elseStore = (CFStore)result.getElseStore();
                    this.lubWithStoreValue(elseStore, targetExpr, defaultType);
                    continue;
                }
                CFStore store = (CFStore)result.getRegularStore();
                this.lubWithStoreValue(store, targetExpr, defaultType);
            }
        }
        return result;
    }

    private void lubWithStoreValue(CFStore store, JavaExpression expr, AnnotationMirror defaultType) {
        CFValue value = (CFValue)store.getValue(expr);
        CFValue defaultTypeAsValue = (CFValue)this.analysis.createSingleAnnotationValue(defaultType, expr.getType());
        CFValue newValue = value == null ? defaultTypeAsValue : (CFValue)value.leastUpperBound((CFAbstractValue)defaultTypeAsValue);
        store.clearValue(expr);
        store.insertValue(expr, (CFAbstractValue)newValue);
    }

    public TransferResult<CFValue, CFStore> visitObjectCreation(ObjectCreationNode node, TransferInput<CFValue, CFStore> input) {
        TransferResult result = super.visitObjectCreation(node, input);
        this.updateStoreWithTempVar((TransferResult<CFValue, CFStore>)result, (Node)node);
        return result;
    }

    public TransferResult<CFValue, CFStore> visitTernaryExpression(TernaryExpressionNode node, TransferInput<CFValue, CFStore> input) {
        TransferResult result = super.visitTernaryExpression(node, input);
        this.updateStoreWithTempVar((TransferResult<CFValue, CFStore>)result, (Node)node);
        return result;
    }

    public void insertIntoStores(TransferResult<CFValue, CFStore> result, JavaExpression target, AnnotationMirror newAnno) {
        if (result.containsTwoStores()) {
            CFStore thenStore = (CFStore)result.getThenStore();
            CFStore elseStore = (CFStore)result.getElseStore();
            thenStore.insertValue(target, newAnno);
            elseStore.insertValue(target, newAnno);
        } else {
            CFStore store = (CFStore)result.getRegularStore();
            store.insertValue(target, newAnno);
        }
    }

    public static Set<JavaExpression> getCreatesObligationExpressions(MethodInvocationNode n, GenericAnnotatedTypeFactory<?, ?, ?, ?> atypeFactory) {
        return MustCallTransfer.getCreatesObligationExpressions(n, atypeFactory, null);
    }

    public static Set<JavaExpression> getCreatesObligationExpressions(MethodInvocationNode n, GenericAnnotatedTypeFactory<?, ?, ?, ?> atypeFactory, @Nullable TreePath currentPath) {
        JavaExpression expr;
        AnnotationMirror createsObligationList = atypeFactory.getDeclAnnotation((Element)n.getTarget().getMethod(), CreatesObligation.List.class);
        if (createsObligationList != null) {
            List createsObligations = AnnotationUtils.getElementValueArray((AnnotationMirror)createsObligationList, (CharSequence)"value", AnnotationMirror.class, (boolean)true);
            HashSet<JavaExpression> results = new HashSet<JavaExpression>();
            if (currentPath == null) {
                currentPath = atypeFactory.getPath((Tree)n.getTree());
            }
            for (AnnotationMirror co : createsObligations) {
                JavaExpression expr2 = MustCallTransfer.getCreatesObligationExpressionsImpl(co, n, atypeFactory, currentPath);
                if (expr2 == null) continue;
                results.add(expr2);
            }
            return results;
        }
        AnnotationMirror createsObligation = atypeFactory.getDeclAnnotation((Element)n.getTarget().getMethod(), CreatesObligation.class);
        if (createsObligation == null) {
            return Collections.emptySet();
        }
        if (currentPath == null) {
            currentPath = atypeFactory.getPath((Tree)n.getTree());
        }
        return (expr = MustCallTransfer.getCreatesObligationExpressionsImpl(createsObligation, n, atypeFactory, currentPath)) != null ? Collections.singleton(expr) : Collections.emptySet();
    }

    private static @Nullable JavaExpression getCreatesObligationExpressionsImpl(AnnotationMirror createsObligation, MethodInvocationNode n, GenericAnnotatedTypeFactory<?, ?, ?, ?> atypeFactory, TreePath currentPath) {
        JavaExpression targetExpr;
        String targetStrWithoutAdaptation = (String)AnnotationUtils.getElementValue((AnnotationMirror)createsObligation, (CharSequence)"value", String.class, (boolean)true);
        try {
            targetExpr = StringToJavaExpression.atMethodInvocation((String)targetStrWithoutAdaptation, (MethodInvocationNode)n, (SourceChecker)atypeFactory.getChecker());
            if (targetExpr instanceof Unknown) {
                MustCallTransfer.issueUnparseableError(n, atypeFactory, targetStrWithoutAdaptation);
                return null;
            }
        }
        catch (JavaExpressionParseUtil.JavaExpressionParseException e) {
            MustCallTransfer.issueUnparseableError(n, atypeFactory, targetStrWithoutAdaptation);
            return null;
        }
        return targetExpr;
    }

    private static void issueUnparseableError(MethodInvocationNode n, GenericAnnotatedTypeFactory<?, ?, ?, ?> atypeFactory, String targetStrWithoutAdaptation) {
        atypeFactory.getChecker().reportError((Object)n.getTree(), "mustcall.not.parseable", new Object[]{n.getTarget().getMethod().getSimpleName(), targetStrWithoutAdaptation});
    }

    public static String standardizeAndViewpointAdapt(String s, MethodInvocationNode miNode, BaseTypeChecker checker) {
        try {
            return StringToJavaExpression.atMethodInvocation((String)s, (MethodInvocationNode)miNode, (SourceChecker)checker).toString();
        }
        catch (JavaExpressionParseUtil.JavaExpressionParseException e) {
            return s;
        }
    }

    public TransferResult<CFValue, CFStore> visitStringConcatenate(StringConcatenateNode n, TransferInput<CFValue, CFStore> input) {
        return this.handleStringConcatenation((TransferResult<CFValue, CFStore>)((TransferResult)super.visitStringConcatenate(n, input)));
    }

    public TransferResult<CFValue, CFStore> visitStringConcatenateAssignment(StringConcatenateAssignmentNode n, TransferInput<CFValue, CFStore> in) {
        return this.handleStringConcatenation((TransferResult<CFValue, CFStore>)super.visitStringConcatenateAssignment(n, in));
    }

    private TransferResult<CFValue, CFStore> handleStringConcatenation(TransferResult<CFValue, CFStore> result) {
        TypeMirror underlyingType = ((CFValue)result.getResultValue()).getUnderlyingType();
        CFValue newValue = (CFValue)this.analysis.createSingleAnnotationValue(this.atypeFactory.BOTTOM, underlyingType);
        return new RegularTransferResult((AbstractValue)newValue, result.getRegularStore());
    }

    public void updateStoreWithTempVar(TransferResult<CFValue, CFStore> result, Node node) {
        LocalVariableNode temp;
        if (!TypesUtils.isPrimitiveOrBoxed((TypeMirror)node.getType()) && (temp = this.getOrCreateTempVar(node)) != null) {
            JavaExpression localExp = JavaExpression.fromNode((Node)temp);
            AnnotationMirror anm = this.atypeFactory.getAnnotatedType(node.getTree()).getAnnotationInHierarchy(this.atypeFactory.TOP);
            this.insertIntoStores(result, localExp, anm == null ? this.atypeFactory.TOP : anm);
        }
    }

    private @Nullable LocalVariableNode getOrCreateTempVar(Node node) {
        VariableTree temp;
        LocalVariableNode localVariableNode = this.atypeFactory.tempVars.get(node.getTree());
        if (localVariableNode == null && (temp = this.createTemporaryVar(node)) != null) {
            IdentifierTree identifierTree = this.treeBuilder.buildVariableUse(temp);
            localVariableNode = new LocalVariableNode((Tree)identifierTree);
            localVariableNode.setInSource(true);
        }
        this.atypeFactory.tempVars.put(node.getTree(), localVariableNode);
        return localVariableNode;
    }

    protected @Nullable VariableTree createTemporaryVar(Node node) {
        Element enclosingElement;
        ExpressionTree tree = (ExpressionTree)node.getTree();
        TypeMirror treeType = TreeUtils.typeOf((Tree)tree);
        TreePath path = this.atypeFactory.getPath(tree);
        if (path == null) {
            enclosingElement = TreeUtils.elementFromTree((Tree)tree).getEnclosingElement();
        } else {
            ClassTree classTree = TreePathUtil.enclosingClass((TreePath)path);
            enclosingElement = TreeUtils.elementFromTree((Tree)classTree);
        }
        if (enclosingElement == null) {
            return null;
        }
        VariableTree tmpVarTree = this.treeBuilder.buildVariableDecl(treeType, this.uniqueName("temp-var"), enclosingElement, tree);
        return tmpVarTree;
    }

    protected String uniqueName(String prefix) {
        return prefix + "-" + this.uid++;
    }
}

