/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.mustcall;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.mustcall.MustCallAnnotatedTypeFactory;
import org.checkerframework.checker.mustcall.MustCallTypeValidator;
import org.checkerframework.checker.objectconstruction.qual.NotOwning;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.common.basetype.TypeValidator;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreePathUtil;
import org.checkerframework.javacutil.TreeUtils;

public class MustCallVisitor
extends BaseTypeVisitor<MustCallAnnotatedTypeFactory> {
    public MustCallVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    public Void visitReturn(ReturnTree node, Void p) {
        ExecutableElement methodElt;
        AnnotationMirror notOwningAnno;
        MethodTree enclosingMethod = TreePathUtil.enclosingMethod((TreePath)this.getCurrentPath());
        if (!this.checker.hasOption("noLightweightOwnership") && enclosingMethod != null && (notOwningAnno = ((MustCallAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(methodElt = TreeUtils.elementFromDeclaration((MethodTree)enclosingMethod), NotOwning.class)) != null) {
            return null;
        }
        return super.visitReturn(node, p);
    }

    protected boolean skipReceiverSubtypeCheck(MethodInvocationTree node, AnnotatedTypeMirror methodDefinitionReceiver, AnnotatedTypeMirror methodCallReceiver) {
        return true;
    }

    protected void commonAssignmentCheck(Tree varTree, ExpressionTree valueExp, @CompilerMessageKey String errorKey, Object ... extraArgs) {
        if (TreeUtils.elementFromTree((Tree)varTree).getKind() == ElementKind.RESOURCE_VARIABLE) {
            Object[] newExtraArgs = Arrays.copyOf(extraArgs, extraArgs.length + 1);
            newExtraArgs[newExtraArgs.length - 1] = ElementKind.RESOURCE_VARIABLE;
            super.commonAssignmentCheck(varTree, valueExp, errorKey, newExtraArgs);
        } else {
            super.commonAssignmentCheck(varTree, valueExp, errorKey, extraArgs);
        }
    }

    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey, Object ... extraArgs) {
        if (Arrays.asList(extraArgs).contains((Object)ElementKind.RESOURCE_VARIABLE)) {
            AnnotationMirror varAnno = varType.getAnnotationInHierarchy(((MustCallAnnotatedTypeFactory)this.atypeFactory).TOP);
            AnnotationMirror valAnno = valueType.getAnnotationInHierarchy(((MustCallAnnotatedTypeFactory)this.atypeFactory).TOP);
            if (((MustCallAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(((MustCallAnnotatedTypeFactory)this.atypeFactory).withoutClose(valAnno), ((MustCallAnnotatedTypeFactory)this.atypeFactory).withoutClose(varAnno))) {
                return;
            }
        }
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey, extraArgs);
    }

    protected void checkConstructorResult(AnnotatedTypeMirror.AnnotatedExecutableType constructorType, ExecutableElement constructorElement) {
        AnnotatedTypeMirror.AnnotatedDeclaredType defaultType = ((MustCallAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(ElementUtils.enclosingTypeElement((Element)constructorElement));
        AnnotationMirror defaultAnno = defaultType.getAnnotationInHierarchy(((MustCallAnnotatedTypeFactory)this.atypeFactory).TOP);
        AnnotationMirror resultAnno = constructorType.getReturnType().getAnnotationInHierarchy(((MustCallAnnotatedTypeFactory)this.atypeFactory).TOP);
        if (!((MustCallAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(defaultAnno, resultAnno)) {
            this.checker.reportError((Object)constructorElement, "inconsistent.constructor.type", new Object[]{resultAnno, defaultAnno});
        }
    }

    protected Set<? extends AnnotationMirror> getExceptionParameterLowerBoundAnnotations() {
        return Collections.singleton(((MustCallAnnotatedTypeFactory)this.atypeFactory).BOTTOM);
    }

    public Void visitAnnotation(AnnotationTree node, Void p) {
        return null;
    }

    protected TypeValidator createTypeValidator() {
        if (this.checker.hasOption("noResourceAliases")) {
            return super.createTypeValidator();
        }
        return new MustCallTypeValidator(this.checker, this, (AnnotatedTypeFactory)this.atypeFactory);
    }
}

