/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.bootstrap.spring4;

import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.support.GenericApplicationContext;

public class DisposableBeanAdapter
implements DisposableBean {
    private final GenericApplicationContext context;
    private final Object bean;
    private final String beanName;

    public DisposableBeanAdapter(Object bean, String beanName, GenericApplicationContext context) {
        this.context = context;
        this.bean = bean;
        this.beanName = beanName;
    }

    public void destroy() throws Exception {
        List beanPostProcessors = this.context.getDefaultListableBeanFactory().getBeanPostProcessors();
        for (BeanPostProcessor p : beanPostProcessors) {
            if (!(p instanceof DestructionAwareBeanPostProcessor)) continue;
            ((DestructionAwareBeanPostProcessor)p).postProcessBeforeDestruction(this.bean, this.beanName);
        }
    }
}

