/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.bootstrap.spring4;

import java.util.Map;
import javax.inject.Inject;
import net.stickycode.bootstrap.BeanNotFoundFailure;
import net.stickycode.bootstrap.ComponentContainer;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class SpringComponentContainer
implements ComponentContainer {
    @Inject
    private ApplicationContext factory;

    public void inject(Object value) {
        this.factory.getAutowireCapableBeanFactory().autowireBean(value);
    }

    public <T> T find(Class<T> type) {
        try {
            return (T)this.factory.getBean(type);
        }
        catch (NoSuchBeanDefinitionException e) {
            try {
                Map beans = this.factory.getBeansOfType(type);
                if (beans.values().isEmpty()) {
                    throw new BeanNotFoundFailure((Exception)((Object)e), type);
                }
                throw new BeanNotFoundFailure(type, beans.values());
            }
            catch (NoSuchBeanDefinitionException e2) {
                throw new BeanNotFoundFailure((Exception)((Object)e2), type);
            }
        }
    }

    public boolean canFind(Class<?> type) {
        return this.factory.getBeanNamesForType(type).length > 0;
    }
}

