/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.configured.spring25;

import java.lang.reflect.Field;
import javax.inject.Inject;
import net.stickycode.configured.Configuration;
import net.stickycode.configured.ConfigurationRepository;
import net.stickycode.configured.ConfiguredConfiguration;
import net.stickycode.configured.ConfiguredFieldProcessor;
import net.stickycode.reflector.FieldProcessor;
import net.stickycode.reflector.Reflector;
import net.stickycode.stereotype.Configured;
import net.stickycode.stereotype.StickyComponent;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;

@StickyComponent
public class ConfiguredBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    @Inject
    private ConfigurationRepository configurationRepository;

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        if (this.typeIsConfigured(bean.getClass())) {
            ConfiguredConfiguration configuration = new ConfiguredConfiguration(bean);
            new Reflector().forEachField(new FieldProcessor[]{new ConfiguredFieldProcessor(configuration)}).process(bean);
            this.configurationRepository.register((Configuration)configuration);
        }
        return true;
    }

    private boolean typeIsConfigured(Class<?> type) {
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Configured.class)) continue;
            return true;
        }
        return false;
    }
}

