/*
 * Kubernetes
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: unversioned
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.stickycode.kuuty.model.v18;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1SecretReference;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.
 */
@ApiModel(description = "ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.")
@JsonPropertyOrder({
  IoK8sApiCoreV1ISCSIPersistentVolumeSource.JSON_PROPERTY_CHAP_AUTH_DISCOVERY,
  IoK8sApiCoreV1ISCSIPersistentVolumeSource.JSON_PROPERTY_CHAP_AUTH_SESSION,
  IoK8sApiCoreV1ISCSIPersistentVolumeSource.JSON_PROPERTY_FS_TYPE,
  IoK8sApiCoreV1ISCSIPersistentVolumeSource.JSON_PROPERTY_INITIATOR_NAME,
  IoK8sApiCoreV1ISCSIPersistentVolumeSource.JSON_PROPERTY_IQN,
  IoK8sApiCoreV1ISCSIPersistentVolumeSource.JSON_PROPERTY_ISCSI_INTERFACE,
  IoK8sApiCoreV1ISCSIPersistentVolumeSource.JSON_PROPERTY_LUN,
  IoK8sApiCoreV1ISCSIPersistentVolumeSource.JSON_PROPERTY_PORTALS,
  IoK8sApiCoreV1ISCSIPersistentVolumeSource.JSON_PROPERTY_READ_ONLY,
  IoK8sApiCoreV1ISCSIPersistentVolumeSource.JSON_PROPERTY_SECRET_REF,
  IoK8sApiCoreV1ISCSIPersistentVolumeSource.JSON_PROPERTY_TARGET_PORTAL
})
@javax.annotation.processing.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-26T11:01:11.402583+13:00[Pacific/Auckland]")
public class IoK8sApiCoreV1ISCSIPersistentVolumeSource {
  public static final String JSON_PROPERTY_CHAP_AUTH_DISCOVERY = "chapAuthDiscovery";
  private Boolean chapAuthDiscovery;

  public static final String JSON_PROPERTY_CHAP_AUTH_SESSION = "chapAuthSession";
  private Boolean chapAuthSession;

  public static final String JSON_PROPERTY_FS_TYPE = "fsType";
  private String fsType;

  public static final String JSON_PROPERTY_INITIATOR_NAME = "initiatorName";
  private String initiatorName;

  public static final String JSON_PROPERTY_IQN = "iqn";
  private String iqn;

  public static final String JSON_PROPERTY_ISCSI_INTERFACE = "iscsiInterface";
  private String iscsiInterface;

  public static final String JSON_PROPERTY_LUN = "lun";
  private Integer lun;

  public static final String JSON_PROPERTY_PORTALS = "portals";
  private List<String> portals = null;

  public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
  private Boolean readOnly;

  public static final String JSON_PROPERTY_SECRET_REF = "secretRef";
  private IoK8sApiCoreV1SecretReference secretRef;

  public static final String JSON_PROPERTY_TARGET_PORTAL = "targetPortal";
  private String targetPortal;


  public IoK8sApiCoreV1ISCSIPersistentVolumeSource chapAuthDiscovery(Boolean chapAuthDiscovery) {
    
    this.chapAuthDiscovery = chapAuthDiscovery;
    return this;
  }

   /**
   * whether support iSCSI Discovery CHAP authentication
   * @return chapAuthDiscovery
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "whether support iSCSI Discovery CHAP authentication")
  @JsonProperty(JSON_PROPERTY_CHAP_AUTH_DISCOVERY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getChapAuthDiscovery() {
    return chapAuthDiscovery;
  }


  public void setChapAuthDiscovery(Boolean chapAuthDiscovery) {
    this.chapAuthDiscovery = chapAuthDiscovery;
  }


  public IoK8sApiCoreV1ISCSIPersistentVolumeSource chapAuthSession(Boolean chapAuthSession) {
    
    this.chapAuthSession = chapAuthSession;
    return this;
  }

   /**
   * whether support iSCSI Session CHAP authentication
   * @return chapAuthSession
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "whether support iSCSI Session CHAP authentication")
  @JsonProperty(JSON_PROPERTY_CHAP_AUTH_SESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getChapAuthSession() {
    return chapAuthSession;
  }


  public void setChapAuthSession(Boolean chapAuthSession) {
    this.chapAuthSession = chapAuthSession;
  }


  public IoK8sApiCoreV1ISCSIPersistentVolumeSource fsType(String fsType) {
    
    this.fsType = fsType;
    return this;
  }

   /**
   * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \&quot;ext4\&quot;, \&quot;xfs\&quot;, \&quot;ntfs\&quot;. Implicitly inferred to be \&quot;ext4\&quot; if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
   * @return fsType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi")
  @JsonProperty(JSON_PROPERTY_FS_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFsType() {
    return fsType;
  }


  public void setFsType(String fsType) {
    this.fsType = fsType;
  }


  public IoK8sApiCoreV1ISCSIPersistentVolumeSource initiatorName(String initiatorName) {
    
    this.initiatorName = initiatorName;
    return this;
  }

   /**
   * Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface &lt;target portal&gt;:&lt;volume name&gt; will be created for the connection.
   * @return initiatorName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.")
  @JsonProperty(JSON_PROPERTY_INITIATOR_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInitiatorName() {
    return initiatorName;
  }


  public void setInitiatorName(String initiatorName) {
    this.initiatorName = initiatorName;
  }


  public IoK8sApiCoreV1ISCSIPersistentVolumeSource iqn(String iqn) {
    
    this.iqn = iqn;
    return this;
  }

   /**
   * Target iSCSI Qualified Name.
   * @return iqn
  **/
  @ApiModelProperty(required = true, value = "Target iSCSI Qualified Name.")
  @JsonProperty(JSON_PROPERTY_IQN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIqn() {
    return iqn;
  }


  public void setIqn(String iqn) {
    this.iqn = iqn;
  }


  public IoK8sApiCoreV1ISCSIPersistentVolumeSource iscsiInterface(String iscsiInterface) {
    
    this.iscsiInterface = iscsiInterface;
    return this;
  }

   /**
   * iSCSI Interface Name that uses an iSCSI transport. Defaults to &#39;default&#39; (tcp).
   * @return iscsiInterface
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).")
  @JsonProperty(JSON_PROPERTY_ISCSI_INTERFACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIscsiInterface() {
    return iscsiInterface;
  }


  public void setIscsiInterface(String iscsiInterface) {
    this.iscsiInterface = iscsiInterface;
  }


  public IoK8sApiCoreV1ISCSIPersistentVolumeSource lun(Integer lun) {
    
    this.lun = lun;
    return this;
  }

   /**
   * iSCSI Target Lun number.
   * @return lun
  **/
  @ApiModelProperty(required = true, value = "iSCSI Target Lun number.")
  @JsonProperty(JSON_PROPERTY_LUN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getLun() {
    return lun;
  }


  public void setLun(Integer lun) {
    this.lun = lun;
  }


  public IoK8sApiCoreV1ISCSIPersistentVolumeSource portals(List<String> portals) {
    
    this.portals = portals;
    return this;
  }

  public IoK8sApiCoreV1ISCSIPersistentVolumeSource addPortalsItem(String portalsItem) {
    if (this.portals == null) {
      this.portals = new ArrayList<>();
    }
    this.portals.add(portalsItem);
    return this;
  }

   /**
   * iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
   * @return portals
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).")
  @JsonProperty(JSON_PROPERTY_PORTALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPortals() {
    return portals;
  }


  public void setPortals(List<String> portals) {
    this.portals = portals;
  }


  public IoK8sApiCoreV1ISCSIPersistentVolumeSource readOnly(Boolean readOnly) {
    
    this.readOnly = readOnly;
    return this;
  }

   /**
   * ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
   * @return readOnly
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.")
  @JsonProperty(JSON_PROPERTY_READ_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReadOnly() {
    return readOnly;
  }


  public void setReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
  }


  public IoK8sApiCoreV1ISCSIPersistentVolumeSource secretRef(IoK8sApiCoreV1SecretReference secretRef) {
    
    this.secretRef = secretRef;
    return this;
  }

   /**
   * Get secretRef
   * @return secretRef
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SECRET_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IoK8sApiCoreV1SecretReference getSecretRef() {
    return secretRef;
  }


  public void setSecretRef(IoK8sApiCoreV1SecretReference secretRef) {
    this.secretRef = secretRef;
  }


  public IoK8sApiCoreV1ISCSIPersistentVolumeSource targetPortal(String targetPortal) {
    
    this.targetPortal = targetPortal;
    return this;
  }

   /**
   * iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
   * @return targetPortal
  **/
  @ApiModelProperty(required = true, value = "iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).")
  @JsonProperty(JSON_PROPERTY_TARGET_PORTAL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetPortal() {
    return targetPortal;
  }


  public void setTargetPortal(String targetPortal) {
    this.targetPortal = targetPortal;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IoK8sApiCoreV1ISCSIPersistentVolumeSource ioK8sApiCoreV1ISCSIPersistentVolumeSource = (IoK8sApiCoreV1ISCSIPersistentVolumeSource) o;
    return Objects.equals(this.chapAuthDiscovery, ioK8sApiCoreV1ISCSIPersistentVolumeSource.chapAuthDiscovery) &&
        Objects.equals(this.chapAuthSession, ioK8sApiCoreV1ISCSIPersistentVolumeSource.chapAuthSession) &&
        Objects.equals(this.fsType, ioK8sApiCoreV1ISCSIPersistentVolumeSource.fsType) &&
        Objects.equals(this.initiatorName, ioK8sApiCoreV1ISCSIPersistentVolumeSource.initiatorName) &&
        Objects.equals(this.iqn, ioK8sApiCoreV1ISCSIPersistentVolumeSource.iqn) &&
        Objects.equals(this.iscsiInterface, ioK8sApiCoreV1ISCSIPersistentVolumeSource.iscsiInterface) &&
        Objects.equals(this.lun, ioK8sApiCoreV1ISCSIPersistentVolumeSource.lun) &&
        Objects.equals(this.portals, ioK8sApiCoreV1ISCSIPersistentVolumeSource.portals) &&
        Objects.equals(this.readOnly, ioK8sApiCoreV1ISCSIPersistentVolumeSource.readOnly) &&
        Objects.equals(this.secretRef, ioK8sApiCoreV1ISCSIPersistentVolumeSource.secretRef) &&
        Objects.equals(this.targetPortal, ioK8sApiCoreV1ISCSIPersistentVolumeSource.targetPortal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(chapAuthDiscovery, chapAuthSession, fsType, initiatorName, iqn, iscsiInterface, lun, portals, readOnly, secretRef, targetPortal);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IoK8sApiCoreV1ISCSIPersistentVolumeSource {\n");
    sb.append("    chapAuthDiscovery: ").append(toIndentedString(chapAuthDiscovery)).append("\n");
    sb.append("    chapAuthSession: ").append(toIndentedString(chapAuthSession)).append("\n");
    sb.append("    fsType: ").append(toIndentedString(fsType)).append("\n");
    sb.append("    initiatorName: ").append(toIndentedString(initiatorName)).append("\n");
    sb.append("    iqn: ").append(toIndentedString(iqn)).append("\n");
    sb.append("    iscsiInterface: ").append(toIndentedString(iscsiInterface)).append("\n");
    sb.append("    lun: ").append(toIndentedString(lun)).append("\n");
    sb.append("    portals: ").append(toIndentedString(portals)).append("\n");
    sb.append("    readOnly: ").append(toIndentedString(readOnly)).append("\n");
    sb.append("    secretRef: ").append(toIndentedString(secretRef)).append("\n");
    sb.append("    targetPortal: ").append(toIndentedString(targetPortal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

