/*
 * Kubernetes
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: unversioned
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.stickycode.kuuty.model.v18;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1Affinity;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1Container;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1EphemeralContainer;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1HostAlias;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1LocalObjectReference;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1PodDNSConfig;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1PodReadinessGate;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1PodSecurityContext;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1Toleration;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1TopologySpreadConstraint;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1Volume;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * PodSpec is a description of a pod.
 */
@ApiModel(description = "PodSpec is a description of a pod.")
@JsonPropertyOrder({
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_ACTIVE_DEADLINE_SECONDS,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_AFFINITY,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_AUTOMOUNT_SERVICE_ACCOUNT_TOKEN,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_CONTAINERS,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_DNS_CONFIG,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_DNS_POLICY,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_ENABLE_SERVICE_LINKS,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_EPHEMERAL_CONTAINERS,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_HOST_ALIASES,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_HOST_I_P_C,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_HOST_NETWORK,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_HOST_P_I_D,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_HOSTNAME,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_IMAGE_PULL_SECRETS,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_INIT_CONTAINERS,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_NODE_NAME,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_NODE_SELECTOR,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_OVERHEAD,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_PREEMPTION_POLICY,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_PRIORITY,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_PRIORITY_CLASS_NAME,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_READINESS_GATES,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_RESTART_POLICY,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_RUNTIME_CLASS_NAME,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_SCHEDULER_NAME,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_SECURITY_CONTEXT,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_SERVICE_ACCOUNT,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_SERVICE_ACCOUNT_NAME,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_SHARE_PROCESS_NAMESPACE,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_SUBDOMAIN,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_TERMINATION_GRACE_PERIOD_SECONDS,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_TOLERATIONS,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_TOPOLOGY_SPREAD_CONSTRAINTS,
  IoK8sApiCoreV1PodSpec.JSON_PROPERTY_VOLUMES
})
@javax.annotation.processing.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-26T11:01:11.402583+13:00[Pacific/Auckland]")
public class IoK8sApiCoreV1PodSpec {
  public static final String JSON_PROPERTY_ACTIVE_DEADLINE_SECONDS = "activeDeadlineSeconds";
  private Long activeDeadlineSeconds;

  public static final String JSON_PROPERTY_AFFINITY = "affinity";
  private IoK8sApiCoreV1Affinity affinity;

  public static final String JSON_PROPERTY_AUTOMOUNT_SERVICE_ACCOUNT_TOKEN = "automountServiceAccountToken";
  private Boolean automountServiceAccountToken;

  public static final String JSON_PROPERTY_CONTAINERS = "containers";
  private List<IoK8sApiCoreV1Container> containers = new ArrayList<>();

  public static final String JSON_PROPERTY_DNS_CONFIG = "dnsConfig";
  private IoK8sApiCoreV1PodDNSConfig dnsConfig;

  public static final String JSON_PROPERTY_DNS_POLICY = "dnsPolicy";
  private String dnsPolicy;

  public static final String JSON_PROPERTY_ENABLE_SERVICE_LINKS = "enableServiceLinks";
  private Boolean enableServiceLinks;

  public static final String JSON_PROPERTY_EPHEMERAL_CONTAINERS = "ephemeralContainers";
  private List<IoK8sApiCoreV1EphemeralContainer> ephemeralContainers = null;

  public static final String JSON_PROPERTY_HOST_ALIASES = "hostAliases";
  private List<IoK8sApiCoreV1HostAlias> hostAliases = null;

  public static final String JSON_PROPERTY_HOST_I_P_C = "hostIPC";
  private Boolean hostIPC;

  public static final String JSON_PROPERTY_HOST_NETWORK = "hostNetwork";
  private Boolean hostNetwork;

  public static final String JSON_PROPERTY_HOST_P_I_D = "hostPID";
  private Boolean hostPID;

  public static final String JSON_PROPERTY_HOSTNAME = "hostname";
  private String hostname;

  public static final String JSON_PROPERTY_IMAGE_PULL_SECRETS = "imagePullSecrets";
  private List<IoK8sApiCoreV1LocalObjectReference> imagePullSecrets = null;

  public static final String JSON_PROPERTY_INIT_CONTAINERS = "initContainers";
  private List<IoK8sApiCoreV1Container> initContainers = null;

  public static final String JSON_PROPERTY_NODE_NAME = "nodeName";
  private String nodeName;

  public static final String JSON_PROPERTY_NODE_SELECTOR = "nodeSelector";
  private Map<String, String> nodeSelector = null;

  public static final String JSON_PROPERTY_OVERHEAD = "overhead";
  private Map<String, String> overhead = null;

  public static final String JSON_PROPERTY_PREEMPTION_POLICY = "preemptionPolicy";
  private String preemptionPolicy;

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private Integer priority;

  public static final String JSON_PROPERTY_PRIORITY_CLASS_NAME = "priorityClassName";
  private String priorityClassName;

  public static final String JSON_PROPERTY_READINESS_GATES = "readinessGates";
  private List<IoK8sApiCoreV1PodReadinessGate> readinessGates = null;

  public static final String JSON_PROPERTY_RESTART_POLICY = "restartPolicy";
  private String restartPolicy;

  public static final String JSON_PROPERTY_RUNTIME_CLASS_NAME = "runtimeClassName";
  private String runtimeClassName;

  public static final String JSON_PROPERTY_SCHEDULER_NAME = "schedulerName";
  private String schedulerName;

  public static final String JSON_PROPERTY_SECURITY_CONTEXT = "securityContext";
  private IoK8sApiCoreV1PodSecurityContext securityContext;

  public static final String JSON_PROPERTY_SERVICE_ACCOUNT = "serviceAccount";
  private String serviceAccount;

  public static final String JSON_PROPERTY_SERVICE_ACCOUNT_NAME = "serviceAccountName";
  private String serviceAccountName;

  public static final String JSON_PROPERTY_SHARE_PROCESS_NAMESPACE = "shareProcessNamespace";
  private Boolean shareProcessNamespace;

  public static final String JSON_PROPERTY_SUBDOMAIN = "subdomain";
  private String subdomain;

  public static final String JSON_PROPERTY_TERMINATION_GRACE_PERIOD_SECONDS = "terminationGracePeriodSeconds";
  private Long terminationGracePeriodSeconds;

  public static final String JSON_PROPERTY_TOLERATIONS = "tolerations";
  private List<IoK8sApiCoreV1Toleration> tolerations = null;

  public static final String JSON_PROPERTY_TOPOLOGY_SPREAD_CONSTRAINTS = "topologySpreadConstraints";
  private List<IoK8sApiCoreV1TopologySpreadConstraint> topologySpreadConstraints = null;

  public static final String JSON_PROPERTY_VOLUMES = "volumes";
  private List<IoK8sApiCoreV1Volume> volumes = null;


  public IoK8sApiCoreV1PodSpec activeDeadlineSeconds(Long activeDeadlineSeconds) {
    
    this.activeDeadlineSeconds = activeDeadlineSeconds;
    return this;
  }

   /**
   * Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.
   * @return activeDeadlineSeconds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.")
  @JsonProperty(JSON_PROPERTY_ACTIVE_DEADLINE_SECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getActiveDeadlineSeconds() {
    return activeDeadlineSeconds;
  }


  public void setActiveDeadlineSeconds(Long activeDeadlineSeconds) {
    this.activeDeadlineSeconds = activeDeadlineSeconds;
  }


  public IoK8sApiCoreV1PodSpec affinity(IoK8sApiCoreV1Affinity affinity) {
    
    this.affinity = affinity;
    return this;
  }

   /**
   * Get affinity
   * @return affinity
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AFFINITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IoK8sApiCoreV1Affinity getAffinity() {
    return affinity;
  }


  public void setAffinity(IoK8sApiCoreV1Affinity affinity) {
    this.affinity = affinity;
  }


  public IoK8sApiCoreV1PodSpec automountServiceAccountToken(Boolean automountServiceAccountToken) {
    
    this.automountServiceAccountToken = automountServiceAccountToken;
    return this;
  }

   /**
   * AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
   * @return automountServiceAccountToken
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.")
  @JsonProperty(JSON_PROPERTY_AUTOMOUNT_SERVICE_ACCOUNT_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAutomountServiceAccountToken() {
    return automountServiceAccountToken;
  }


  public void setAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
    this.automountServiceAccountToken = automountServiceAccountToken;
  }


  public IoK8sApiCoreV1PodSpec containers(List<IoK8sApiCoreV1Container> containers) {
    
    this.containers = containers;
    return this;
  }

  public IoK8sApiCoreV1PodSpec addContainersItem(IoK8sApiCoreV1Container containersItem) {
    this.containers.add(containersItem);
    return this;
  }

   /**
   * List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.
   * @return containers
  **/
  @ApiModelProperty(required = true, value = "List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.")
  @JsonProperty(JSON_PROPERTY_CONTAINERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<IoK8sApiCoreV1Container> getContainers() {
    return containers;
  }


  public void setContainers(List<IoK8sApiCoreV1Container> containers) {
    this.containers = containers;
  }


  public IoK8sApiCoreV1PodSpec dnsConfig(IoK8sApiCoreV1PodDNSConfig dnsConfig) {
    
    this.dnsConfig = dnsConfig;
    return this;
  }

   /**
   * Get dnsConfig
   * @return dnsConfig
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DNS_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IoK8sApiCoreV1PodDNSConfig getDnsConfig() {
    return dnsConfig;
  }


  public void setDnsConfig(IoK8sApiCoreV1PodDNSConfig dnsConfig) {
    this.dnsConfig = dnsConfig;
  }


  public IoK8sApiCoreV1PodSpec dnsPolicy(String dnsPolicy) {
    
    this.dnsPolicy = dnsPolicy;
    return this;
  }

   /**
   * Set DNS policy for the pod. Defaults to \&quot;ClusterFirst\&quot;. Valid values are &#39;ClusterFirstWithHostNet&#39;, &#39;ClusterFirst&#39;, &#39;Default&#39; or &#39;None&#39;. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to &#39;ClusterFirstWithHostNet&#39;.
   * @return dnsPolicy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Set DNS policy for the pod. Defaults to \"ClusterFirst\". Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.")
  @JsonProperty(JSON_PROPERTY_DNS_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDnsPolicy() {
    return dnsPolicy;
  }


  public void setDnsPolicy(String dnsPolicy) {
    this.dnsPolicy = dnsPolicy;
  }


  public IoK8sApiCoreV1PodSpec enableServiceLinks(Boolean enableServiceLinks) {
    
    this.enableServiceLinks = enableServiceLinks;
    return this;
  }

   /**
   * EnableServiceLinks indicates whether information about services should be injected into pod&#39;s environment variables, matching the syntax of Docker links. Optional: Defaults to true.
   * @return enableServiceLinks
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "EnableServiceLinks indicates whether information about services should be injected into pod's environment variables, matching the syntax of Docker links. Optional: Defaults to true.")
  @JsonProperty(JSON_PROPERTY_ENABLE_SERVICE_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnableServiceLinks() {
    return enableServiceLinks;
  }


  public void setEnableServiceLinks(Boolean enableServiceLinks) {
    this.enableServiceLinks = enableServiceLinks;
  }


  public IoK8sApiCoreV1PodSpec ephemeralContainers(List<IoK8sApiCoreV1EphemeralContainer> ephemeralContainers) {
    
    this.ephemeralContainers = ephemeralContainers;
    return this;
  }

  public IoK8sApiCoreV1PodSpec addEphemeralContainersItem(IoK8sApiCoreV1EphemeralContainer ephemeralContainersItem) {
    if (this.ephemeralContainers == null) {
      this.ephemeralContainers = new ArrayList<>();
    }
    this.ephemeralContainers.add(ephemeralContainersItem);
    return this;
  }

   /**
   * List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod&#39;s ephemeralcontainers subresource. This field is alpha-level and is only honored by servers that enable the EphemeralContainers feature.
   * @return ephemeralContainers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource. This field is alpha-level and is only honored by servers that enable the EphemeralContainers feature.")
  @JsonProperty(JSON_PROPERTY_EPHEMERAL_CONTAINERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1EphemeralContainer> getEphemeralContainers() {
    return ephemeralContainers;
  }


  public void setEphemeralContainers(List<IoK8sApiCoreV1EphemeralContainer> ephemeralContainers) {
    this.ephemeralContainers = ephemeralContainers;
  }


  public IoK8sApiCoreV1PodSpec hostAliases(List<IoK8sApiCoreV1HostAlias> hostAliases) {
    
    this.hostAliases = hostAliases;
    return this;
  }

  public IoK8sApiCoreV1PodSpec addHostAliasesItem(IoK8sApiCoreV1HostAlias hostAliasesItem) {
    if (this.hostAliases == null) {
      this.hostAliases = new ArrayList<>();
    }
    this.hostAliases.add(hostAliasesItem);
    return this;
  }

   /**
   * HostAliases is an optional list of hosts and IPs that will be injected into the pod&#39;s hosts file if specified. This is only valid for non-hostNetwork pods.
   * @return hostAliases
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified. This is only valid for non-hostNetwork pods.")
  @JsonProperty(JSON_PROPERTY_HOST_ALIASES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1HostAlias> getHostAliases() {
    return hostAliases;
  }


  public void setHostAliases(List<IoK8sApiCoreV1HostAlias> hostAliases) {
    this.hostAliases = hostAliases;
  }


  public IoK8sApiCoreV1PodSpec hostIPC(Boolean hostIPC) {
    
    this.hostIPC = hostIPC;
    return this;
  }

   /**
   * Use the host&#39;s ipc namespace. Optional: Default to false.
   * @return hostIPC
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Use the host's ipc namespace. Optional: Default to false.")
  @JsonProperty(JSON_PROPERTY_HOST_I_P_C)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHostIPC() {
    return hostIPC;
  }


  public void setHostIPC(Boolean hostIPC) {
    this.hostIPC = hostIPC;
  }


  public IoK8sApiCoreV1PodSpec hostNetwork(Boolean hostNetwork) {
    
    this.hostNetwork = hostNetwork;
    return this;
  }

   /**
   * Host networking requested for this pod. Use the host&#39;s network namespace. If this option is set, the ports that will be used must be specified. Default to false.
   * @return hostNetwork
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified. Default to false.")
  @JsonProperty(JSON_PROPERTY_HOST_NETWORK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHostNetwork() {
    return hostNetwork;
  }


  public void setHostNetwork(Boolean hostNetwork) {
    this.hostNetwork = hostNetwork;
  }


  public IoK8sApiCoreV1PodSpec hostPID(Boolean hostPID) {
    
    this.hostPID = hostPID;
    return this;
  }

   /**
   * Use the host&#39;s pid namespace. Optional: Default to false.
   * @return hostPID
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Use the host's pid namespace. Optional: Default to false.")
  @JsonProperty(JSON_PROPERTY_HOST_P_I_D)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHostPID() {
    return hostPID;
  }


  public void setHostPID(Boolean hostPID) {
    this.hostPID = hostPID;
  }


  public IoK8sApiCoreV1PodSpec hostname(String hostname) {
    
    this.hostname = hostname;
    return this;
  }

   /**
   * Specifies the hostname of the Pod If not specified, the pod&#39;s hostname will be set to a system-defined value.
   * @return hostname
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.")
  @JsonProperty(JSON_PROPERTY_HOSTNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHostname() {
    return hostname;
  }


  public void setHostname(String hostname) {
    this.hostname = hostname;
  }


  public IoK8sApiCoreV1PodSpec imagePullSecrets(List<IoK8sApiCoreV1LocalObjectReference> imagePullSecrets) {
    
    this.imagePullSecrets = imagePullSecrets;
    return this;
  }

  public IoK8sApiCoreV1PodSpec addImagePullSecretsItem(IoK8sApiCoreV1LocalObjectReference imagePullSecretsItem) {
    if (this.imagePullSecrets == null) {
      this.imagePullSecrets = new ArrayList<>();
    }
    this.imagePullSecrets.add(imagePullSecretsItem);
    return this;
  }

   /**
   * ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
   * @return imagePullSecrets
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod")
  @JsonProperty(JSON_PROPERTY_IMAGE_PULL_SECRETS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1LocalObjectReference> getImagePullSecrets() {
    return imagePullSecrets;
  }


  public void setImagePullSecrets(List<IoK8sApiCoreV1LocalObjectReference> imagePullSecrets) {
    this.imagePullSecrets = imagePullSecrets;
  }


  public IoK8sApiCoreV1PodSpec initContainers(List<IoK8sApiCoreV1Container> initContainers) {
    
    this.initContainers = initContainers;
    return this;
  }

  public IoK8sApiCoreV1PodSpec addInitContainersItem(IoK8sApiCoreV1Container initContainersItem) {
    if (this.initContainers == null) {
      this.initContainers = new ArrayList<>();
    }
    this.initContainers.add(initContainersItem);
    return this;
  }

   /**
   * List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
   * @return initContainers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/")
  @JsonProperty(JSON_PROPERTY_INIT_CONTAINERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1Container> getInitContainers() {
    return initContainers;
  }


  public void setInitContainers(List<IoK8sApiCoreV1Container> initContainers) {
    this.initContainers = initContainers;
  }


  public IoK8sApiCoreV1PodSpec nodeName(String nodeName) {
    
    this.nodeName = nodeName;
    return this;
  }

   /**
   * NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.
   * @return nodeName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.")
  @JsonProperty(JSON_PROPERTY_NODE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNodeName() {
    return nodeName;
  }


  public void setNodeName(String nodeName) {
    this.nodeName = nodeName;
  }


  public IoK8sApiCoreV1PodSpec nodeSelector(Map<String, String> nodeSelector) {
    
    this.nodeSelector = nodeSelector;
    return this;
  }

  public IoK8sApiCoreV1PodSpec putNodeSelectorItem(String key, String nodeSelectorItem) {
    if (this.nodeSelector == null) {
      this.nodeSelector = new HashMap<>();
    }
    this.nodeSelector.put(key, nodeSelectorItem);
    return this;
  }

   /**
   * NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node&#39;s labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
   * @return nodeSelector
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/")
  @JsonProperty(JSON_PROPERTY_NODE_SELECTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getNodeSelector() {
    return nodeSelector;
  }


  public void setNodeSelector(Map<String, String> nodeSelector) {
    this.nodeSelector = nodeSelector;
  }


  public IoK8sApiCoreV1PodSpec overhead(Map<String, String> overhead) {
    
    this.overhead = overhead;
    return this;
  }

  public IoK8sApiCoreV1PodSpec putOverheadItem(String key, String overheadItem) {
    if (this.overhead == null) {
      this.overhead = new HashMap<>();
    }
    this.overhead.put(key, overheadItem);
    return this;
  }

   /**
   * Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/20190226-pod-overhead.md This field is alpha-level as of Kubernetes v1.16, and is only honored by servers that enable the PodOverhead feature.
   * @return overhead
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/20190226-pod-overhead.md This field is alpha-level as of Kubernetes v1.16, and is only honored by servers that enable the PodOverhead feature.")
  @JsonProperty(JSON_PROPERTY_OVERHEAD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getOverhead() {
    return overhead;
  }


  public void setOverhead(Map<String, String> overhead) {
    this.overhead = overhead;
  }


  public IoK8sApiCoreV1PodSpec preemptionPolicy(String preemptionPolicy) {
    
    this.preemptionPolicy = preemptionPolicy;
    return this;
  }

   /**
   * PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.
   * @return preemptionPolicy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.")
  @JsonProperty(JSON_PROPERTY_PREEMPTION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPreemptionPolicy() {
    return preemptionPolicy;
  }


  public void setPreemptionPolicy(String preemptionPolicy) {
    this.preemptionPolicy = preemptionPolicy;
  }


  public IoK8sApiCoreV1PodSpec priority(Integer priority) {
    
    this.priority = priority;
    return this;
  }

   /**
   * The priority value. Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority.
   * @return priority
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The priority value. Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority.")
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPriority() {
    return priority;
  }


  public void setPriority(Integer priority) {
    this.priority = priority;
  }


  public IoK8sApiCoreV1PodSpec priorityClassName(String priorityClassName) {
    
    this.priorityClassName = priorityClassName;
    return this;
  }

   /**
   * If specified, indicates the pod&#39;s priority. \&quot;system-node-critical\&quot; and \&quot;system-cluster-critical\&quot; are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.
   * @return priorityClassName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If specified, indicates the pod's priority. \"system-node-critical\" and \"system-cluster-critical\" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.")
  @JsonProperty(JSON_PROPERTY_PRIORITY_CLASS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPriorityClassName() {
    return priorityClassName;
  }


  public void setPriorityClassName(String priorityClassName) {
    this.priorityClassName = priorityClassName;
  }


  public IoK8sApiCoreV1PodSpec readinessGates(List<IoK8sApiCoreV1PodReadinessGate> readinessGates) {
    
    this.readinessGates = readinessGates;
    return this;
  }

  public IoK8sApiCoreV1PodSpec addReadinessGatesItem(IoK8sApiCoreV1PodReadinessGate readinessGatesItem) {
    if (this.readinessGates == null) {
      this.readinessGates = new ArrayList<>();
    }
    this.readinessGates.add(readinessGatesItem);
    return this;
  }

   /**
   * If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to \&quot;True\&quot; More info: https://git.k8s.io/enhancements/keps/sig-network/0007-pod-ready%2B%2B.md
   * @return readinessGates
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to \"True\" More info: https://git.k8s.io/enhancements/keps/sig-network/0007-pod-ready%2B%2B.md")
  @JsonProperty(JSON_PROPERTY_READINESS_GATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1PodReadinessGate> getReadinessGates() {
    return readinessGates;
  }


  public void setReadinessGates(List<IoK8sApiCoreV1PodReadinessGate> readinessGates) {
    this.readinessGates = readinessGates;
  }


  public IoK8sApiCoreV1PodSpec restartPolicy(String restartPolicy) {
    
    this.restartPolicy = restartPolicy;
    return this;
  }

   /**
   * Restart policy for all containers within the pod. One of Always, OnFailure, Never. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
   * @return restartPolicy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restart policy for all containers within the pod. One of Always, OnFailure, Never. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy")
  @JsonProperty(JSON_PROPERTY_RESTART_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRestartPolicy() {
    return restartPolicy;
  }


  public void setRestartPolicy(String restartPolicy) {
    this.restartPolicy = restartPolicy;
  }


  public IoK8sApiCoreV1PodSpec runtimeClassName(String runtimeClassName) {
    
    this.runtimeClassName = runtimeClassName;
    return this;
  }

   /**
   * RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the \&quot;legacy\&quot; RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md This is a beta feature as of Kubernetes v1.14.
   * @return runtimeClassName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the \"legacy\" RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md This is a beta feature as of Kubernetes v1.14.")
  @JsonProperty(JSON_PROPERTY_RUNTIME_CLASS_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRuntimeClassName() {
    return runtimeClassName;
  }


  public void setRuntimeClassName(String runtimeClassName) {
    this.runtimeClassName = runtimeClassName;
  }


  public IoK8sApiCoreV1PodSpec schedulerName(String schedulerName) {
    
    this.schedulerName = schedulerName;
    return this;
  }

   /**
   * If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler.
   * @return schedulerName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler.")
  @JsonProperty(JSON_PROPERTY_SCHEDULER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSchedulerName() {
    return schedulerName;
  }


  public void setSchedulerName(String schedulerName) {
    this.schedulerName = schedulerName;
  }


  public IoK8sApiCoreV1PodSpec securityContext(IoK8sApiCoreV1PodSecurityContext securityContext) {
    
    this.securityContext = securityContext;
    return this;
  }

   /**
   * Get securityContext
   * @return securityContext
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SECURITY_CONTEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IoK8sApiCoreV1PodSecurityContext getSecurityContext() {
    return securityContext;
  }


  public void setSecurityContext(IoK8sApiCoreV1PodSecurityContext securityContext) {
    this.securityContext = securityContext;
  }


  public IoK8sApiCoreV1PodSpec serviceAccount(String serviceAccount) {
    
    this.serviceAccount = serviceAccount;
    return this;
  }

   /**
   * DeprecatedServiceAccount is a depreciated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead.
   * @return serviceAccount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "DeprecatedServiceAccount is a depreciated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead.")
  @JsonProperty(JSON_PROPERTY_SERVICE_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getServiceAccount() {
    return serviceAccount;
  }


  public void setServiceAccount(String serviceAccount) {
    this.serviceAccount = serviceAccount;
  }


  public IoK8sApiCoreV1PodSpec serviceAccountName(String serviceAccountName) {
    
    this.serviceAccountName = serviceAccountName;
    return this;
  }

   /**
   * ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
   * @return serviceAccountName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/")
  @JsonProperty(JSON_PROPERTY_SERVICE_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getServiceAccountName() {
    return serviceAccountName;
  }


  public void setServiceAccountName(String serviceAccountName) {
    this.serviceAccountName = serviceAccountName;
  }


  public IoK8sApiCoreV1PodSpec shareProcessNamespace(Boolean shareProcessNamespace) {
    
    this.shareProcessNamespace = shareProcessNamespace;
    return this;
  }

   /**
   * Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false.
   * @return shareProcessNamespace
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false.")
  @JsonProperty(JSON_PROPERTY_SHARE_PROCESS_NAMESPACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShareProcessNamespace() {
    return shareProcessNamespace;
  }


  public void setShareProcessNamespace(Boolean shareProcessNamespace) {
    this.shareProcessNamespace = shareProcessNamespace;
  }


  public IoK8sApiCoreV1PodSpec subdomain(String subdomain) {
    
    this.subdomain = subdomain;
    return this;
  }

   /**
   * If specified, the fully qualified Pod hostname will be \&quot;&lt;hostname&gt;.&lt;subdomain&gt;.&lt;pod namespace&gt;.svc.&lt;cluster domain&gt;\&quot;. If not specified, the pod will not have a domainname at all.
   * @return subdomain
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If specified, the fully qualified Pod hostname will be \"<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>\". If not specified, the pod will not have a domainname at all.")
  @JsonProperty(JSON_PROPERTY_SUBDOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubdomain() {
    return subdomain;
  }


  public void setSubdomain(String subdomain) {
    this.subdomain = subdomain;
  }


  public IoK8sApiCoreV1PodSpec terminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
    
    this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
    return this;
  }

   /**
   * Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.
   * @return terminationGracePeriodSeconds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.")
  @JsonProperty(JSON_PROPERTY_TERMINATION_GRACE_PERIOD_SECONDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTerminationGracePeriodSeconds() {
    return terminationGracePeriodSeconds;
  }


  public void setTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
    this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
  }


  public IoK8sApiCoreV1PodSpec tolerations(List<IoK8sApiCoreV1Toleration> tolerations) {
    
    this.tolerations = tolerations;
    return this;
  }

  public IoK8sApiCoreV1PodSpec addTolerationsItem(IoK8sApiCoreV1Toleration tolerationsItem) {
    if (this.tolerations == null) {
      this.tolerations = new ArrayList<>();
    }
    this.tolerations.add(tolerationsItem);
    return this;
  }

   /**
   * If specified, the pod&#39;s tolerations.
   * @return tolerations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If specified, the pod's tolerations.")
  @JsonProperty(JSON_PROPERTY_TOLERATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1Toleration> getTolerations() {
    return tolerations;
  }


  public void setTolerations(List<IoK8sApiCoreV1Toleration> tolerations) {
    this.tolerations = tolerations;
  }


  public IoK8sApiCoreV1PodSpec topologySpreadConstraints(List<IoK8sApiCoreV1TopologySpreadConstraint> topologySpreadConstraints) {
    
    this.topologySpreadConstraints = topologySpreadConstraints;
    return this;
  }

  public IoK8sApiCoreV1PodSpec addTopologySpreadConstraintsItem(IoK8sApiCoreV1TopologySpreadConstraint topologySpreadConstraintsItem) {
    if (this.topologySpreadConstraints == null) {
      this.topologySpreadConstraints = new ArrayList<>();
    }
    this.topologySpreadConstraints.add(topologySpreadConstraintsItem);
    return this;
  }

   /**
   * TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. This field is only honored by clusters that enable the EvenPodsSpread feature. All topologySpreadConstraints are ANDed.
   * @return topologySpreadConstraints
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. This field is only honored by clusters that enable the EvenPodsSpread feature. All topologySpreadConstraints are ANDed.")
  @JsonProperty(JSON_PROPERTY_TOPOLOGY_SPREAD_CONSTRAINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1TopologySpreadConstraint> getTopologySpreadConstraints() {
    return topologySpreadConstraints;
  }


  public void setTopologySpreadConstraints(List<IoK8sApiCoreV1TopologySpreadConstraint> topologySpreadConstraints) {
    this.topologySpreadConstraints = topologySpreadConstraints;
  }


  public IoK8sApiCoreV1PodSpec volumes(List<IoK8sApiCoreV1Volume> volumes) {
    
    this.volumes = volumes;
    return this;
  }

  public IoK8sApiCoreV1PodSpec addVolumesItem(IoK8sApiCoreV1Volume volumesItem) {
    if (this.volumes == null) {
      this.volumes = new ArrayList<>();
    }
    this.volumes.add(volumesItem);
    return this;
  }

   /**
   * List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes
   * @return volumes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes")
  @JsonProperty(JSON_PROPERTY_VOLUMES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1Volume> getVolumes() {
    return volumes;
  }


  public void setVolumes(List<IoK8sApiCoreV1Volume> volumes) {
    this.volumes = volumes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IoK8sApiCoreV1PodSpec ioK8sApiCoreV1PodSpec = (IoK8sApiCoreV1PodSpec) o;
    return Objects.equals(this.activeDeadlineSeconds, ioK8sApiCoreV1PodSpec.activeDeadlineSeconds) &&
        Objects.equals(this.affinity, ioK8sApiCoreV1PodSpec.affinity) &&
        Objects.equals(this.automountServiceAccountToken, ioK8sApiCoreV1PodSpec.automountServiceAccountToken) &&
        Objects.equals(this.containers, ioK8sApiCoreV1PodSpec.containers) &&
        Objects.equals(this.dnsConfig, ioK8sApiCoreV1PodSpec.dnsConfig) &&
        Objects.equals(this.dnsPolicy, ioK8sApiCoreV1PodSpec.dnsPolicy) &&
        Objects.equals(this.enableServiceLinks, ioK8sApiCoreV1PodSpec.enableServiceLinks) &&
        Objects.equals(this.ephemeralContainers, ioK8sApiCoreV1PodSpec.ephemeralContainers) &&
        Objects.equals(this.hostAliases, ioK8sApiCoreV1PodSpec.hostAliases) &&
        Objects.equals(this.hostIPC, ioK8sApiCoreV1PodSpec.hostIPC) &&
        Objects.equals(this.hostNetwork, ioK8sApiCoreV1PodSpec.hostNetwork) &&
        Objects.equals(this.hostPID, ioK8sApiCoreV1PodSpec.hostPID) &&
        Objects.equals(this.hostname, ioK8sApiCoreV1PodSpec.hostname) &&
        Objects.equals(this.imagePullSecrets, ioK8sApiCoreV1PodSpec.imagePullSecrets) &&
        Objects.equals(this.initContainers, ioK8sApiCoreV1PodSpec.initContainers) &&
        Objects.equals(this.nodeName, ioK8sApiCoreV1PodSpec.nodeName) &&
        Objects.equals(this.nodeSelector, ioK8sApiCoreV1PodSpec.nodeSelector) &&
        Objects.equals(this.overhead, ioK8sApiCoreV1PodSpec.overhead) &&
        Objects.equals(this.preemptionPolicy, ioK8sApiCoreV1PodSpec.preemptionPolicy) &&
        Objects.equals(this.priority, ioK8sApiCoreV1PodSpec.priority) &&
        Objects.equals(this.priorityClassName, ioK8sApiCoreV1PodSpec.priorityClassName) &&
        Objects.equals(this.readinessGates, ioK8sApiCoreV1PodSpec.readinessGates) &&
        Objects.equals(this.restartPolicy, ioK8sApiCoreV1PodSpec.restartPolicy) &&
        Objects.equals(this.runtimeClassName, ioK8sApiCoreV1PodSpec.runtimeClassName) &&
        Objects.equals(this.schedulerName, ioK8sApiCoreV1PodSpec.schedulerName) &&
        Objects.equals(this.securityContext, ioK8sApiCoreV1PodSpec.securityContext) &&
        Objects.equals(this.serviceAccount, ioK8sApiCoreV1PodSpec.serviceAccount) &&
        Objects.equals(this.serviceAccountName, ioK8sApiCoreV1PodSpec.serviceAccountName) &&
        Objects.equals(this.shareProcessNamespace, ioK8sApiCoreV1PodSpec.shareProcessNamespace) &&
        Objects.equals(this.subdomain, ioK8sApiCoreV1PodSpec.subdomain) &&
        Objects.equals(this.terminationGracePeriodSeconds, ioK8sApiCoreV1PodSpec.terminationGracePeriodSeconds) &&
        Objects.equals(this.tolerations, ioK8sApiCoreV1PodSpec.tolerations) &&
        Objects.equals(this.topologySpreadConstraints, ioK8sApiCoreV1PodSpec.topologySpreadConstraints) &&
        Objects.equals(this.volumes, ioK8sApiCoreV1PodSpec.volumes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(activeDeadlineSeconds, affinity, automountServiceAccountToken, containers, dnsConfig, dnsPolicy, enableServiceLinks, ephemeralContainers, hostAliases, hostIPC, hostNetwork, hostPID, hostname, imagePullSecrets, initContainers, nodeName, nodeSelector, overhead, preemptionPolicy, priority, priorityClassName, readinessGates, restartPolicy, runtimeClassName, schedulerName, securityContext, serviceAccount, serviceAccountName, shareProcessNamespace, subdomain, terminationGracePeriodSeconds, tolerations, topologySpreadConstraints, volumes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IoK8sApiCoreV1PodSpec {\n");
    sb.append("    activeDeadlineSeconds: ").append(toIndentedString(activeDeadlineSeconds)).append("\n");
    sb.append("    affinity: ").append(toIndentedString(affinity)).append("\n");
    sb.append("    automountServiceAccountToken: ").append(toIndentedString(automountServiceAccountToken)).append("\n");
    sb.append("    containers: ").append(toIndentedString(containers)).append("\n");
    sb.append("    dnsConfig: ").append(toIndentedString(dnsConfig)).append("\n");
    sb.append("    dnsPolicy: ").append(toIndentedString(dnsPolicy)).append("\n");
    sb.append("    enableServiceLinks: ").append(toIndentedString(enableServiceLinks)).append("\n");
    sb.append("    ephemeralContainers: ").append(toIndentedString(ephemeralContainers)).append("\n");
    sb.append("    hostAliases: ").append(toIndentedString(hostAliases)).append("\n");
    sb.append("    hostIPC: ").append(toIndentedString(hostIPC)).append("\n");
    sb.append("    hostNetwork: ").append(toIndentedString(hostNetwork)).append("\n");
    sb.append("    hostPID: ").append(toIndentedString(hostPID)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    imagePullSecrets: ").append(toIndentedString(imagePullSecrets)).append("\n");
    sb.append("    initContainers: ").append(toIndentedString(initContainers)).append("\n");
    sb.append("    nodeName: ").append(toIndentedString(nodeName)).append("\n");
    sb.append("    nodeSelector: ").append(toIndentedString(nodeSelector)).append("\n");
    sb.append("    overhead: ").append(toIndentedString(overhead)).append("\n");
    sb.append("    preemptionPolicy: ").append(toIndentedString(preemptionPolicy)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    priorityClassName: ").append(toIndentedString(priorityClassName)).append("\n");
    sb.append("    readinessGates: ").append(toIndentedString(readinessGates)).append("\n");
    sb.append("    restartPolicy: ").append(toIndentedString(restartPolicy)).append("\n");
    sb.append("    runtimeClassName: ").append(toIndentedString(runtimeClassName)).append("\n");
    sb.append("    schedulerName: ").append(toIndentedString(schedulerName)).append("\n");
    sb.append("    securityContext: ").append(toIndentedString(securityContext)).append("\n");
    sb.append("    serviceAccount: ").append(toIndentedString(serviceAccount)).append("\n");
    sb.append("    serviceAccountName: ").append(toIndentedString(serviceAccountName)).append("\n");
    sb.append("    shareProcessNamespace: ").append(toIndentedString(shareProcessNamespace)).append("\n");
    sb.append("    subdomain: ").append(toIndentedString(subdomain)).append("\n");
    sb.append("    terminationGracePeriodSeconds: ").append(toIndentedString(terminationGracePeriodSeconds)).append("\n");
    sb.append("    tolerations: ").append(toIndentedString(tolerations)).append("\n");
    sb.append("    topologySpreadConstraints: ").append(toIndentedString(topologySpreadConstraints)).append("\n");
    sb.append("    volumes: ").append(toIndentedString(volumes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

