/*
 * Kubernetes
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: unversioned
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.stickycode.kuuty.model.v18;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1ContainerStatus;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1PodCondition;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1PodIP;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * PodStatus represents information about the status of a pod. Status may trail the actual state of a system, especially if the node that hosts the pod cannot contact the control plane.
 */
@ApiModel(description = "PodStatus represents information about the status of a pod. Status may trail the actual state of a system, especially if the node that hosts the pod cannot contact the control plane.")
@JsonPropertyOrder({
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_CONDITIONS,
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_CONTAINER_STATUSES,
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_EPHEMERAL_CONTAINER_STATUSES,
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_HOST_I_P,
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_INIT_CONTAINER_STATUSES,
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_MESSAGE,
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_NOMINATED_NODE_NAME,
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_PHASE,
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_POD_I_P,
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_POD_I_PS,
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_QOS_CLASS,
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_REASON,
  IoK8sApiCoreV1PodStatus.JSON_PROPERTY_START_TIME
})
@javax.annotation.processing.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-26T11:01:11.402583+13:00[Pacific/Auckland]")
public class IoK8sApiCoreV1PodStatus {
  public static final String JSON_PROPERTY_CONDITIONS = "conditions";
  private List<IoK8sApiCoreV1PodCondition> conditions = null;

  public static final String JSON_PROPERTY_CONTAINER_STATUSES = "containerStatuses";
  private List<IoK8sApiCoreV1ContainerStatus> containerStatuses = null;

  public static final String JSON_PROPERTY_EPHEMERAL_CONTAINER_STATUSES = "ephemeralContainerStatuses";
  private List<IoK8sApiCoreV1ContainerStatus> ephemeralContainerStatuses = null;

  public static final String JSON_PROPERTY_HOST_I_P = "hostIP";
  private String hostIP;

  public static final String JSON_PROPERTY_INIT_CONTAINER_STATUSES = "initContainerStatuses";
  private List<IoK8sApiCoreV1ContainerStatus> initContainerStatuses = null;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;

  public static final String JSON_PROPERTY_NOMINATED_NODE_NAME = "nominatedNodeName";
  private String nominatedNodeName;

  public static final String JSON_PROPERTY_PHASE = "phase";
  private String phase;

  public static final String JSON_PROPERTY_POD_I_P = "podIP";
  private String podIP;

  public static final String JSON_PROPERTY_POD_I_PS = "podIPs";
  private List<IoK8sApiCoreV1PodIP> podIPs = null;

  public static final String JSON_PROPERTY_QOS_CLASS = "qosClass";
  private String qosClass;

  public static final String JSON_PROPERTY_REASON = "reason";
  private String reason;

  public static final String JSON_PROPERTY_START_TIME = "startTime";
  private OffsetDateTime startTime;


  public IoK8sApiCoreV1PodStatus conditions(List<IoK8sApiCoreV1PodCondition> conditions) {
    
    this.conditions = conditions;
    return this;
  }

  public IoK8sApiCoreV1PodStatus addConditionsItem(IoK8sApiCoreV1PodCondition conditionsItem) {
    if (this.conditions == null) {
      this.conditions = new ArrayList<>();
    }
    this.conditions.add(conditionsItem);
    return this;
  }

   /**
   * Current service state of pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
   * @return conditions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Current service state of pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions")
  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1PodCondition> getConditions() {
    return conditions;
  }


  public void setConditions(List<IoK8sApiCoreV1PodCondition> conditions) {
    this.conditions = conditions;
  }


  public IoK8sApiCoreV1PodStatus containerStatuses(List<IoK8sApiCoreV1ContainerStatus> containerStatuses) {
    
    this.containerStatuses = containerStatuses;
    return this;
  }

  public IoK8sApiCoreV1PodStatus addContainerStatusesItem(IoK8sApiCoreV1ContainerStatus containerStatusesItem) {
    if (this.containerStatuses == null) {
      this.containerStatuses = new ArrayList<>();
    }
    this.containerStatuses.add(containerStatusesItem);
    return this;
  }

   /**
   * The list has one entry per container in the manifest. Each entry is currently the output of &#x60;docker inspect&#x60;. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
   * @return containerStatuses
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The list has one entry per container in the manifest. Each entry is currently the output of `docker inspect`. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status")
  @JsonProperty(JSON_PROPERTY_CONTAINER_STATUSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1ContainerStatus> getContainerStatuses() {
    return containerStatuses;
  }


  public void setContainerStatuses(List<IoK8sApiCoreV1ContainerStatus> containerStatuses) {
    this.containerStatuses = containerStatuses;
  }


  public IoK8sApiCoreV1PodStatus ephemeralContainerStatuses(List<IoK8sApiCoreV1ContainerStatus> ephemeralContainerStatuses) {
    
    this.ephemeralContainerStatuses = ephemeralContainerStatuses;
    return this;
  }

  public IoK8sApiCoreV1PodStatus addEphemeralContainerStatusesItem(IoK8sApiCoreV1ContainerStatus ephemeralContainerStatusesItem) {
    if (this.ephemeralContainerStatuses == null) {
      this.ephemeralContainerStatuses = new ArrayList<>();
    }
    this.ephemeralContainerStatuses.add(ephemeralContainerStatusesItem);
    return this;
  }

   /**
   * Status for any ephemeral containers that have run in this pod. This field is alpha-level and is only populated by servers that enable the EphemeralContainers feature.
   * @return ephemeralContainerStatuses
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Status for any ephemeral containers that have run in this pod. This field is alpha-level and is only populated by servers that enable the EphemeralContainers feature.")
  @JsonProperty(JSON_PROPERTY_EPHEMERAL_CONTAINER_STATUSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1ContainerStatus> getEphemeralContainerStatuses() {
    return ephemeralContainerStatuses;
  }


  public void setEphemeralContainerStatuses(List<IoK8sApiCoreV1ContainerStatus> ephemeralContainerStatuses) {
    this.ephemeralContainerStatuses = ephemeralContainerStatuses;
  }


  public IoK8sApiCoreV1PodStatus hostIP(String hostIP) {
    
    this.hostIP = hostIP;
    return this;
  }

   /**
   * IP address of the host to which the pod is assigned. Empty if not yet scheduled.
   * @return hostIP
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "IP address of the host to which the pod is assigned. Empty if not yet scheduled.")
  @JsonProperty(JSON_PROPERTY_HOST_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHostIP() {
    return hostIP;
  }


  public void setHostIP(String hostIP) {
    this.hostIP = hostIP;
  }


  public IoK8sApiCoreV1PodStatus initContainerStatuses(List<IoK8sApiCoreV1ContainerStatus> initContainerStatuses) {
    
    this.initContainerStatuses = initContainerStatuses;
    return this;
  }

  public IoK8sApiCoreV1PodStatus addInitContainerStatusesItem(IoK8sApiCoreV1ContainerStatus initContainerStatusesItem) {
    if (this.initContainerStatuses == null) {
      this.initContainerStatuses = new ArrayList<>();
    }
    this.initContainerStatuses.add(initContainerStatusesItem);
    return this;
  }

   /**
   * The list has one entry per init container in the manifest. The most recent successful init container will have ready &#x3D; true, the most recently started container will have startTime set. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
   * @return initContainerStatuses
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The list has one entry per init container in the manifest. The most recent successful init container will have ready = true, the most recently started container will have startTime set. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status")
  @JsonProperty(JSON_PROPERTY_INIT_CONTAINER_STATUSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1ContainerStatus> getInitContainerStatuses() {
    return initContainerStatuses;
  }


  public void setInitContainerStatuses(List<IoK8sApiCoreV1ContainerStatus> initContainerStatuses) {
    this.initContainerStatuses = initContainerStatuses;
  }


  public IoK8sApiCoreV1PodStatus message(String message) {
    
    this.message = message;
    return this;
  }

   /**
   * A human readable message indicating details about why the pod is in this condition.
   * @return message
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A human readable message indicating details about why the pod is in this condition.")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }


  public void setMessage(String message) {
    this.message = message;
  }


  public IoK8sApiCoreV1PodStatus nominatedNodeName(String nominatedNodeName) {
    
    this.nominatedNodeName = nominatedNodeName;
    return this;
  }

   /**
   * nominatedNodeName is set only when this pod preempts other pods on the node, but it cannot be scheduled right away as preemption victims receive their graceful termination periods. This field does not guarantee that the pod will be scheduled on this node. Scheduler may decide to place the pod elsewhere if other nodes become available sooner. Scheduler may also decide to give the resources on this node to a higher priority pod that is created after preemption. As a result, this field may be different than PodSpec.nodeName when the pod is scheduled.
   * @return nominatedNodeName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "nominatedNodeName is set only when this pod preempts other pods on the node, but it cannot be scheduled right away as preemption victims receive their graceful termination periods. This field does not guarantee that the pod will be scheduled on this node. Scheduler may decide to place the pod elsewhere if other nodes become available sooner. Scheduler may also decide to give the resources on this node to a higher priority pod that is created after preemption. As a result, this field may be different than PodSpec.nodeName when the pod is scheduled.")
  @JsonProperty(JSON_PROPERTY_NOMINATED_NODE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNominatedNodeName() {
    return nominatedNodeName;
  }


  public void setNominatedNodeName(String nominatedNodeName) {
    this.nominatedNodeName = nominatedNodeName;
  }


  public IoK8sApiCoreV1PodStatus phase(String phase) {
    
    this.phase = phase;
    return this;
  }

   /**
   * The phase of a Pod is a simple, high-level summary of where the Pod is in its lifecycle. The conditions array, the reason and message fields, and the individual container status arrays contain more detail about the pod&#39;s status. There are five possible phase values:  Pending: The pod has been accepted by the Kubernetes system, but one or more of the container images has not been created. This includes time before being scheduled as well as time spent downloading images over the network, which could take a while. Running: The pod has been bound to a node, and all of the containers have been created. At least one container is still running, or is in the process of starting or restarting. Succeeded: All containers in the pod have terminated in success, and will not be restarted. Failed: All containers in the pod have terminated, and at least one container has terminated in failure. The container either exited with non-zero status or was terminated by the system. Unknown: For some reason the state of the pod could not be obtained, typically due to an error in communicating with the host of the pod.  More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase
   * @return phase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The phase of a Pod is a simple, high-level summary of where the Pod is in its lifecycle. The conditions array, the reason and message fields, and the individual container status arrays contain more detail about the pod's status. There are five possible phase values:  Pending: The pod has been accepted by the Kubernetes system, but one or more of the container images has not been created. This includes time before being scheduled as well as time spent downloading images over the network, which could take a while. Running: The pod has been bound to a node, and all of the containers have been created. At least one container is still running, or is in the process of starting or restarting. Succeeded: All containers in the pod have terminated in success, and will not be restarted. Failed: All containers in the pod have terminated, and at least one container has terminated in failure. The container either exited with non-zero status or was terminated by the system. Unknown: For some reason the state of the pod could not be obtained, typically due to an error in communicating with the host of the pod.  More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase")
  @JsonProperty(JSON_PROPERTY_PHASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPhase() {
    return phase;
  }


  public void setPhase(String phase) {
    this.phase = phase;
  }


  public IoK8sApiCoreV1PodStatus podIP(String podIP) {
    
    this.podIP = podIP;
    return this;
  }

   /**
   * IP address allocated to the pod. Routable at least within the cluster. Empty if not yet allocated.
   * @return podIP
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "IP address allocated to the pod. Routable at least within the cluster. Empty if not yet allocated.")
  @JsonProperty(JSON_PROPERTY_POD_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPodIP() {
    return podIP;
  }


  public void setPodIP(String podIP) {
    this.podIP = podIP;
  }


  public IoK8sApiCoreV1PodStatus podIPs(List<IoK8sApiCoreV1PodIP> podIPs) {
    
    this.podIPs = podIPs;
    return this;
  }

  public IoK8sApiCoreV1PodStatus addPodIPsItem(IoK8sApiCoreV1PodIP podIPsItem) {
    if (this.podIPs == null) {
      this.podIPs = new ArrayList<>();
    }
    this.podIPs.add(podIPsItem);
    return this;
  }

   /**
   * podIPs holds the IP addresses allocated to the pod. If this field is specified, the 0th entry must match the podIP field. Pods may be allocated at most 1 value for each of IPv4 and IPv6. This list is empty if no IPs have been allocated yet.
   * @return podIPs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "podIPs holds the IP addresses allocated to the pod. If this field is specified, the 0th entry must match the podIP field. Pods may be allocated at most 1 value for each of IPv4 and IPv6. This list is empty if no IPs have been allocated yet.")
  @JsonProperty(JSON_PROPERTY_POD_I_PS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1PodIP> getPodIPs() {
    return podIPs;
  }


  public void setPodIPs(List<IoK8sApiCoreV1PodIP> podIPs) {
    this.podIPs = podIPs;
  }


  public IoK8sApiCoreV1PodStatus qosClass(String qosClass) {
    
    this.qosClass = qosClass;
    return this;
  }

   /**
   * The Quality of Service (QOS) classification assigned to the pod based on resource requirements See PodQOSClass type for available QOS classes More info: https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md
   * @return qosClass
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The Quality of Service (QOS) classification assigned to the pod based on resource requirements See PodQOSClass type for available QOS classes More info: https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md")
  @JsonProperty(JSON_PROPERTY_QOS_CLASS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getQosClass() {
    return qosClass;
  }


  public void setQosClass(String qosClass) {
    this.qosClass = qosClass;
  }


  public IoK8sApiCoreV1PodStatus reason(String reason) {
    
    this.reason = reason;
    return this;
  }

   /**
   * A brief CamelCase message indicating details about why the pod is in this state. e.g. &#39;Evicted&#39;
   * @return reason
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A brief CamelCase message indicating details about why the pod is in this state. e.g. 'Evicted'")
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReason() {
    return reason;
  }


  public void setReason(String reason) {
    this.reason = reason;
  }


  public IoK8sApiCoreV1PodStatus startTime(OffsetDateTime startTime) {
    
    this.startTime = startTime;
    return this;
  }

   /**
   * Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.
   * @return startTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.")
  @JsonProperty(JSON_PROPERTY_START_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getStartTime() {
    return startTime;
  }


  public void setStartTime(OffsetDateTime startTime) {
    this.startTime = startTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IoK8sApiCoreV1PodStatus ioK8sApiCoreV1PodStatus = (IoK8sApiCoreV1PodStatus) o;
    return Objects.equals(this.conditions, ioK8sApiCoreV1PodStatus.conditions) &&
        Objects.equals(this.containerStatuses, ioK8sApiCoreV1PodStatus.containerStatuses) &&
        Objects.equals(this.ephemeralContainerStatuses, ioK8sApiCoreV1PodStatus.ephemeralContainerStatuses) &&
        Objects.equals(this.hostIP, ioK8sApiCoreV1PodStatus.hostIP) &&
        Objects.equals(this.initContainerStatuses, ioK8sApiCoreV1PodStatus.initContainerStatuses) &&
        Objects.equals(this.message, ioK8sApiCoreV1PodStatus.message) &&
        Objects.equals(this.nominatedNodeName, ioK8sApiCoreV1PodStatus.nominatedNodeName) &&
        Objects.equals(this.phase, ioK8sApiCoreV1PodStatus.phase) &&
        Objects.equals(this.podIP, ioK8sApiCoreV1PodStatus.podIP) &&
        Objects.equals(this.podIPs, ioK8sApiCoreV1PodStatus.podIPs) &&
        Objects.equals(this.qosClass, ioK8sApiCoreV1PodStatus.qosClass) &&
        Objects.equals(this.reason, ioK8sApiCoreV1PodStatus.reason) &&
        Objects.equals(this.startTime, ioK8sApiCoreV1PodStatus.startTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(conditions, containerStatuses, ephemeralContainerStatuses, hostIP, initContainerStatuses, message, nominatedNodeName, phase, podIP, podIPs, qosClass, reason, startTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IoK8sApiCoreV1PodStatus {\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    containerStatuses: ").append(toIndentedString(containerStatuses)).append("\n");
    sb.append("    ephemeralContainerStatuses: ").append(toIndentedString(ephemeralContainerStatuses)).append("\n");
    sb.append("    hostIP: ").append(toIndentedString(hostIP)).append("\n");
    sb.append("    initContainerStatuses: ").append(toIndentedString(initContainerStatuses)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    nominatedNodeName: ").append(toIndentedString(nominatedNodeName)).append("\n");
    sb.append("    phase: ").append(toIndentedString(phase)).append("\n");
    sb.append("    podIP: ").append(toIndentedString(podIP)).append("\n");
    sb.append("    podIPs: ").append(toIndentedString(podIPs)).append("\n");
    sb.append("    qosClass: ").append(toIndentedString(qosClass)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

