/*
 * Kubernetes
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: unversioned
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.stickycode.kuuty.model.v18;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1SecretReference;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.
 */
@ApiModel(description = "Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.")
@JsonPropertyOrder({
  IoK8sApiCoreV1RBDPersistentVolumeSource.JSON_PROPERTY_FS_TYPE,
  IoK8sApiCoreV1RBDPersistentVolumeSource.JSON_PROPERTY_IMAGE,
  IoK8sApiCoreV1RBDPersistentVolumeSource.JSON_PROPERTY_KEYRING,
  IoK8sApiCoreV1RBDPersistentVolumeSource.JSON_PROPERTY_MONITORS,
  IoK8sApiCoreV1RBDPersistentVolumeSource.JSON_PROPERTY_POOL,
  IoK8sApiCoreV1RBDPersistentVolumeSource.JSON_PROPERTY_READ_ONLY,
  IoK8sApiCoreV1RBDPersistentVolumeSource.JSON_PROPERTY_SECRET_REF,
  IoK8sApiCoreV1RBDPersistentVolumeSource.JSON_PROPERTY_USER
})
@javax.annotation.processing.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-26T11:01:11.402583+13:00[Pacific/Auckland]")
public class IoK8sApiCoreV1RBDPersistentVolumeSource {
  public static final String JSON_PROPERTY_FS_TYPE = "fsType";
  private String fsType;

  public static final String JSON_PROPERTY_IMAGE = "image";
  private String image;

  public static final String JSON_PROPERTY_KEYRING = "keyring";
  private String keyring;

  public static final String JSON_PROPERTY_MONITORS = "monitors";
  private List<String> monitors = new ArrayList<>();

  public static final String JSON_PROPERTY_POOL = "pool";
  private String pool;

  public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
  private Boolean readOnly;

  public static final String JSON_PROPERTY_SECRET_REF = "secretRef";
  private IoK8sApiCoreV1SecretReference secretRef;

  public static final String JSON_PROPERTY_USER = "user";
  private String user;


  public IoK8sApiCoreV1RBDPersistentVolumeSource fsType(String fsType) {
    
    this.fsType = fsType;
    return this;
  }

   /**
   * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \&quot;ext4\&quot;, \&quot;xfs\&quot;, \&quot;ntfs\&quot;. Implicitly inferred to be \&quot;ext4\&quot; if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
   * @return fsType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd")
  @JsonProperty(JSON_PROPERTY_FS_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFsType() {
    return fsType;
  }


  public void setFsType(String fsType) {
    this.fsType = fsType;
  }


  public IoK8sApiCoreV1RBDPersistentVolumeSource image(String image) {
    
    this.image = image;
    return this;
  }

   /**
   * The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * @return image
  **/
  @ApiModelProperty(required = true, value = "The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
  @JsonProperty(JSON_PROPERTY_IMAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getImage() {
    return image;
  }


  public void setImage(String image) {
    this.image = image;
  }


  public IoK8sApiCoreV1RBDPersistentVolumeSource keyring(String keyring) {
    
    this.keyring = keyring;
    return this;
  }

   /**
   * Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * @return keyring
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
  @JsonProperty(JSON_PROPERTY_KEYRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getKeyring() {
    return keyring;
  }


  public void setKeyring(String keyring) {
    this.keyring = keyring;
  }


  public IoK8sApiCoreV1RBDPersistentVolumeSource monitors(List<String> monitors) {
    
    this.monitors = monitors;
    return this;
  }

  public IoK8sApiCoreV1RBDPersistentVolumeSource addMonitorsItem(String monitorsItem) {
    this.monitors.add(monitorsItem);
    return this;
  }

   /**
   * A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * @return monitors
  **/
  @ApiModelProperty(required = true, value = "A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
  @JsonProperty(JSON_PROPERTY_MONITORS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getMonitors() {
    return monitors;
  }


  public void setMonitors(List<String> monitors) {
    this.monitors = monitors;
  }


  public IoK8sApiCoreV1RBDPersistentVolumeSource pool(String pool) {
    
    this.pool = pool;
    return this;
  }

   /**
   * The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * @return pool
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
  @JsonProperty(JSON_PROPERTY_POOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPool() {
    return pool;
  }


  public void setPool(String pool) {
    this.pool = pool;
  }


  public IoK8sApiCoreV1RBDPersistentVolumeSource readOnly(Boolean readOnly) {
    
    this.readOnly = readOnly;
    return this;
  }

   /**
   * ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * @return readOnly
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
  @JsonProperty(JSON_PROPERTY_READ_ONLY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReadOnly() {
    return readOnly;
  }


  public void setReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
  }


  public IoK8sApiCoreV1RBDPersistentVolumeSource secretRef(IoK8sApiCoreV1SecretReference secretRef) {
    
    this.secretRef = secretRef;
    return this;
  }

   /**
   * Get secretRef
   * @return secretRef
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SECRET_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IoK8sApiCoreV1SecretReference getSecretRef() {
    return secretRef;
  }


  public void setSecretRef(IoK8sApiCoreV1SecretReference secretRef) {
    this.secretRef = secretRef;
  }


  public IoK8sApiCoreV1RBDPersistentVolumeSource user(String user) {
    
    this.user = user;
    return this;
  }

   /**
   * The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * @return user
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUser() {
    return user;
  }


  public void setUser(String user) {
    this.user = user;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IoK8sApiCoreV1RBDPersistentVolumeSource ioK8sApiCoreV1RBDPersistentVolumeSource = (IoK8sApiCoreV1RBDPersistentVolumeSource) o;
    return Objects.equals(this.fsType, ioK8sApiCoreV1RBDPersistentVolumeSource.fsType) &&
        Objects.equals(this.image, ioK8sApiCoreV1RBDPersistentVolumeSource.image) &&
        Objects.equals(this.keyring, ioK8sApiCoreV1RBDPersistentVolumeSource.keyring) &&
        Objects.equals(this.monitors, ioK8sApiCoreV1RBDPersistentVolumeSource.monitors) &&
        Objects.equals(this.pool, ioK8sApiCoreV1RBDPersistentVolumeSource.pool) &&
        Objects.equals(this.readOnly, ioK8sApiCoreV1RBDPersistentVolumeSource.readOnly) &&
        Objects.equals(this.secretRef, ioK8sApiCoreV1RBDPersistentVolumeSource.secretRef) &&
        Objects.equals(this.user, ioK8sApiCoreV1RBDPersistentVolumeSource.user);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fsType, image, keyring, monitors, pool, readOnly, secretRef, user);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IoK8sApiCoreV1RBDPersistentVolumeSource {\n");
    sb.append("    fsType: ").append(toIndentedString(fsType)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    keyring: ").append(toIndentedString(keyring)).append("\n");
    sb.append("    monitors: ").append(toIndentedString(monitors)).append("\n");
    sb.append("    pool: ").append(toIndentedString(pool)).append("\n");
    sb.append("    readOnly: ").append(toIndentedString(readOnly)).append("\n");
    sb.append("    secretRef: ").append(toIndentedString(secretRef)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

