/*
 * Kubernetes
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: unversioned
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.stickycode.kuuty.model.v18;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1ServicePort;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1SessionAffinityConfig;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * ServiceSpec describes the attributes that a user creates on a service.
 */
@ApiModel(description = "ServiceSpec describes the attributes that a user creates on a service.")
@JsonPropertyOrder({
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_CLUSTER_I_P,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_EXTERNAL_I_PS,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_EXTERNAL_NAME,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_EXTERNAL_TRAFFIC_POLICY,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_HEALTH_CHECK_NODE_PORT,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_IP_FAMILY,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_LOAD_BALANCER_I_P,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_LOAD_BALANCER_SOURCE_RANGES,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_PORTS,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_PUBLISH_NOT_READY_ADDRESSES,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_SELECTOR,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_SESSION_AFFINITY,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_SESSION_AFFINITY_CONFIG,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_TOPOLOGY_KEYS,
  IoK8sApiCoreV1ServiceSpec.JSON_PROPERTY_TYPE
})
@javax.annotation.processing.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-26T11:01:11.402583+13:00[Pacific/Auckland]")
public class IoK8sApiCoreV1ServiceSpec {
  public static final String JSON_PROPERTY_CLUSTER_I_P = "clusterIP";
  private String clusterIP;

  public static final String JSON_PROPERTY_EXTERNAL_I_PS = "externalIPs";
  private List<String> externalIPs = null;

  public static final String JSON_PROPERTY_EXTERNAL_NAME = "externalName";
  private String externalName;

  public static final String JSON_PROPERTY_EXTERNAL_TRAFFIC_POLICY = "externalTrafficPolicy";
  private String externalTrafficPolicy;

  public static final String JSON_PROPERTY_HEALTH_CHECK_NODE_PORT = "healthCheckNodePort";
  private Integer healthCheckNodePort;

  public static final String JSON_PROPERTY_IP_FAMILY = "ipFamily";
  private String ipFamily;

  public static final String JSON_PROPERTY_LOAD_BALANCER_I_P = "loadBalancerIP";
  private String loadBalancerIP;

  public static final String JSON_PROPERTY_LOAD_BALANCER_SOURCE_RANGES = "loadBalancerSourceRanges";
  private List<String> loadBalancerSourceRanges = null;

  public static final String JSON_PROPERTY_PORTS = "ports";
  private List<IoK8sApiCoreV1ServicePort> ports = null;

  public static final String JSON_PROPERTY_PUBLISH_NOT_READY_ADDRESSES = "publishNotReadyAddresses";
  private Boolean publishNotReadyAddresses;

  public static final String JSON_PROPERTY_SELECTOR = "selector";
  private Map<String, String> selector = null;

  public static final String JSON_PROPERTY_SESSION_AFFINITY = "sessionAffinity";
  private String sessionAffinity;

  public static final String JSON_PROPERTY_SESSION_AFFINITY_CONFIG = "sessionAffinityConfig";
  private IoK8sApiCoreV1SessionAffinityConfig sessionAffinityConfig;

  public static final String JSON_PROPERTY_TOPOLOGY_KEYS = "topologyKeys";
  private List<String> topologyKeys = null;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;


  public IoK8sApiCoreV1ServiceSpec clusterIP(String clusterIP) {
    
    this.clusterIP = clusterIP;
    return this;
  }

   /**
   * clusterIP is the IP address of the service and is usually assigned randomly by the master. If an address is specified manually and is not in use by others, it will be allocated to the service; otherwise, creation of the service will fail. This field can not be changed through updates. Valid values are \&quot;None\&quot;, empty string (\&quot;\&quot;), or a valid IP address. \&quot;None\&quot; can be specified for headless services when proxying is not required. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
   * @return clusterIP
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "clusterIP is the IP address of the service and is usually assigned randomly by the master. If an address is specified manually and is not in use by others, it will be allocated to the service; otherwise, creation of the service will fail. This field can not be changed through updates. Valid values are \"None\", empty string (\"\"), or a valid IP address. \"None\" can be specified for headless services when proxying is not required. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies")
  @JsonProperty(JSON_PROPERTY_CLUSTER_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClusterIP() {
    return clusterIP;
  }


  public void setClusterIP(String clusterIP) {
    this.clusterIP = clusterIP;
  }


  public IoK8sApiCoreV1ServiceSpec externalIPs(List<String> externalIPs) {
    
    this.externalIPs = externalIPs;
    return this;
  }

  public IoK8sApiCoreV1ServiceSpec addExternalIPsItem(String externalIPsItem) {
    if (this.externalIPs == null) {
      this.externalIPs = new ArrayList<>();
    }
    this.externalIPs.add(externalIPsItem);
    return this;
  }

   /**
   * externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
   * @return externalIPs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_I_PS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getExternalIPs() {
    return externalIPs;
  }


  public void setExternalIPs(List<String> externalIPs) {
    this.externalIPs = externalIPs;
  }


  public IoK8sApiCoreV1ServiceSpec externalName(String externalName) {
    
    this.externalName = externalName;
    return this;
  }

   /**
   * externalName is the external reference that kubedns or equivalent will return as a CNAME record for this service. No proxying will be involved. Must be a valid RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires Type to be ExternalName.
   * @return externalName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "externalName is the external reference that kubedns or equivalent will return as a CNAME record for this service. No proxying will be involved. Must be a valid RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires Type to be ExternalName.")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalName() {
    return externalName;
  }


  public void setExternalName(String externalName) {
    this.externalName = externalName;
  }


  public IoK8sApiCoreV1ServiceSpec externalTrafficPolicy(String externalTrafficPolicy) {
    
    this.externalTrafficPolicy = externalTrafficPolicy;
    return this;
  }

   /**
   * externalTrafficPolicy denotes if this Service desires to route external traffic to node-local or cluster-wide endpoints. \&quot;Local\&quot; preserves the client source IP and avoids a second hop for LoadBalancer and Nodeport type services, but risks potentially imbalanced traffic spreading. \&quot;Cluster\&quot; obscures the client source IP and may cause a second hop to another node, but should have good overall load-spreading.
   * @return externalTrafficPolicy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "externalTrafficPolicy denotes if this Service desires to route external traffic to node-local or cluster-wide endpoints. \"Local\" preserves the client source IP and avoids a second hop for LoadBalancer and Nodeport type services, but risks potentially imbalanced traffic spreading. \"Cluster\" obscures the client source IP and may cause a second hop to another node, but should have good overall load-spreading.")
  @JsonProperty(JSON_PROPERTY_EXTERNAL_TRAFFIC_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalTrafficPolicy() {
    return externalTrafficPolicy;
  }


  public void setExternalTrafficPolicy(String externalTrafficPolicy) {
    this.externalTrafficPolicy = externalTrafficPolicy;
  }


  public IoK8sApiCoreV1ServiceSpec healthCheckNodePort(Integer healthCheckNodePort) {
    
    this.healthCheckNodePort = healthCheckNodePort;
    return this;
  }

   /**
   * healthCheckNodePort specifies the healthcheck nodePort for the service. If not specified, HealthCheckNodePort is created by the service api backend with the allocated nodePort. Will use user-specified nodePort value if specified by the client. Only effects when Type is set to LoadBalancer and ExternalTrafficPolicy is set to Local.
   * @return healthCheckNodePort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "healthCheckNodePort specifies the healthcheck nodePort for the service. If not specified, HealthCheckNodePort is created by the service api backend with the allocated nodePort. Will use user-specified nodePort value if specified by the client. Only effects when Type is set to LoadBalancer and ExternalTrafficPolicy is set to Local.")
  @JsonProperty(JSON_PROPERTY_HEALTH_CHECK_NODE_PORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getHealthCheckNodePort() {
    return healthCheckNodePort;
  }


  public void setHealthCheckNodePort(Integer healthCheckNodePort) {
    this.healthCheckNodePort = healthCheckNodePort;
  }


  public IoK8sApiCoreV1ServiceSpec ipFamily(String ipFamily) {
    
    this.ipFamily = ipFamily;
    return this;
  }

   /**
   * ipFamily specifies whether this Service has a preference for a particular IP family (e.g. IPv4 vs. IPv6).  If a specific IP family is requested, the clusterIP field will be allocated from that family, if it is available in the cluster.  If no IP family is requested, the cluster&#39;s primary IP family will be used. Other IP fields (loadBalancerIP, loadBalancerSourceRanges, externalIPs) and controllers which allocate external load-balancers should use the same IP family.  Endpoints for this Service will be of this family.  This field is immutable after creation. Assigning a ServiceIPFamily not available in the cluster (e.g. IPv6 in IPv4 only cluster) is an error condition and will fail during clusterIP assignment.
   * @return ipFamily
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ipFamily specifies whether this Service has a preference for a particular IP family (e.g. IPv4 vs. IPv6).  If a specific IP family is requested, the clusterIP field will be allocated from that family, if it is available in the cluster.  If no IP family is requested, the cluster's primary IP family will be used. Other IP fields (loadBalancerIP, loadBalancerSourceRanges, externalIPs) and controllers which allocate external load-balancers should use the same IP family.  Endpoints for this Service will be of this family.  This field is immutable after creation. Assigning a ServiceIPFamily not available in the cluster (e.g. IPv6 in IPv4 only cluster) is an error condition and will fail during clusterIP assignment.")
  @JsonProperty(JSON_PROPERTY_IP_FAMILY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIpFamily() {
    return ipFamily;
  }


  public void setIpFamily(String ipFamily) {
    this.ipFamily = ipFamily;
  }


  public IoK8sApiCoreV1ServiceSpec loadBalancerIP(String loadBalancerIP) {
    
    this.loadBalancerIP = loadBalancerIP;
    return this;
  }

   /**
   * Only applies to Service Type: LoadBalancer LoadBalancer will get created with the IP specified in this field. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature.
   * @return loadBalancerIP
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only applies to Service Type: LoadBalancer LoadBalancer will get created with the IP specified in this field. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature.")
  @JsonProperty(JSON_PROPERTY_LOAD_BALANCER_I_P)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLoadBalancerIP() {
    return loadBalancerIP;
  }


  public void setLoadBalancerIP(String loadBalancerIP) {
    this.loadBalancerIP = loadBalancerIP;
  }


  public IoK8sApiCoreV1ServiceSpec loadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
    
    this.loadBalancerSourceRanges = loadBalancerSourceRanges;
    return this;
  }

  public IoK8sApiCoreV1ServiceSpec addLoadBalancerSourceRangesItem(String loadBalancerSourceRangesItem) {
    if (this.loadBalancerSourceRanges == null) {
      this.loadBalancerSourceRanges = new ArrayList<>();
    }
    this.loadBalancerSourceRanges.add(loadBalancerSourceRangesItem);
    return this;
  }

   /**
   * If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.\&quot; More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
   * @return loadBalancerSourceRanges
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.\" More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/")
  @JsonProperty(JSON_PROPERTY_LOAD_BALANCER_SOURCE_RANGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getLoadBalancerSourceRanges() {
    return loadBalancerSourceRanges;
  }


  public void setLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
    this.loadBalancerSourceRanges = loadBalancerSourceRanges;
  }


  public IoK8sApiCoreV1ServiceSpec ports(List<IoK8sApiCoreV1ServicePort> ports) {
    
    this.ports = ports;
    return this;
  }

  public IoK8sApiCoreV1ServiceSpec addPortsItem(IoK8sApiCoreV1ServicePort portsItem) {
    if (this.ports == null) {
      this.ports = new ArrayList<>();
    }
    this.ports.add(portsItem);
    return this;
  }

   /**
   * The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
   * @return ports
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies")
  @JsonProperty(JSON_PROPERTY_PORTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1ServicePort> getPorts() {
    return ports;
  }


  public void setPorts(List<IoK8sApiCoreV1ServicePort> ports) {
    this.ports = ports;
  }


  public IoK8sApiCoreV1ServiceSpec publishNotReadyAddresses(Boolean publishNotReadyAddresses) {
    
    this.publishNotReadyAddresses = publishNotReadyAddresses;
    return this;
  }

   /**
   * publishNotReadyAddresses, when set to true, indicates that DNS implementations must publish the notReadyAddresses of subsets for the Endpoints associated with the Service. The default value is false. The primary use case for setting this field is to use a StatefulSet&#39;s Headless Service to propagate SRV records for its Pods without respect to their readiness for purpose of peer discovery.
   * @return publishNotReadyAddresses
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "publishNotReadyAddresses, when set to true, indicates that DNS implementations must publish the notReadyAddresses of subsets for the Endpoints associated with the Service. The default value is false. The primary use case for setting this field is to use a StatefulSet's Headless Service to propagate SRV records for its Pods without respect to their readiness for purpose of peer discovery.")
  @JsonProperty(JSON_PROPERTY_PUBLISH_NOT_READY_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPublishNotReadyAddresses() {
    return publishNotReadyAddresses;
  }


  public void setPublishNotReadyAddresses(Boolean publishNotReadyAddresses) {
    this.publishNotReadyAddresses = publishNotReadyAddresses;
  }


  public IoK8sApiCoreV1ServiceSpec selector(Map<String, String> selector) {
    
    this.selector = selector;
    return this;
  }

  public IoK8sApiCoreV1ServiceSpec putSelectorItem(String key, String selectorItem) {
    if (this.selector == null) {
      this.selector = new HashMap<>();
    }
    this.selector.put(key, selectorItem);
    return this;
  }

   /**
   * Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
   * @return selector
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/")
  @JsonProperty(JSON_PROPERTY_SELECTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getSelector() {
    return selector;
  }


  public void setSelector(Map<String, String> selector) {
    this.selector = selector;
  }


  public IoK8sApiCoreV1ServiceSpec sessionAffinity(String sessionAffinity) {
    
    this.sessionAffinity = sessionAffinity;
    return this;
  }

   /**
   * Supports \&quot;ClientIP\&quot; and \&quot;None\&quot;. Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
   * @return sessionAffinity
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Supports \"ClientIP\" and \"None\". Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies")
  @JsonProperty(JSON_PROPERTY_SESSION_AFFINITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSessionAffinity() {
    return sessionAffinity;
  }


  public void setSessionAffinity(String sessionAffinity) {
    this.sessionAffinity = sessionAffinity;
  }


  public IoK8sApiCoreV1ServiceSpec sessionAffinityConfig(IoK8sApiCoreV1SessionAffinityConfig sessionAffinityConfig) {
    
    this.sessionAffinityConfig = sessionAffinityConfig;
    return this;
  }

   /**
   * Get sessionAffinityConfig
   * @return sessionAffinityConfig
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SESSION_AFFINITY_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IoK8sApiCoreV1SessionAffinityConfig getSessionAffinityConfig() {
    return sessionAffinityConfig;
  }


  public void setSessionAffinityConfig(IoK8sApiCoreV1SessionAffinityConfig sessionAffinityConfig) {
    this.sessionAffinityConfig = sessionAffinityConfig;
  }


  public IoK8sApiCoreV1ServiceSpec topologyKeys(List<String> topologyKeys) {
    
    this.topologyKeys = topologyKeys;
    return this;
  }

  public IoK8sApiCoreV1ServiceSpec addTopologyKeysItem(String topologyKeysItem) {
    if (this.topologyKeys == null) {
      this.topologyKeys = new ArrayList<>();
    }
    this.topologyKeys.add(topologyKeysItem);
    return this;
  }

   /**
   * topologyKeys is a preference-order list of topology keys which implementations of services should use to preferentially sort endpoints when accessing this Service, it can not be used at the same time as externalTrafficPolicy&#x3D;Local. Topology keys must be valid label keys and at most 16 keys may be specified. Endpoints are chosen based on the first topology key with available backends. If this field is specified and all entries have no backends that match the topology of the client, the service has no backends for that client and connections should fail. The special value \&quot;*\&quot; may be used to mean \&quot;any topology\&quot;. This catch-all value, if used, only makes sense as the last value in the list. If this is not specified or empty, no topology constraints will be applied.
   * @return topologyKeys
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "topologyKeys is a preference-order list of topology keys which implementations of services should use to preferentially sort endpoints when accessing this Service, it can not be used at the same time as externalTrafficPolicy=Local. Topology keys must be valid label keys and at most 16 keys may be specified. Endpoints are chosen based on the first topology key with available backends. If this field is specified and all entries have no backends that match the topology of the client, the service has no backends for that client and connections should fail. The special value \"*\" may be used to mean \"any topology\". This catch-all value, if used, only makes sense as the last value in the list. If this is not specified or empty, no topology constraints will be applied.")
  @JsonProperty(JSON_PROPERTY_TOPOLOGY_KEYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getTopologyKeys() {
    return topologyKeys;
  }


  public void setTopologyKeys(List<String> topologyKeys) {
    this.topologyKeys = topologyKeys;
  }


  public IoK8sApiCoreV1ServiceSpec type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. \&quot;ExternalName\&quot; maps to the specified externalName. \&quot;ClusterIP\&quot; allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object. If clusterIP is \&quot;None\&quot;, no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a stable IP. \&quot;NodePort\&quot; builds on ClusterIP and allocates a port on every node which routes to the clusterIP. \&quot;LoadBalancer\&quot; builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the clusterIP. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. \"ExternalName\" maps to the specified externalName. \"ClusterIP\" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object. If clusterIP is \"None\", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a stable IP. \"NodePort\" builds on ClusterIP and allocates a port on every node which routes to the clusterIP. \"LoadBalancer\" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the clusterIP. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types")
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IoK8sApiCoreV1ServiceSpec ioK8sApiCoreV1ServiceSpec = (IoK8sApiCoreV1ServiceSpec) o;
    return Objects.equals(this.clusterIP, ioK8sApiCoreV1ServiceSpec.clusterIP) &&
        Objects.equals(this.externalIPs, ioK8sApiCoreV1ServiceSpec.externalIPs) &&
        Objects.equals(this.externalName, ioK8sApiCoreV1ServiceSpec.externalName) &&
        Objects.equals(this.externalTrafficPolicy, ioK8sApiCoreV1ServiceSpec.externalTrafficPolicy) &&
        Objects.equals(this.healthCheckNodePort, ioK8sApiCoreV1ServiceSpec.healthCheckNodePort) &&
        Objects.equals(this.ipFamily, ioK8sApiCoreV1ServiceSpec.ipFamily) &&
        Objects.equals(this.loadBalancerIP, ioK8sApiCoreV1ServiceSpec.loadBalancerIP) &&
        Objects.equals(this.loadBalancerSourceRanges, ioK8sApiCoreV1ServiceSpec.loadBalancerSourceRanges) &&
        Objects.equals(this.ports, ioK8sApiCoreV1ServiceSpec.ports) &&
        Objects.equals(this.publishNotReadyAddresses, ioK8sApiCoreV1ServiceSpec.publishNotReadyAddresses) &&
        Objects.equals(this.selector, ioK8sApiCoreV1ServiceSpec.selector) &&
        Objects.equals(this.sessionAffinity, ioK8sApiCoreV1ServiceSpec.sessionAffinity) &&
        Objects.equals(this.sessionAffinityConfig, ioK8sApiCoreV1ServiceSpec.sessionAffinityConfig) &&
        Objects.equals(this.topologyKeys, ioK8sApiCoreV1ServiceSpec.topologyKeys) &&
        Objects.equals(this.type, ioK8sApiCoreV1ServiceSpec.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clusterIP, externalIPs, externalName, externalTrafficPolicy, healthCheckNodePort, ipFamily, loadBalancerIP, loadBalancerSourceRanges, ports, publishNotReadyAddresses, selector, sessionAffinity, sessionAffinityConfig, topologyKeys, type);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IoK8sApiCoreV1ServiceSpec {\n");
    sb.append("    clusterIP: ").append(toIndentedString(clusterIP)).append("\n");
    sb.append("    externalIPs: ").append(toIndentedString(externalIPs)).append("\n");
    sb.append("    externalName: ").append(toIndentedString(externalName)).append("\n");
    sb.append("    externalTrafficPolicy: ").append(toIndentedString(externalTrafficPolicy)).append("\n");
    sb.append("    healthCheckNodePort: ").append(toIndentedString(healthCheckNodePort)).append("\n");
    sb.append("    ipFamily: ").append(toIndentedString(ipFamily)).append("\n");
    sb.append("    loadBalancerIP: ").append(toIndentedString(loadBalancerIP)).append("\n");
    sb.append("    loadBalancerSourceRanges: ").append(toIndentedString(loadBalancerSourceRanges)).append("\n");
    sb.append("    ports: ").append(toIndentedString(ports)).append("\n");
    sb.append("    publishNotReadyAddresses: ").append(toIndentedString(publishNotReadyAddresses)).append("\n");
    sb.append("    selector: ").append(toIndentedString(selector)).append("\n");
    sb.append("    sessionAffinity: ").append(toIndentedString(sessionAffinity)).append("\n");
    sb.append("    sessionAffinityConfig: ").append(toIndentedString(sessionAffinityConfig)).append("\n");
    sb.append("    topologyKeys: ").append(toIndentedString(topologyKeys)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

