/*
 * Kubernetes
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: unversioned
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.stickycode.kuuty.model.v18;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1ObjectReference;
import net.stickycode.kuuty.model.v18.IoK8sApiDiscoveryV1beta1EndpointConditions;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Endpoint represents a single logical \&quot;backend\&quot; implementing a service.
 */
@ApiModel(description = "Endpoint represents a single logical \"backend\" implementing a service.")
@JsonPropertyOrder({
  IoK8sApiDiscoveryV1beta1Endpoint.JSON_PROPERTY_ADDRESSES,
  IoK8sApiDiscoveryV1beta1Endpoint.JSON_PROPERTY_CONDITIONS,
  IoK8sApiDiscoveryV1beta1Endpoint.JSON_PROPERTY_HOSTNAME,
  IoK8sApiDiscoveryV1beta1Endpoint.JSON_PROPERTY_TARGET_REF,
  IoK8sApiDiscoveryV1beta1Endpoint.JSON_PROPERTY_TOPOLOGY
})
@javax.annotation.processing.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-26T11:01:11.402583+13:00[Pacific/Auckland]")
public class IoK8sApiDiscoveryV1beta1Endpoint {
  public static final String JSON_PROPERTY_ADDRESSES = "addresses";
  private List<String> addresses = new ArrayList<>();

  public static final String JSON_PROPERTY_CONDITIONS = "conditions";
  private IoK8sApiDiscoveryV1beta1EndpointConditions conditions;

  public static final String JSON_PROPERTY_HOSTNAME = "hostname";
  private String hostname;

  public static final String JSON_PROPERTY_TARGET_REF = "targetRef";
  private IoK8sApiCoreV1ObjectReference targetRef;

  public static final String JSON_PROPERTY_TOPOLOGY = "topology";
  private Map<String, String> topology = null;


  public IoK8sApiDiscoveryV1beta1Endpoint addresses(List<String> addresses) {
    
    this.addresses = addresses;
    return this;
  }

  public IoK8sApiDiscoveryV1beta1Endpoint addAddressesItem(String addressesItem) {
    this.addresses.add(addressesItem);
    return this;
  }

   /**
   * addresses of this endpoint. The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100.
   * @return addresses
  **/
  @ApiModelProperty(required = true, value = "addresses of this endpoint. The contents of this field are interpreted according to the corresponding EndpointSlice addressType field. Consumers must handle different types of addresses in the context of their own capabilities. This must contain at least one address but no more than 100.")
  @JsonProperty(JSON_PROPERTY_ADDRESSES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getAddresses() {
    return addresses;
  }


  public void setAddresses(List<String> addresses) {
    this.addresses = addresses;
  }


  public IoK8sApiDiscoveryV1beta1Endpoint conditions(IoK8sApiDiscoveryV1beta1EndpointConditions conditions) {
    
    this.conditions = conditions;
    return this;
  }

   /**
   * Get conditions
   * @return conditions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_CONDITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IoK8sApiDiscoveryV1beta1EndpointConditions getConditions() {
    return conditions;
  }


  public void setConditions(IoK8sApiDiscoveryV1beta1EndpointConditions conditions) {
    this.conditions = conditions;
  }


  public IoK8sApiDiscoveryV1beta1Endpoint hostname(String hostname) {
    
    this.hostname = hostname;
    return this;
  }

   /**
   * hostname of this endpoint. This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must pass DNS Label (RFC 1123) validation.
   * @return hostname
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "hostname of this endpoint. This field may be used by consumers of endpoints to distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints which use the same hostname should be considered fungible (e.g. multiple A values in DNS). Must pass DNS Label (RFC 1123) validation.")
  @JsonProperty(JSON_PROPERTY_HOSTNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHostname() {
    return hostname;
  }


  public void setHostname(String hostname) {
    this.hostname = hostname;
  }


  public IoK8sApiDiscoveryV1beta1Endpoint targetRef(IoK8sApiCoreV1ObjectReference targetRef) {
    
    this.targetRef = targetRef;
    return this;
  }

   /**
   * Get targetRef
   * @return targetRef
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TARGET_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IoK8sApiCoreV1ObjectReference getTargetRef() {
    return targetRef;
  }


  public void setTargetRef(IoK8sApiCoreV1ObjectReference targetRef) {
    this.targetRef = targetRef;
  }


  public IoK8sApiDiscoveryV1beta1Endpoint topology(Map<String, String> topology) {
    
    this.topology = topology;
    return this;
  }

  public IoK8sApiDiscoveryV1beta1Endpoint putTopologyItem(String key, String topologyItem) {
    if (this.topology == null) {
      this.topology = new HashMap<>();
    }
    this.topology.put(key, topologyItem);
    return this;
  }

   /**
   * topology contains arbitrary topology information associated with the endpoint. These key/value pairs must conform with the label format. https://kubernetes.io/docs/concepts/overview/working-with-objects/labels Topology may include a maximum of 16 key/value pairs. This includes, but is not limited to the following well known keys: * kubernetes.io/hostname: the value indicates the hostname of the node   where the endpoint is located. This should match the corresponding   node label. * topology.kubernetes.io/zone: the value indicates the zone where the   endpoint is located. This should match the corresponding node label. * topology.kubernetes.io/region: the value indicates the region where the   endpoint is located. This should match the corresponding node label.
   * @return topology
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "topology contains arbitrary topology information associated with the endpoint. These key/value pairs must conform with the label format. https://kubernetes.io/docs/concepts/overview/working-with-objects/labels Topology may include a maximum of 16 key/value pairs. This includes, but is not limited to the following well known keys: * kubernetes.io/hostname: the value indicates the hostname of the node   where the endpoint is located. This should match the corresponding   node label. * topology.kubernetes.io/zone: the value indicates the zone where the   endpoint is located. This should match the corresponding node label. * topology.kubernetes.io/region: the value indicates the region where the   endpoint is located. This should match the corresponding node label.")
  @JsonProperty(JSON_PROPERTY_TOPOLOGY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getTopology() {
    return topology;
  }


  public void setTopology(Map<String, String> topology) {
    this.topology = topology;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IoK8sApiDiscoveryV1beta1Endpoint ioK8sApiDiscoveryV1beta1Endpoint = (IoK8sApiDiscoveryV1beta1Endpoint) o;
    return Objects.equals(this.addresses, ioK8sApiDiscoveryV1beta1Endpoint.addresses) &&
        Objects.equals(this.conditions, ioK8sApiDiscoveryV1beta1Endpoint.conditions) &&
        Objects.equals(this.hostname, ioK8sApiDiscoveryV1beta1Endpoint.hostname) &&
        Objects.equals(this.targetRef, ioK8sApiDiscoveryV1beta1Endpoint.targetRef) &&
        Objects.equals(this.topology, ioK8sApiDiscoveryV1beta1Endpoint.topology);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addresses, conditions, hostname, targetRef, topology);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IoK8sApiDiscoveryV1beta1Endpoint {\n");
    sb.append("    addresses: ").append(toIndentedString(addresses)).append("\n");
    sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    targetRef: ").append(toIndentedString(targetRef)).append("\n");
    sb.append("    topology: ").append(toIndentedString(topology)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

