/*
 * Kubernetes
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: unversioned
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.stickycode.kuuty.model.v18;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import net.stickycode.kuuty.model.v18.IoK8sApiFlowcontrolV1alpha1LimitResponse;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:  * How are requests for this priority level limited?  * What should be done with requests that exceed the limit?
 */
@ApiModel(description = "LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:  * How are requests for this priority level limited?  * What should be done with requests that exceed the limit?")
@JsonPropertyOrder({
  IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration.JSON_PROPERTY_ASSURED_CONCURRENCY_SHARES,
  IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration.JSON_PROPERTY_LIMIT_RESPONSE
})
@javax.annotation.processing.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-26T11:01:11.402583+13:00[Pacific/Auckland]")
public class IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration {
  public static final String JSON_PROPERTY_ASSURED_CONCURRENCY_SHARES = "assuredConcurrencyShares";
  private Integer assuredConcurrencyShares;

  public static final String JSON_PROPERTY_LIMIT_RESPONSE = "limitResponse";
  private IoK8sApiFlowcontrolV1alpha1LimitResponse limitResponse;


  public IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration assuredConcurrencyShares(Integer assuredConcurrencyShares) {
    
    this.assuredConcurrencyShares = assuredConcurrencyShares;
    return this;
  }

   /**
   * &#x60;assuredConcurrencyShares&#x60; (ACS) configures the execution limit, which is a limit on the number of requests of this priority level that may be exeucting at a given time.  ACS must be a positive number. The server&#39;s concurrency limit (SCL) is divided among the concurrency-controlled priority levels in proportion to their assured concurrency shares. This produces the assured concurrency value (ACV) --- the number of requests that may be executing at a time --- for each such priority level:              ACV(l) &#x3D; ceil( SCL * ACS(l) / ( sum[priority levels k] ACS(k) ) )  bigger numbers of ACS mean more reserved concurrent requests (at the expense of every other PL). This field has a default value of 30.
   * @return assuredConcurrencyShares
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "`assuredConcurrencyShares` (ACS) configures the execution limit, which is a limit on the number of requests of this priority level that may be exeucting at a given time.  ACS must be a positive number. The server's concurrency limit (SCL) is divided among the concurrency-controlled priority levels in proportion to their assured concurrency shares. This produces the assured concurrency value (ACV) --- the number of requests that may be executing at a time --- for each such priority level:              ACV(l) = ceil( SCL * ACS(l) / ( sum[priority levels k] ACS(k) ) )  bigger numbers of ACS mean more reserved concurrent requests (at the expense of every other PL). This field has a default value of 30.")
  @JsonProperty(JSON_PROPERTY_ASSURED_CONCURRENCY_SHARES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAssuredConcurrencyShares() {
    return assuredConcurrencyShares;
  }


  public void setAssuredConcurrencyShares(Integer assuredConcurrencyShares) {
    this.assuredConcurrencyShares = assuredConcurrencyShares;
  }


  public IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration limitResponse(IoK8sApiFlowcontrolV1alpha1LimitResponse limitResponse) {
    
    this.limitResponse = limitResponse;
    return this;
  }

   /**
   * Get limitResponse
   * @return limitResponse
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_LIMIT_RESPONSE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IoK8sApiFlowcontrolV1alpha1LimitResponse getLimitResponse() {
    return limitResponse;
  }


  public void setLimitResponse(IoK8sApiFlowcontrolV1alpha1LimitResponse limitResponse) {
    this.limitResponse = limitResponse;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration ioK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration = (IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration) o;
    return Objects.equals(this.assuredConcurrencyShares, ioK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration.assuredConcurrencyShares) &&
        Objects.equals(this.limitResponse, ioK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration.limitResponse);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assuredConcurrencyShares, limitResponse);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration {\n");
    sb.append("    assuredConcurrencyShares: ").append(toIndentedString(assuredConcurrencyShares)).append("\n");
    sb.append("    limitResponse: ").append(toIndentedString(limitResponse)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

