/*
 * Kubernetes
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: unversioned
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.stickycode.kuuty.model.v18;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system.
 */
@ApiModel(description = "PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system.")
@JsonPropertyOrder({
  IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus.JSON_PROPERTY_CURRENT_HEALTHY,
  IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus.JSON_PROPERTY_DESIRED_HEALTHY,
  IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus.JSON_PROPERTY_DISRUPTED_PODS,
  IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus.JSON_PROPERTY_DISRUPTIONS_ALLOWED,
  IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus.JSON_PROPERTY_EXPECTED_PODS,
  IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus.JSON_PROPERTY_OBSERVED_GENERATION
})
@javax.annotation.processing.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-26T11:01:11.402583+13:00[Pacific/Auckland]")
public class IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus {
  public static final String JSON_PROPERTY_CURRENT_HEALTHY = "currentHealthy";
  private Integer currentHealthy;

  public static final String JSON_PROPERTY_DESIRED_HEALTHY = "desiredHealthy";
  private Integer desiredHealthy;

  public static final String JSON_PROPERTY_DISRUPTED_PODS = "disruptedPods";
  private Map<String, OffsetDateTime> disruptedPods = null;

  public static final String JSON_PROPERTY_DISRUPTIONS_ALLOWED = "disruptionsAllowed";
  private Integer disruptionsAllowed;

  public static final String JSON_PROPERTY_EXPECTED_PODS = "expectedPods";
  private Integer expectedPods;

  public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
  private Long observedGeneration;


  public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus currentHealthy(Integer currentHealthy) {
    
    this.currentHealthy = currentHealthy;
    return this;
  }

   /**
   * current number of healthy pods
   * @return currentHealthy
  **/
  @ApiModelProperty(required = true, value = "current number of healthy pods")
  @JsonProperty(JSON_PROPERTY_CURRENT_HEALTHY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getCurrentHealthy() {
    return currentHealthy;
  }


  public void setCurrentHealthy(Integer currentHealthy) {
    this.currentHealthy = currentHealthy;
  }


  public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus desiredHealthy(Integer desiredHealthy) {
    
    this.desiredHealthy = desiredHealthy;
    return this;
  }

   /**
   * minimum desired number of healthy pods
   * @return desiredHealthy
  **/
  @ApiModelProperty(required = true, value = "minimum desired number of healthy pods")
  @JsonProperty(JSON_PROPERTY_DESIRED_HEALTHY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getDesiredHealthy() {
    return desiredHealthy;
  }


  public void setDesiredHealthy(Integer desiredHealthy) {
    this.desiredHealthy = desiredHealthy;
  }


  public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus disruptedPods(Map<String, OffsetDateTime> disruptedPods) {
    
    this.disruptedPods = disruptedPods;
    return this;
  }

  public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus putDisruptedPodsItem(String key, OffsetDateTime disruptedPodsItem) {
    if (this.disruptedPods == null) {
      this.disruptedPods = new HashMap<>();
    }
    this.disruptedPods.put(key, disruptedPodsItem);
    return this;
  }

   /**
   * DisruptedPods contains information about pods whose eviction was processed by the API server eviction subresource handler but has not yet been observed by the PodDisruptionBudget controller. A pod will be in this map from the time when the API server processed the eviction request to the time when the pod is seen by PDB controller as having been marked for deletion (or after a timeout). The key in the map is the name of the pod and the value is the time when the API server processed the eviction request. If the deletion didn&#39;t occur and a pod is still there it will be removed from the list automatically by PodDisruptionBudget controller after some time. If everything goes smooth this map should be empty for the most of the time. Large number of entries in the map may indicate problems with pod deletions.
   * @return disruptedPods
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "DisruptedPods contains information about pods whose eviction was processed by the API server eviction subresource handler but has not yet been observed by the PodDisruptionBudget controller. A pod will be in this map from the time when the API server processed the eviction request to the time when the pod is seen by PDB controller as having been marked for deletion (or after a timeout). The key in the map is the name of the pod and the value is the time when the API server processed the eviction request. If the deletion didn't occur and a pod is still there it will be removed from the list automatically by PodDisruptionBudget controller after some time. If everything goes smooth this map should be empty for the most of the time. Large number of entries in the map may indicate problems with pod deletions.")
  @JsonProperty(JSON_PROPERTY_DISRUPTED_PODS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, OffsetDateTime> getDisruptedPods() {
    return disruptedPods;
  }


  public void setDisruptedPods(Map<String, OffsetDateTime> disruptedPods) {
    this.disruptedPods = disruptedPods;
  }


  public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus disruptionsAllowed(Integer disruptionsAllowed) {
    
    this.disruptionsAllowed = disruptionsAllowed;
    return this;
  }

   /**
   * Number of pod disruptions that are currently allowed.
   * @return disruptionsAllowed
  **/
  @ApiModelProperty(required = true, value = "Number of pod disruptions that are currently allowed.")
  @JsonProperty(JSON_PROPERTY_DISRUPTIONS_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getDisruptionsAllowed() {
    return disruptionsAllowed;
  }


  public void setDisruptionsAllowed(Integer disruptionsAllowed) {
    this.disruptionsAllowed = disruptionsAllowed;
  }


  public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus expectedPods(Integer expectedPods) {
    
    this.expectedPods = expectedPods;
    return this;
  }

   /**
   * total number of pods counted by this disruption budget
   * @return expectedPods
  **/
  @ApiModelProperty(required = true, value = "total number of pods counted by this disruption budget")
  @JsonProperty(JSON_PROPERTY_EXPECTED_PODS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getExpectedPods() {
    return expectedPods;
  }


  public void setExpectedPods(Integer expectedPods) {
    this.expectedPods = expectedPods;
  }


  public IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus observedGeneration(Long observedGeneration) {
    
    this.observedGeneration = observedGeneration;
    return this;
  }

   /**
   * Most recent generation observed when updating this PDB status. DisruptionsAllowed and other status information is valid only if observedGeneration equals to PDB&#39;s object generation.
   * @return observedGeneration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Most recent generation observed when updating this PDB status. DisruptionsAllowed and other status information is valid only if observedGeneration equals to PDB's object generation.")
  @JsonProperty(JSON_PROPERTY_OBSERVED_GENERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getObservedGeneration() {
    return observedGeneration;
  }


  public void setObservedGeneration(Long observedGeneration) {
    this.observedGeneration = observedGeneration;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus = (IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus) o;
    return Objects.equals(this.currentHealthy, ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus.currentHealthy) &&
        Objects.equals(this.desiredHealthy, ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus.desiredHealthy) &&
        Objects.equals(this.disruptedPods, ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus.disruptedPods) &&
        Objects.equals(this.disruptionsAllowed, ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus.disruptionsAllowed) &&
        Objects.equals(this.expectedPods, ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus.expectedPods) &&
        Objects.equals(this.observedGeneration, ioK8sApiPolicyV1beta1PodDisruptionBudgetStatus.observedGeneration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currentHealthy, desiredHealthy, disruptedPods, disruptionsAllowed, expectedPods, observedGeneration);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IoK8sApiPolicyV1beta1PodDisruptionBudgetStatus {\n");
    sb.append("    currentHealthy: ").append(toIndentedString(currentHealthy)).append("\n");
    sb.append("    desiredHealthy: ").append(toIndentedString(desiredHealthy)).append("\n");
    sb.append("    disruptedPods: ").append(toIndentedString(disruptedPods)).append("\n");
    sb.append("    disruptionsAllowed: ").append(toIndentedString(disruptionsAllowed)).append("\n");
    sb.append("    expectedPods: ").append(toIndentedString(expectedPods)).append("\n");
    sb.append("    observedGeneration: ").append(toIndentedString(observedGeneration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

