/*
 * Kubernetes
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: unversioned
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package net.stickycode.kuuty.model.v18;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1TopologySelectorTerm;
import net.stickycode.kuuty.model.v18.IoK8sApimachineryPkgApisMetaV1ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.  StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.
 */
@ApiModel(description = "StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.  StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.")
@JsonPropertyOrder({
  IoK8sApiStorageV1StorageClass.JSON_PROPERTY_ALLOW_VOLUME_EXPANSION,
  IoK8sApiStorageV1StorageClass.JSON_PROPERTY_ALLOWED_TOPOLOGIES,
  IoK8sApiStorageV1StorageClass.JSON_PROPERTY_API_VERSION,
  IoK8sApiStorageV1StorageClass.JSON_PROPERTY_KIND,
  IoK8sApiStorageV1StorageClass.JSON_PROPERTY_METADATA,
  IoK8sApiStorageV1StorageClass.JSON_PROPERTY_MOUNT_OPTIONS,
  IoK8sApiStorageV1StorageClass.JSON_PROPERTY_PARAMETERS,
  IoK8sApiStorageV1StorageClass.JSON_PROPERTY_PROVISIONER,
  IoK8sApiStorageV1StorageClass.JSON_PROPERTY_RECLAIM_POLICY,
  IoK8sApiStorageV1StorageClass.JSON_PROPERTY_VOLUME_BINDING_MODE
})
@javax.annotation.processing.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-11-26T11:01:11.402583+13:00[Pacific/Auckland]")
public class IoK8sApiStorageV1StorageClass {
  public static final String JSON_PROPERTY_ALLOW_VOLUME_EXPANSION = "allowVolumeExpansion";
  private Boolean allowVolumeExpansion;

  public static final String JSON_PROPERTY_ALLOWED_TOPOLOGIES = "allowedTopologies";
  private List<IoK8sApiCoreV1TopologySelectorTerm> allowedTopologies = null;

  public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
  private String apiVersion;

  public static final String JSON_PROPERTY_KIND = "kind";
  private String kind;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata;

  public static final String JSON_PROPERTY_MOUNT_OPTIONS = "mountOptions";
  private List<String> mountOptions = null;

  public static final String JSON_PROPERTY_PARAMETERS = "parameters";
  private Map<String, String> parameters = null;

  public static final String JSON_PROPERTY_PROVISIONER = "provisioner";
  private String provisioner;

  public static final String JSON_PROPERTY_RECLAIM_POLICY = "reclaimPolicy";
  private String reclaimPolicy;

  public static final String JSON_PROPERTY_VOLUME_BINDING_MODE = "volumeBindingMode";
  private String volumeBindingMode;


  public IoK8sApiStorageV1StorageClass allowVolumeExpansion(Boolean allowVolumeExpansion) {
    
    this.allowVolumeExpansion = allowVolumeExpansion;
    return this;
  }

   /**
   * AllowVolumeExpansion shows whether the storage class allow volume expand
   * @return allowVolumeExpansion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "AllowVolumeExpansion shows whether the storage class allow volume expand")
  @JsonProperty(JSON_PROPERTY_ALLOW_VOLUME_EXPANSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAllowVolumeExpansion() {
    return allowVolumeExpansion;
  }


  public void setAllowVolumeExpansion(Boolean allowVolumeExpansion) {
    this.allowVolumeExpansion = allowVolumeExpansion;
  }


  public IoK8sApiStorageV1StorageClass allowedTopologies(List<IoK8sApiCoreV1TopologySelectorTerm> allowedTopologies) {
    
    this.allowedTopologies = allowedTopologies;
    return this;
  }

  public IoK8sApiStorageV1StorageClass addAllowedTopologiesItem(IoK8sApiCoreV1TopologySelectorTerm allowedTopologiesItem) {
    if (this.allowedTopologies == null) {
      this.allowedTopologies = new ArrayList<>();
    }
    this.allowedTopologies.add(allowedTopologiesItem);
    return this;
  }

   /**
   * Restrict the node topologies where volumes can be dynamically provisioned. Each volume plugin defines its own supported topology specifications. An empty TopologySelectorTerm list means there is no topology restriction. This field is only honored by servers that enable the VolumeScheduling feature.
   * @return allowedTopologies
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict the node topologies where volumes can be dynamically provisioned. Each volume plugin defines its own supported topology specifications. An empty TopologySelectorTerm list means there is no topology restriction. This field is only honored by servers that enable the VolumeScheduling feature.")
  @JsonProperty(JSON_PROPERTY_ALLOWED_TOPOLOGIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IoK8sApiCoreV1TopologySelectorTerm> getAllowedTopologies() {
    return allowedTopologies;
  }


  public void setAllowedTopologies(List<IoK8sApiCoreV1TopologySelectorTerm> allowedTopologies) {
    this.allowedTopologies = allowedTopologies;
  }


  public IoK8sApiStorageV1StorageClass apiVersion(String apiVersion) {
    
    this.apiVersion = apiVersion;
    return this;
  }

   /**
   * APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
   * @return apiVersion
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
  @JsonProperty(JSON_PROPERTY_API_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getApiVersion() {
    return apiVersion;
  }


  public void setApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
  }


  public IoK8sApiStorageV1StorageClass kind(String kind) {
    
    this.kind = kind;
    return this;
  }

   /**
   * Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * @return kind
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
  @JsonProperty(JSON_PROPERTY_KIND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getKind() {
    return kind;
  }


  public void setKind(String kind) {
    this.kind = kind;
  }


  public IoK8sApiStorageV1StorageClass metadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
    
    this.metadata = metadata;
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IoK8sApimachineryPkgApisMetaV1ObjectMeta getMetadata() {
    return metadata;
  }


  public void setMetadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
    this.metadata = metadata;
  }


  public IoK8sApiStorageV1StorageClass mountOptions(List<String> mountOptions) {
    
    this.mountOptions = mountOptions;
    return this;
  }

  public IoK8sApiStorageV1StorageClass addMountOptionsItem(String mountOptionsItem) {
    if (this.mountOptions == null) {
      this.mountOptions = new ArrayList<>();
    }
    this.mountOptions.add(mountOptionsItem);
    return this;
  }

   /**
   * Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. [\&quot;ro\&quot;, \&quot;soft\&quot;]. Not validated - mount of the PVs will simply fail if one is invalid.
   * @return mountOptions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. [\"ro\", \"soft\"]. Not validated - mount of the PVs will simply fail if one is invalid.")
  @JsonProperty(JSON_PROPERTY_MOUNT_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getMountOptions() {
    return mountOptions;
  }


  public void setMountOptions(List<String> mountOptions) {
    this.mountOptions = mountOptions;
  }


  public IoK8sApiStorageV1StorageClass parameters(Map<String, String> parameters) {
    
    this.parameters = parameters;
    return this;
  }

  public IoK8sApiStorageV1StorageClass putParametersItem(String key, String parametersItem) {
    if (this.parameters == null) {
      this.parameters = new HashMap<>();
    }
    this.parameters.put(key, parametersItem);
    return this;
  }

   /**
   * Parameters holds the parameters for the provisioner that should create volumes of this storage class.
   * @return parameters
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Parameters holds the parameters for the provisioner that should create volumes of this storage class.")
  @JsonProperty(JSON_PROPERTY_PARAMETERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getParameters() {
    return parameters;
  }


  public void setParameters(Map<String, String> parameters) {
    this.parameters = parameters;
  }


  public IoK8sApiStorageV1StorageClass provisioner(String provisioner) {
    
    this.provisioner = provisioner;
    return this;
  }

   /**
   * Provisioner indicates the type of the provisioner.
   * @return provisioner
  **/
  @ApiModelProperty(required = true, value = "Provisioner indicates the type of the provisioner.")
  @JsonProperty(JSON_PROPERTY_PROVISIONER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProvisioner() {
    return provisioner;
  }


  public void setProvisioner(String provisioner) {
    this.provisioner = provisioner;
  }


  public IoK8sApiStorageV1StorageClass reclaimPolicy(String reclaimPolicy) {
    
    this.reclaimPolicy = reclaimPolicy;
    return this;
  }

   /**
   * Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. Defaults to Delete.
   * @return reclaimPolicy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. Defaults to Delete.")
  @JsonProperty(JSON_PROPERTY_RECLAIM_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReclaimPolicy() {
    return reclaimPolicy;
  }


  public void setReclaimPolicy(String reclaimPolicy) {
    this.reclaimPolicy = reclaimPolicy;
  }


  public IoK8sApiStorageV1StorageClass volumeBindingMode(String volumeBindingMode) {
    
    this.volumeBindingMode = volumeBindingMode;
    return this;
  }

   /**
   * VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.  When unset, VolumeBindingImmediate is used. This field is only honored by servers that enable the VolumeScheduling feature.
   * @return volumeBindingMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "VolumeBindingMode indicates how PersistentVolumeClaims should be provisioned and bound.  When unset, VolumeBindingImmediate is used. This field is only honored by servers that enable the VolumeScheduling feature.")
  @JsonProperty(JSON_PROPERTY_VOLUME_BINDING_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVolumeBindingMode() {
    return volumeBindingMode;
  }


  public void setVolumeBindingMode(String volumeBindingMode) {
    this.volumeBindingMode = volumeBindingMode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IoK8sApiStorageV1StorageClass ioK8sApiStorageV1StorageClass = (IoK8sApiStorageV1StorageClass) o;
    return Objects.equals(this.allowVolumeExpansion, ioK8sApiStorageV1StorageClass.allowVolumeExpansion) &&
        Objects.equals(this.allowedTopologies, ioK8sApiStorageV1StorageClass.allowedTopologies) &&
        Objects.equals(this.apiVersion, ioK8sApiStorageV1StorageClass.apiVersion) &&
        Objects.equals(this.kind, ioK8sApiStorageV1StorageClass.kind) &&
        Objects.equals(this.metadata, ioK8sApiStorageV1StorageClass.metadata) &&
        Objects.equals(this.mountOptions, ioK8sApiStorageV1StorageClass.mountOptions) &&
        Objects.equals(this.parameters, ioK8sApiStorageV1StorageClass.parameters) &&
        Objects.equals(this.provisioner, ioK8sApiStorageV1StorageClass.provisioner) &&
        Objects.equals(this.reclaimPolicy, ioK8sApiStorageV1StorageClass.reclaimPolicy) &&
        Objects.equals(this.volumeBindingMode, ioK8sApiStorageV1StorageClass.volumeBindingMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowVolumeExpansion, allowedTopologies, apiVersion, kind, metadata, mountOptions, parameters, provisioner, reclaimPolicy, volumeBindingMode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IoK8sApiStorageV1StorageClass {\n");
    sb.append("    allowVolumeExpansion: ").append(toIndentedString(allowVolumeExpansion)).append("\n");
    sb.append("    allowedTopologies: ").append(toIndentedString(allowedTopologies)).append("\n");
    sb.append("    apiVersion: ").append(toIndentedString(apiVersion)).append("\n");
    sb.append("    kind: ").append(toIndentedString(kind)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    mountOptions: ").append(toIndentedString(mountOptions)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    provisioner: ").append(toIndentedString(provisioner)).append("\n");
    sb.append("    reclaimPolicy: ").append(toIndentedString(reclaimPolicy)).append("\n");
    sb.append("    volumeBindingMode: ").append(toIndentedString(volumeBindingMode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

