/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiAppsV1DaemonSetCondition;

@ApiModel(description="DaemonSetStatus represents the current status of a daemon set.")
@JsonPropertyOrder(value={"collisionCount", "conditions", "currentNumberScheduled", "desiredNumberScheduled", "numberAvailable", "numberMisscheduled", "numberReady", "numberUnavailable", "observedGeneration", "updatedNumberScheduled"})
public class IoK8sApiAppsV1DaemonSetStatus {
    public static final String JSON_PROPERTY_COLLISION_COUNT = "collisionCount";
    private Integer collisionCount;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<IoK8sApiAppsV1DaemonSetCondition> conditions = null;
    public static final String JSON_PROPERTY_CURRENT_NUMBER_SCHEDULED = "currentNumberScheduled";
    private Integer currentNumberScheduled;
    public static final String JSON_PROPERTY_DESIRED_NUMBER_SCHEDULED = "desiredNumberScheduled";
    private Integer desiredNumberScheduled;
    public static final String JSON_PROPERTY_NUMBER_AVAILABLE = "numberAvailable";
    private Integer numberAvailable;
    public static final String JSON_PROPERTY_NUMBER_MISSCHEDULED = "numberMisscheduled";
    private Integer numberMisscheduled;
    public static final String JSON_PROPERTY_NUMBER_READY = "numberReady";
    private Integer numberReady;
    public static final String JSON_PROPERTY_NUMBER_UNAVAILABLE = "numberUnavailable";
    private Integer numberUnavailable;
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    private Long observedGeneration;
    public static final String JSON_PROPERTY_UPDATED_NUMBER_SCHEDULED = "updatedNumberScheduled";
    private Integer updatedNumberScheduled;

    public IoK8sApiAppsV1DaemonSetStatus collisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.")
    @JsonProperty(value="collisionCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public IoK8sApiAppsV1DaemonSetStatus conditions(List<IoK8sApiAppsV1DaemonSetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public IoK8sApiAppsV1DaemonSetStatus addConditionsItem(IoK8sApiAppsV1DaemonSetCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IoK8sApiAppsV1DaemonSetCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a DaemonSet's current state.")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiAppsV1DaemonSetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<IoK8sApiAppsV1DaemonSetCondition> conditions) {
        this.conditions = conditions;
    }

    public IoK8sApiAppsV1DaemonSetStatus currentNumberScheduled(Integer currentNumberScheduled) {
        this.currentNumberScheduled = currentNumberScheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/")
    @JsonProperty(value="currentNumberScheduled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getCurrentNumberScheduled() {
        return this.currentNumberScheduled;
    }

    public void setCurrentNumberScheduled(Integer currentNumberScheduled) {
        this.currentNumberScheduled = currentNumberScheduled;
    }

    public IoK8sApiAppsV1DaemonSetStatus desiredNumberScheduled(Integer desiredNumberScheduled) {
        this.desiredNumberScheduled = desiredNumberScheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/")
    @JsonProperty(value="desiredNumberScheduled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getDesiredNumberScheduled() {
        return this.desiredNumberScheduled;
    }

    public void setDesiredNumberScheduled(Integer desiredNumberScheduled) {
        this.desiredNumberScheduled = desiredNumberScheduled;
    }

    public IoK8sApiAppsV1DaemonSetStatus numberAvailable(Integer numberAvailable) {
        this.numberAvailable = numberAvailable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)")
    @JsonProperty(value="numberAvailable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberAvailable() {
        return this.numberAvailable;
    }

    public void setNumberAvailable(Integer numberAvailable) {
        this.numberAvailable = numberAvailable;
    }

    public IoK8sApiAppsV1DaemonSetStatus numberMisscheduled(Integer numberMisscheduled) {
        this.numberMisscheduled = numberMisscheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/")
    @JsonProperty(value="numberMisscheduled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getNumberMisscheduled() {
        return this.numberMisscheduled;
    }

    public void setNumberMisscheduled(Integer numberMisscheduled) {
        this.numberMisscheduled = numberMisscheduled;
    }

    public IoK8sApiAppsV1DaemonSetStatus numberReady(Integer numberReady) {
        this.numberReady = numberReady;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready.")
    @JsonProperty(value="numberReady")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getNumberReady() {
        return this.numberReady;
    }

    public void setNumberReady(Integer numberReady) {
        this.numberReady = numberReady;
    }

    public IoK8sApiAppsV1DaemonSetStatus numberUnavailable(Integer numberUnavailable) {
        this.numberUnavailable = numberUnavailable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)")
    @JsonProperty(value="numberUnavailable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberUnavailable() {
        return this.numberUnavailable;
    }

    public void setNumberUnavailable(Integer numberUnavailable) {
        this.numberUnavailable = numberUnavailable;
    }

    public IoK8sApiAppsV1DaemonSetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The most recent generation observed by the daemon set controller.")
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public IoK8sApiAppsV1DaemonSetStatus updatedNumberScheduled(Integer updatedNumberScheduled) {
        this.updatedNumberScheduled = updatedNumberScheduled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of nodes that are running updated daemon pod")
    @JsonProperty(value="updatedNumberScheduled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getUpdatedNumberScheduled() {
        return this.updatedNumberScheduled;
    }

    public void setUpdatedNumberScheduled(Integer updatedNumberScheduled) {
        this.updatedNumberScheduled = updatedNumberScheduled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAppsV1DaemonSetStatus ioK8sApiAppsV1DaemonSetStatus = (IoK8sApiAppsV1DaemonSetStatus)o;
        return Objects.equals(this.collisionCount, ioK8sApiAppsV1DaemonSetStatus.collisionCount) && Objects.equals(this.conditions, ioK8sApiAppsV1DaemonSetStatus.conditions) && Objects.equals(this.currentNumberScheduled, ioK8sApiAppsV1DaemonSetStatus.currentNumberScheduled) && Objects.equals(this.desiredNumberScheduled, ioK8sApiAppsV1DaemonSetStatus.desiredNumberScheduled) && Objects.equals(this.numberAvailable, ioK8sApiAppsV1DaemonSetStatus.numberAvailable) && Objects.equals(this.numberMisscheduled, ioK8sApiAppsV1DaemonSetStatus.numberMisscheduled) && Objects.equals(this.numberReady, ioK8sApiAppsV1DaemonSetStatus.numberReady) && Objects.equals(this.numberUnavailable, ioK8sApiAppsV1DaemonSetStatus.numberUnavailable) && Objects.equals(this.observedGeneration, ioK8sApiAppsV1DaemonSetStatus.observedGeneration) && Objects.equals(this.updatedNumberScheduled, ioK8sApiAppsV1DaemonSetStatus.updatedNumberScheduled);
    }

    public int hashCode() {
        return Objects.hash(this.collisionCount, this.conditions, this.currentNumberScheduled, this.desiredNumberScheduled, this.numberAvailable, this.numberMisscheduled, this.numberReady, this.numberUnavailable, this.observedGeneration, this.updatedNumberScheduled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAppsV1DaemonSetStatus {\n");
        sb.append("    collisionCount: ").append(this.toIndentedString(this.collisionCount)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentNumberScheduled: ").append(this.toIndentedString(this.currentNumberScheduled)).append("\n");
        sb.append("    desiredNumberScheduled: ").append(this.toIndentedString(this.desiredNumberScheduled)).append("\n");
        sb.append("    numberAvailable: ").append(this.toIndentedString(this.numberAvailable)).append("\n");
        sb.append("    numberMisscheduled: ").append(this.toIndentedString(this.numberMisscheduled)).append("\n");
        sb.append("    numberReady: ").append(this.toIndentedString(this.numberReady)).append("\n");
        sb.append("    numberUnavailable: ").append(this.toIndentedString(this.numberUnavailable)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    updatedNumberScheduled: ").append(this.toIndentedString(this.updatedNumberScheduled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

