/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiAppsV1DeploymentCondition;

@ApiModel(description="DeploymentStatus is the most recently observed status of the Deployment.")
@JsonPropertyOrder(value={"availableReplicas", "collisionCount", "conditions", "observedGeneration", "readyReplicas", "replicas", "unavailableReplicas", "updatedReplicas"})
public class IoK8sApiAppsV1DeploymentStatus {
    public static final String JSON_PROPERTY_AVAILABLE_REPLICAS = "availableReplicas";
    private Integer availableReplicas;
    public static final String JSON_PROPERTY_COLLISION_COUNT = "collisionCount";
    private Integer collisionCount;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<IoK8sApiAppsV1DeploymentCondition> conditions = null;
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    private Long observedGeneration;
    public static final String JSON_PROPERTY_READY_REPLICAS = "readyReplicas";
    private Integer readyReplicas;
    public static final String JSON_PROPERTY_REPLICAS = "replicas";
    private Integer replicas;
    public static final String JSON_PROPERTY_UNAVAILABLE_REPLICAS = "unavailableReplicas";
    private Integer unavailableReplicas;
    public static final String JSON_PROPERTY_UPDATED_REPLICAS = "updatedReplicas";
    private Integer updatedReplicas;

    public IoK8sApiAppsV1DeploymentStatus availableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.")
    @JsonProperty(value="availableReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public IoK8sApiAppsV1DeploymentStatus collisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.")
    @JsonProperty(value="collisionCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public IoK8sApiAppsV1DeploymentStatus conditions(List<IoK8sApiAppsV1DeploymentCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public IoK8sApiAppsV1DeploymentStatus addConditionsItem(IoK8sApiAppsV1DeploymentCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IoK8sApiAppsV1DeploymentCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a deployment's current state.")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiAppsV1DeploymentCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<IoK8sApiAppsV1DeploymentCondition> conditions) {
        this.conditions = conditions;
    }

    public IoK8sApiAppsV1DeploymentStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The generation observed by the deployment controller.")
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public IoK8sApiAppsV1DeploymentStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of ready pods targeted by this deployment.")
    @JsonProperty(value="readyReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public IoK8sApiAppsV1DeploymentStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of non-terminated pods targeted by this deployment (their labels match the selector).")
    @JsonProperty(value="replicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public IoK8sApiAppsV1DeploymentStatus unavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.")
    @JsonProperty(value="unavailableReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getUnavailableReplicas() {
        return this.unavailableReplicas;
    }

    public void setUnavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
    }

    public IoK8sApiAppsV1DeploymentStatus updatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total number of non-terminated pods targeted by this deployment that have the desired template spec.")
    @JsonProperty(value="updatedReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public void setUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAppsV1DeploymentStatus ioK8sApiAppsV1DeploymentStatus = (IoK8sApiAppsV1DeploymentStatus)o;
        return Objects.equals(this.availableReplicas, ioK8sApiAppsV1DeploymentStatus.availableReplicas) && Objects.equals(this.collisionCount, ioK8sApiAppsV1DeploymentStatus.collisionCount) && Objects.equals(this.conditions, ioK8sApiAppsV1DeploymentStatus.conditions) && Objects.equals(this.observedGeneration, ioK8sApiAppsV1DeploymentStatus.observedGeneration) && Objects.equals(this.readyReplicas, ioK8sApiAppsV1DeploymentStatus.readyReplicas) && Objects.equals(this.replicas, ioK8sApiAppsV1DeploymentStatus.replicas) && Objects.equals(this.unavailableReplicas, ioK8sApiAppsV1DeploymentStatus.unavailableReplicas) && Objects.equals(this.updatedReplicas, ioK8sApiAppsV1DeploymentStatus.updatedReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.collisionCount, this.conditions, this.observedGeneration, this.readyReplicas, this.replicas, this.unavailableReplicas, this.updatedReplicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAppsV1DeploymentStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    collisionCount: ").append(this.toIndentedString(this.collisionCount)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    unavailableReplicas: ").append(this.toIndentedString(this.unavailableReplicas)).append("\n");
        sb.append("    updatedReplicas: ").append(this.toIndentedString(this.updatedReplicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

