/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiAppsV1ReplicaSetCondition;

@ApiModel(description="ReplicaSetStatus represents the current status of a ReplicaSet.")
@JsonPropertyOrder(value={"availableReplicas", "conditions", "fullyLabeledReplicas", "observedGeneration", "readyReplicas", "replicas"})
public class IoK8sApiAppsV1ReplicaSetStatus {
    public static final String JSON_PROPERTY_AVAILABLE_REPLICAS = "availableReplicas";
    private Integer availableReplicas;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<IoK8sApiAppsV1ReplicaSetCondition> conditions = null;
    public static final String JSON_PROPERTY_FULLY_LABELED_REPLICAS = "fullyLabeledReplicas";
    private Integer fullyLabeledReplicas;
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    private Long observedGeneration;
    public static final String JSON_PROPERTY_READY_REPLICAS = "readyReplicas";
    private Integer readyReplicas;
    public static final String JSON_PROPERTY_REPLICAS = "replicas";
    private Integer replicas;

    public IoK8sApiAppsV1ReplicaSetStatus availableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of available replicas (ready for at least minReadySeconds) for this replica set.")
    @JsonProperty(value="availableReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public IoK8sApiAppsV1ReplicaSetStatus conditions(List<IoK8sApiAppsV1ReplicaSetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public IoK8sApiAppsV1ReplicaSetStatus addConditionsItem(IoK8sApiAppsV1ReplicaSetCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IoK8sApiAppsV1ReplicaSetCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a replica set's current state.")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiAppsV1ReplicaSetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<IoK8sApiAppsV1ReplicaSetCondition> conditions) {
        this.conditions = conditions;
    }

    public IoK8sApiAppsV1ReplicaSetStatus fullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pods that have labels matching the labels of the pod template of the replicaset.")
    @JsonProperty(value="fullyLabeledReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFullyLabeledReplicas() {
        return this.fullyLabeledReplicas;
    }

    public void setFullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
    }

    public IoK8sApiAppsV1ReplicaSetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ObservedGeneration reflects the generation of the most recently observed ReplicaSet.")
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public IoK8sApiAppsV1ReplicaSetStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of ready replicas for this replica set.")
    @JsonProperty(value="readyReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public IoK8sApiAppsV1ReplicaSetStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(required=true, value="Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller")
    @JsonProperty(value="replicas")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAppsV1ReplicaSetStatus ioK8sApiAppsV1ReplicaSetStatus = (IoK8sApiAppsV1ReplicaSetStatus)o;
        return Objects.equals(this.availableReplicas, ioK8sApiAppsV1ReplicaSetStatus.availableReplicas) && Objects.equals(this.conditions, ioK8sApiAppsV1ReplicaSetStatus.conditions) && Objects.equals(this.fullyLabeledReplicas, ioK8sApiAppsV1ReplicaSetStatus.fullyLabeledReplicas) && Objects.equals(this.observedGeneration, ioK8sApiAppsV1ReplicaSetStatus.observedGeneration) && Objects.equals(this.readyReplicas, ioK8sApiAppsV1ReplicaSetStatus.readyReplicas) && Objects.equals(this.replicas, ioK8sApiAppsV1ReplicaSetStatus.replicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.conditions, this.fullyLabeledReplicas, this.observedGeneration, this.readyReplicas, this.replicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAppsV1ReplicaSetStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    fullyLabeledReplicas: ").append(this.toIndentedString(this.fullyLabeledReplicas)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

