/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="StatefulSetCondition describes the state of a statefulset at a certain point.")
@JsonPropertyOrder(value={"lastTransitionTime", "message", "reason", "status", "type"})
public class IoK8sApiAppsV1StatefulSetCondition {
    public static final String JSON_PROPERTY_LAST_TRANSITION_TIME = "lastTransitionTime";
    private OffsetDateTime lastTransitionTime;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public IoK8sApiAppsV1StatefulSetCondition lastTransitionTime(OffsetDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.")
    @JsonProperty(value="lastTransitionTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public void setLastTransitionTime(OffsetDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public IoK8sApiAppsV1StatefulSetCondition message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human readable message indicating details about the transition.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public IoK8sApiAppsV1StatefulSetCondition reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason for the condition's last transition.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public IoK8sApiAppsV1StatefulSetCondition status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status of the condition, one of True, False, Unknown.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public IoK8sApiAppsV1StatefulSetCondition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of statefulset condition.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAppsV1StatefulSetCondition ioK8sApiAppsV1StatefulSetCondition = (IoK8sApiAppsV1StatefulSetCondition)o;
        return Objects.equals(this.lastTransitionTime, ioK8sApiAppsV1StatefulSetCondition.lastTransitionTime) && Objects.equals(this.message, ioK8sApiAppsV1StatefulSetCondition.message) && Objects.equals(this.reason, ioK8sApiAppsV1StatefulSetCondition.reason) && Objects.equals(this.status, ioK8sApiAppsV1StatefulSetCondition.status) && Objects.equals(this.type, ioK8sApiAppsV1StatefulSetCondition.type);
    }

    public int hashCode() {
        return Objects.hash(this.lastTransitionTime, this.message, this.reason, this.status, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAppsV1StatefulSetCondition {\n");
        sb.append("    lastTransitionTime: ").append(this.toIndentedString(this.lastTransitionTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

