/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiAppsV1StatefulSetCondition;

@ApiModel(description="StatefulSetStatus represents the current state of a StatefulSet.")
@JsonPropertyOrder(value={"collisionCount", "conditions", "currentReplicas", "currentRevision", "observedGeneration", "readyReplicas", "replicas", "updateRevision", "updatedReplicas"})
public class IoK8sApiAppsV1StatefulSetStatus {
    public static final String JSON_PROPERTY_COLLISION_COUNT = "collisionCount";
    private Integer collisionCount;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<IoK8sApiAppsV1StatefulSetCondition> conditions = null;
    public static final String JSON_PROPERTY_CURRENT_REPLICAS = "currentReplicas";
    private Integer currentReplicas;
    public static final String JSON_PROPERTY_CURRENT_REVISION = "currentRevision";
    private String currentRevision;
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    private Long observedGeneration;
    public static final String JSON_PROPERTY_READY_REPLICAS = "readyReplicas";
    private Integer readyReplicas;
    public static final String JSON_PROPERTY_REPLICAS = "replicas";
    private Integer replicas;
    public static final String JSON_PROPERTY_UPDATE_REVISION = "updateRevision";
    private String updateRevision;
    public static final String JSON_PROPERTY_UPDATED_REPLICAS = "updatedReplicas";
    private Integer updatedReplicas;

    public IoK8sApiAppsV1StatefulSetStatus collisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.")
    @JsonProperty(value="collisionCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public IoK8sApiAppsV1StatefulSetStatus conditions(List<IoK8sApiAppsV1StatefulSetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public IoK8sApiAppsV1StatefulSetStatus addConditionsItem(IoK8sApiAppsV1StatefulSetCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IoK8sApiAppsV1StatefulSetCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a statefulset's current state.")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiAppsV1StatefulSetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<IoK8sApiAppsV1StatefulSetCondition> conditions) {
        this.conditions = conditions;
    }

    public IoK8sApiAppsV1StatefulSetStatus currentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.")
    @JsonProperty(value="currentReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public IoK8sApiAppsV1StatefulSetStatus currentRevision(String currentRevision) {
        this.currentRevision = currentRevision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).")
    @JsonProperty(value="currentRevision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrentRevision() {
        return this.currentRevision;
    }

    public void setCurrentRevision(String currentRevision) {
        this.currentRevision = currentRevision;
    }

    public IoK8sApiAppsV1StatefulSetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.")
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public IoK8sApiAppsV1StatefulSetStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readyReplicas is the number of Pods created by the StatefulSet controller that have a Ready Condition.")
    @JsonProperty(value="readyReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public IoK8sApiAppsV1StatefulSetStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(required=true, value="replicas is the number of Pods created by the StatefulSet controller.")
    @JsonProperty(value="replicas")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public IoK8sApiAppsV1StatefulSetStatus updateRevision(String updateRevision) {
        this.updateRevision = updateRevision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)")
    @JsonProperty(value="updateRevision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdateRevision() {
        return this.updateRevision;
    }

    public void setUpdateRevision(String updateRevision) {
        this.updateRevision = updateRevision;
    }

    public IoK8sApiAppsV1StatefulSetStatus updatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.")
    @JsonProperty(value="updatedReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public void setUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAppsV1StatefulSetStatus ioK8sApiAppsV1StatefulSetStatus = (IoK8sApiAppsV1StatefulSetStatus)o;
        return Objects.equals(this.collisionCount, ioK8sApiAppsV1StatefulSetStatus.collisionCount) && Objects.equals(this.conditions, ioK8sApiAppsV1StatefulSetStatus.conditions) && Objects.equals(this.currentReplicas, ioK8sApiAppsV1StatefulSetStatus.currentReplicas) && Objects.equals(this.currentRevision, ioK8sApiAppsV1StatefulSetStatus.currentRevision) && Objects.equals(this.observedGeneration, ioK8sApiAppsV1StatefulSetStatus.observedGeneration) && Objects.equals(this.readyReplicas, ioK8sApiAppsV1StatefulSetStatus.readyReplicas) && Objects.equals(this.replicas, ioK8sApiAppsV1StatefulSetStatus.replicas) && Objects.equals(this.updateRevision, ioK8sApiAppsV1StatefulSetStatus.updateRevision) && Objects.equals(this.updatedReplicas, ioK8sApiAppsV1StatefulSetStatus.updatedReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.collisionCount, this.conditions, this.currentReplicas, this.currentRevision, this.observedGeneration, this.readyReplicas, this.replicas, this.updateRevision, this.updatedReplicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAppsV1StatefulSetStatus {\n");
        sb.append("    collisionCount: ").append(this.toIndentedString(this.collisionCount)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentReplicas: ").append(this.toIndentedString(this.currentReplicas)).append("\n");
        sb.append("    currentRevision: ").append(this.toIndentedString(this.currentRevision)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    updateRevision: ").append(this.toIndentedString(this.updateRevision)).append("\n");
        sb.append("    updatedReplicas: ").append(this.toIndentedString(this.updatedReplicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

