/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiAuthenticationV1BoundObjectReference;

@ApiModel(description="TokenRequestSpec contains client provided parameters of a token request.")
@JsonPropertyOrder(value={"audiences", "boundObjectRef", "expirationSeconds"})
public class IoK8sApiAuthenticationV1TokenRequestSpec {
    public static final String JSON_PROPERTY_AUDIENCES = "audiences";
    private List<String> audiences = new ArrayList<String>();
    public static final String JSON_PROPERTY_BOUND_OBJECT_REF = "boundObjectRef";
    private IoK8sApiAuthenticationV1BoundObjectReference boundObjectRef;
    public static final String JSON_PROPERTY_EXPIRATION_SECONDS = "expirationSeconds";
    private Long expirationSeconds;

    public IoK8sApiAuthenticationV1TokenRequestSpec audiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public IoK8sApiAuthenticationV1TokenRequestSpec addAudiencesItem(String audiencesItem) {
        this.audiences.add(audiencesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Audiences are the intendend audiences of the token. A recipient of a token must identitfy themself with an identifier in the list of audiences of the token, and otherwise should reject the token. A token issued for multiple audiences may be used to authenticate against any of the audiences listed but implies a high degree of trust between the target audiences.")
    @JsonProperty(value="audiences")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public IoK8sApiAuthenticationV1TokenRequestSpec boundObjectRef(IoK8sApiAuthenticationV1BoundObjectReference boundObjectRef) {
        this.boundObjectRef = boundObjectRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="boundObjectRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiAuthenticationV1BoundObjectReference getBoundObjectRef() {
        return this.boundObjectRef;
    }

    public void setBoundObjectRef(IoK8sApiAuthenticationV1BoundObjectReference boundObjectRef) {
        this.boundObjectRef = boundObjectRef;
    }

    public IoK8sApiAuthenticationV1TokenRequestSpec expirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ExpirationSeconds is the requested duration of validity of the request. The token issuer may return a token with a different validity duration so a client needs to check the 'expiration' field in a response.")
    @JsonProperty(value="expirationSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public void setExpirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAuthenticationV1TokenRequestSpec ioK8sApiAuthenticationV1TokenRequestSpec = (IoK8sApiAuthenticationV1TokenRequestSpec)o;
        return Objects.equals(this.audiences, ioK8sApiAuthenticationV1TokenRequestSpec.audiences) && Objects.equals(this.boundObjectRef, ioK8sApiAuthenticationV1TokenRequestSpec.boundObjectRef) && Objects.equals(this.expirationSeconds, ioK8sApiAuthenticationV1TokenRequestSpec.expirationSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.boundObjectRef, this.expirationSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAuthenticationV1TokenRequestSpec {\n");
        sb.append("    audiences: ").append(this.toIndentedString(this.audiences)).append("\n");
        sb.append("    boundObjectRef: ").append(this.toIndentedString(this.boundObjectRef)).append("\n");
        sb.append("    expirationSeconds: ").append(this.toIndentedString(this.expirationSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

