/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiAuthenticationV1UserInfo;

@ApiModel(description="TokenReviewStatus is the result of the token authentication request.")
@JsonPropertyOrder(value={"audiences", "authenticated", "error", "user"})
public class IoK8sApiAuthenticationV1TokenReviewStatus {
    public static final String JSON_PROPERTY_AUDIENCES = "audiences";
    private List<String> audiences = null;
    public static final String JSON_PROPERTY_AUTHENTICATED = "authenticated";
    private Boolean authenticated;
    public static final String JSON_PROPERTY_ERROR = "error";
    private String error;
    public static final String JSON_PROPERTY_USER = "user";
    private IoK8sApiAuthenticationV1UserInfo user;

    public IoK8sApiAuthenticationV1TokenReviewStatus audiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public IoK8sApiAuthenticationV1TokenReviewStatus addAudiencesItem(String audiencesItem) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(audiencesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Audiences are audience identifiers chosen by the authenticator that are compatible with both the TokenReview and token. An identifier is any identifier in the intersection of the TokenReviewSpec audiences and the token's audiences. A client of the TokenReview API that sets the spec.audiences field should validate that a compatible audience identifier is returned in the status.audiences field to ensure that the TokenReview server is audience aware. If a TokenReview returns an empty status.audience field where status.authenticated is \"true\", the token is valid against the audience of the Kubernetes API server.")
    @JsonProperty(value="audiences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public IoK8sApiAuthenticationV1TokenReviewStatus authenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Authenticated indicates that the token was associated with a known user.")
    @JsonProperty(value="authenticated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
    }

    public IoK8sApiAuthenticationV1TokenReviewStatus error(String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Error indicates that the token couldn't be checked")
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public IoK8sApiAuthenticationV1TokenReviewStatus user(IoK8sApiAuthenticationV1UserInfo user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiAuthenticationV1UserInfo getUser() {
        return this.user;
    }

    public void setUser(IoK8sApiAuthenticationV1UserInfo user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAuthenticationV1TokenReviewStatus ioK8sApiAuthenticationV1TokenReviewStatus = (IoK8sApiAuthenticationV1TokenReviewStatus)o;
        return Objects.equals(this.audiences, ioK8sApiAuthenticationV1TokenReviewStatus.audiences) && Objects.equals(this.authenticated, ioK8sApiAuthenticationV1TokenReviewStatus.authenticated) && Objects.equals(this.error, ioK8sApiAuthenticationV1TokenReviewStatus.error) && Objects.equals(this.user, ioK8sApiAuthenticationV1TokenReviewStatus.user);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.authenticated, this.error, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAuthenticationV1TokenReviewStatus {\n");
        sb.append("    audiences: ").append(this.toIndentedString(this.audiences)).append("\n");
        sb.append("    authenticated: ").append(this.toIndentedString(this.authenticated)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

