/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiAuthorizationV1NonResourceRule;
import net.stickycode.kuuty.model.v18.IoK8sApiAuthorizationV1ResourceRule;

@ApiModel(description="SubjectRulesReviewStatus contains the result of a rules check. This check can be incomplete depending on the set of authorizers the server is configured with and any errors experienced during evaluation. Because authorization rules are additive, if a rule appears in a list it's safe to assume the subject has that permission, even if that list is incomplete.")
@JsonPropertyOrder(value={"evaluationError", "incomplete", "nonResourceRules", "resourceRules"})
public class IoK8sApiAuthorizationV1SubjectRulesReviewStatus {
    public static final String JSON_PROPERTY_EVALUATION_ERROR = "evaluationError";
    private String evaluationError;
    public static final String JSON_PROPERTY_INCOMPLETE = "incomplete";
    private Boolean incomplete;
    public static final String JSON_PROPERTY_NON_RESOURCE_RULES = "nonResourceRules";
    private List<IoK8sApiAuthorizationV1NonResourceRule> nonResourceRules = new ArrayList<IoK8sApiAuthorizationV1NonResourceRule>();
    public static final String JSON_PROPERTY_RESOURCE_RULES = "resourceRules";
    private List<IoK8sApiAuthorizationV1ResourceRule> resourceRules = new ArrayList<IoK8sApiAuthorizationV1ResourceRule>();

    public IoK8sApiAuthorizationV1SubjectRulesReviewStatus evaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EvaluationError can appear in combination with Rules. It indicates an error occurred during rule evaluation, such as an authorizer that doesn't support rule evaluation, and that ResourceRules and/or NonResourceRules may be incomplete.")
    @JsonProperty(value="evaluationError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEvaluationError() {
        return this.evaluationError;
    }

    public void setEvaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
    }

    public IoK8sApiAuthorizationV1SubjectRulesReviewStatus incomplete(Boolean incomplete) {
        this.incomplete = incomplete;
        return this;
    }

    @ApiModelProperty(required=true, value="Incomplete is true when the rules returned by this call are incomplete. This is most commonly encountered when an authorizer, such as an external authorizer, doesn't support rules evaluation.")
    @JsonProperty(value="incomplete")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(Boolean incomplete) {
        this.incomplete = incomplete;
    }

    public IoK8sApiAuthorizationV1SubjectRulesReviewStatus nonResourceRules(List<IoK8sApiAuthorizationV1NonResourceRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
        return this;
    }

    public IoK8sApiAuthorizationV1SubjectRulesReviewStatus addNonResourceRulesItem(IoK8sApiAuthorizationV1NonResourceRule nonResourceRulesItem) {
        this.nonResourceRules.add(nonResourceRulesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="NonResourceRules is the list of actions the subject is allowed to perform on non-resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.")
    @JsonProperty(value="nonResourceRules")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<IoK8sApiAuthorizationV1NonResourceRule> getNonResourceRules() {
        return this.nonResourceRules;
    }

    public void setNonResourceRules(List<IoK8sApiAuthorizationV1NonResourceRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
    }

    public IoK8sApiAuthorizationV1SubjectRulesReviewStatus resourceRules(List<IoK8sApiAuthorizationV1ResourceRule> resourceRules) {
        this.resourceRules = resourceRules;
        return this;
    }

    public IoK8sApiAuthorizationV1SubjectRulesReviewStatus addResourceRulesItem(IoK8sApiAuthorizationV1ResourceRule resourceRulesItem) {
        this.resourceRules.add(resourceRulesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="ResourceRules is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.")
    @JsonProperty(value="resourceRules")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<IoK8sApiAuthorizationV1ResourceRule> getResourceRules() {
        return this.resourceRules;
    }

    public void setResourceRules(List<IoK8sApiAuthorizationV1ResourceRule> resourceRules) {
        this.resourceRules = resourceRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAuthorizationV1SubjectRulesReviewStatus ioK8sApiAuthorizationV1SubjectRulesReviewStatus = (IoK8sApiAuthorizationV1SubjectRulesReviewStatus)o;
        return Objects.equals(this.evaluationError, ioK8sApiAuthorizationV1SubjectRulesReviewStatus.evaluationError) && Objects.equals(this.incomplete, ioK8sApiAuthorizationV1SubjectRulesReviewStatus.incomplete) && Objects.equals(this.nonResourceRules, ioK8sApiAuthorizationV1SubjectRulesReviewStatus.nonResourceRules) && Objects.equals(this.resourceRules, ioK8sApiAuthorizationV1SubjectRulesReviewStatus.resourceRules);
    }

    public int hashCode() {
        return Objects.hash(this.evaluationError, this.incomplete, this.nonResourceRules, this.resourceRules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAuthorizationV1SubjectRulesReviewStatus {\n");
        sb.append("    evaluationError: ").append(this.toIndentedString(this.evaluationError)).append("\n");
        sb.append("    incomplete: ").append(this.toIndentedString(this.incomplete)).append("\n");
        sb.append("    nonResourceRules: ").append(this.toIndentedString(this.nonResourceRules)).append("\n");
        sb.append("    resourceRules: ").append(this.toIndentedString(this.resourceRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

