/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SubjectAccessReviewStatus")
@JsonPropertyOrder(value={"allowed", "denied", "evaluationError", "reason"})
public class IoK8sApiAuthorizationV1beta1SubjectAccessReviewStatus {
    public static final String JSON_PROPERTY_ALLOWED = "allowed";
    private Boolean allowed;
    public static final String JSON_PROPERTY_DENIED = "denied";
    private Boolean denied;
    public static final String JSON_PROPERTY_EVALUATION_ERROR = "evaluationError";
    private String evaluationError;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;

    public IoK8sApiAuthorizationV1beta1SubjectAccessReviewStatus allowed(Boolean allowed) {
        this.allowed = allowed;
        return this;
    }

    @ApiModelProperty(required=true, value="Allowed is required. True if the action would be allowed, false otherwise.")
    @JsonProperty(value="allowed")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getAllowed() {
        return this.allowed;
    }

    public void setAllowed(Boolean allowed) {
        this.allowed = allowed;
    }

    public IoK8sApiAuthorizationV1beta1SubjectAccessReviewStatus denied(Boolean denied) {
        this.denied = denied;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Denied is optional. True if the action would be denied, otherwise false. If both allowed is false and denied is false, then the authorizer has no opinion on whether to authorize the action. Denied may not be true if Allowed is true.")
    @JsonProperty(value="denied")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDenied() {
        return this.denied;
    }

    public void setDenied(Boolean denied) {
        this.denied = denied;
    }

    public IoK8sApiAuthorizationV1beta1SubjectAccessReviewStatus evaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EvaluationError is an indication that some error occurred during the authorization check. It is entirely possible to get an error and be able to continue determine authorization status in spite of it. For instance, RBAC can be missing a role, but enough roles are still present and bound to reason about the request.")
    @JsonProperty(value="evaluationError")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEvaluationError() {
        return this.evaluationError;
    }

    public void setEvaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
    }

    public IoK8sApiAuthorizationV1beta1SubjectAccessReviewStatus reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason is optional.  It indicates why a request was allowed or denied.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAuthorizationV1beta1SubjectAccessReviewStatus ioK8sApiAuthorizationV1beta1SubjectAccessReviewStatus = (IoK8sApiAuthorizationV1beta1SubjectAccessReviewStatus)o;
        return Objects.equals(this.allowed, ioK8sApiAuthorizationV1beta1SubjectAccessReviewStatus.allowed) && Objects.equals(this.denied, ioK8sApiAuthorizationV1beta1SubjectAccessReviewStatus.denied) && Objects.equals(this.evaluationError, ioK8sApiAuthorizationV1beta1SubjectAccessReviewStatus.evaluationError) && Objects.equals(this.reason, ioK8sApiAuthorizationV1beta1SubjectAccessReviewStatus.reason);
    }

    public int hashCode() {
        return Objects.hash(this.allowed, this.denied, this.evaluationError, this.reason);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAuthorizationV1beta1SubjectAccessReviewStatus {\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    denied: ").append(this.toIndentedString(this.denied)).append("\n");
        sb.append("    evaluationError: ").append(this.toIndentedString(this.evaluationError)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

