/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="current status of a horizontal pod autoscaler")
@JsonPropertyOrder(value={"currentCPUUtilizationPercentage", "currentReplicas", "desiredReplicas", "lastScaleTime", "observedGeneration"})
public class IoK8sApiAutoscalingV1HorizontalPodAutoscalerStatus {
    public static final String JSON_PROPERTY_CURRENT_C_P_U_UTILIZATION_PERCENTAGE = "currentCPUUtilizationPercentage";
    private Integer currentCPUUtilizationPercentage;
    public static final String JSON_PROPERTY_CURRENT_REPLICAS = "currentReplicas";
    private Integer currentReplicas;
    public static final String JSON_PROPERTY_DESIRED_REPLICAS = "desiredReplicas";
    private Integer desiredReplicas;
    public static final String JSON_PROPERTY_LAST_SCALE_TIME = "lastScaleTime";
    private OffsetDateTime lastScaleTime;
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    private Long observedGeneration;

    public IoK8sApiAutoscalingV1HorizontalPodAutoscalerStatus currentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage) {
        this.currentCPUUtilizationPercentage = currentCPUUtilizationPercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.")
    @JsonProperty(value="currentCPUUtilizationPercentage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCurrentCPUUtilizationPercentage() {
        return this.currentCPUUtilizationPercentage;
    }

    public void setCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage) {
        this.currentCPUUtilizationPercentage = currentCPUUtilizationPercentage;
    }

    public IoK8sApiAutoscalingV1HorizontalPodAutoscalerStatus currentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    @ApiModelProperty(required=true, value="current number of replicas of pods managed by this autoscaler.")
    @JsonProperty(value="currentReplicas")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public IoK8sApiAutoscalingV1HorizontalPodAutoscalerStatus desiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return this;
    }

    @ApiModelProperty(required=true, value="desired number of replicas of pods managed by this autoscaler.")
    @JsonProperty(value="desiredReplicas")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    public void setDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
    }

    public IoK8sApiAutoscalingV1HorizontalPodAutoscalerStatus lastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.")
    @JsonProperty(value="lastScaleTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastScaleTime() {
        return this.lastScaleTime;
    }

    public void setLastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
    }

    public IoK8sApiAutoscalingV1HorizontalPodAutoscalerStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="most recent generation observed by this autoscaler.")
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAutoscalingV1HorizontalPodAutoscalerStatus ioK8sApiAutoscalingV1HorizontalPodAutoscalerStatus = (IoK8sApiAutoscalingV1HorizontalPodAutoscalerStatus)o;
        return Objects.equals(this.currentCPUUtilizationPercentage, ioK8sApiAutoscalingV1HorizontalPodAutoscalerStatus.currentCPUUtilizationPercentage) && Objects.equals(this.currentReplicas, ioK8sApiAutoscalingV1HorizontalPodAutoscalerStatus.currentReplicas) && Objects.equals(this.desiredReplicas, ioK8sApiAutoscalingV1HorizontalPodAutoscalerStatus.desiredReplicas) && Objects.equals(this.lastScaleTime, ioK8sApiAutoscalingV1HorizontalPodAutoscalerStatus.lastScaleTime) && Objects.equals(this.observedGeneration, ioK8sApiAutoscalingV1HorizontalPodAutoscalerStatus.observedGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.currentCPUUtilizationPercentage, this.currentReplicas, this.desiredReplicas, this.lastScaleTime, this.observedGeneration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAutoscalingV1HorizontalPodAutoscalerStatus {\n");
        sb.append("    currentCPUUtilizationPercentage: ").append(this.toIndentedString(this.currentCPUUtilizationPercentage)).append("\n");
        sb.append("    currentReplicas: ").append(this.toIndentedString(this.currentReplicas)).append("\n");
        sb.append("    desiredReplicas: ").append(this.toIndentedString(this.desiredReplicas)).append("\n");
        sb.append("    lastScaleTime: ").append(this.toIndentedString(this.lastScaleTime)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

