/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerCondition;
import net.stickycode.kuuty.model.v18.IoK8sApiAutoscalingV2beta1MetricStatus;

@ApiModel(description="HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.")
@JsonPropertyOrder(value={"conditions", "currentMetrics", "currentReplicas", "desiredReplicas", "lastScaleTime", "observedGeneration"})
public class IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus {
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerCondition> conditions = new ArrayList<IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerCondition>();
    public static final String JSON_PROPERTY_CURRENT_METRICS = "currentMetrics";
    private List<IoK8sApiAutoscalingV2beta1MetricStatus> currentMetrics = null;
    public static final String JSON_PROPERTY_CURRENT_REPLICAS = "currentReplicas";
    private Integer currentReplicas;
    public static final String JSON_PROPERTY_DESIRED_REPLICAS = "desiredReplicas";
    private Integer desiredReplicas;
    public static final String JSON_PROPERTY_LAST_SCALE_TIME = "lastScaleTime";
    private OffsetDateTime lastScaleTime;
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    private Long observedGeneration;

    public IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus conditions(List<IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus addConditionsItem(IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerCondition conditionsItem) {
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerCondition> conditions) {
        this.conditions = conditions;
    }

    public IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus currentMetrics(List<IoK8sApiAutoscalingV2beta1MetricStatus> currentMetrics) {
        this.currentMetrics = currentMetrics;
        return this;
    }

    public IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus addCurrentMetricsItem(IoK8sApiAutoscalingV2beta1MetricStatus currentMetricsItem) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList<IoK8sApiAutoscalingV2beta1MetricStatus>();
        }
        this.currentMetrics.add(currentMetricsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="currentMetrics is the last read state of the metrics used by this autoscaler.")
    @JsonProperty(value="currentMetrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiAutoscalingV2beta1MetricStatus> getCurrentMetrics() {
        return this.currentMetrics;
    }

    public void setCurrentMetrics(List<IoK8sApiAutoscalingV2beta1MetricStatus> currentMetrics) {
        this.currentMetrics = currentMetrics;
    }

    public IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus currentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    @ApiModelProperty(required=true, value="currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.")
    @JsonProperty(value="currentReplicas")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus desiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return this;
    }

    @ApiModelProperty(required=true, value="desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.")
    @JsonProperty(value="desiredReplicas")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    public void setDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
    }

    public IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus lastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.")
    @JsonProperty(value="lastScaleTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastScaleTime() {
        return this.lastScaleTime;
    }

    public void setLastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
    }

    public IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="observedGeneration is the most recent generation observed by this autoscaler.")
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus ioK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus = (IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus)o;
        return Objects.equals(this.conditions, ioK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus.conditions) && Objects.equals(this.currentMetrics, ioK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus.currentMetrics) && Objects.equals(this.currentReplicas, ioK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus.currentReplicas) && Objects.equals(this.desiredReplicas, ioK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus.desiredReplicas) && Objects.equals(this.lastScaleTime, ioK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus.lastScaleTime) && Objects.equals(this.observedGeneration, ioK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus.observedGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.currentMetrics, this.currentReplicas, this.desiredReplicas, this.lastScaleTime, this.observedGeneration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAutoscalingV2beta1HorizontalPodAutoscalerStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentMetrics: ").append(this.toIndentedString(this.currentMetrics)).append("\n");
        sb.append("    currentReplicas: ").append(this.toIndentedString(this.currentReplicas)).append("\n");
        sb.append("    desiredReplicas: ").append(this.toIndentedString(this.desiredReplicas)).append("\n");
        sb.append("    lastScaleTime: ").append(this.toIndentedString(this.lastScaleTime)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

