/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.")
@JsonPropertyOrder(value={"name", "targetAverageUtilization", "targetAverageValue"})
public class IoK8sApiAutoscalingV2beta1ResourceMetricSource {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TARGET_AVERAGE_UTILIZATION = "targetAverageUtilization";
    private Integer targetAverageUtilization;
    public static final String JSON_PROPERTY_TARGET_AVERAGE_VALUE = "targetAverageValue";
    private String targetAverageValue;

    public IoK8sApiAutoscalingV2beta1ResourceMetricSource name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name is the name of the resource in question.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IoK8sApiAutoscalingV2beta1ResourceMetricSource targetAverageUtilization(Integer targetAverageUtilization) {
        this.targetAverageUtilization = targetAverageUtilization;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.")
    @JsonProperty(value="targetAverageUtilization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTargetAverageUtilization() {
        return this.targetAverageUtilization;
    }

    public void setTargetAverageUtilization(Integer targetAverageUtilization) {
        this.targetAverageUtilization = targetAverageUtilization;
    }

    public IoK8sApiAutoscalingV2beta1ResourceMetricSource targetAverageValue(String targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Quantity is a fixed-point representation of a number. It provides convenient marshaling/unmarshaling in JSON and YAML, in addition to String() and AsInt64() accessors.  The serialization format is:  <quantity>        ::= <signedNumber><suffix>   (Note that <suffix> may be empty, from the \"\" case in <decimalSI>.) <digit>           ::= 0 | 1 | ... | 9 <digits>          ::= <digit> | <digit><digits> <number>          ::= <digits> | <digits>.<digits> | <digits>. | .<digits> <sign>            ::= \"+\" | \"-\" <signedNumber>    ::= <number> | <sign><number> <suffix>          ::= <binarySI> | <decimalExponent> | <decimalSI> <binarySI>        ::= Ki | Mi | Gi | Ti | Pi | Ei   (International System of units; See: http://physics.nist.gov/cuu/Units/binary.html) <decimalSI>       ::= m | \"\" | k | M | G | T | P | E   (Note that 1024 = 1Ki but 1000 = 1k; I didn't choose the capitalization.) <decimalExponent> ::= \"e\" <signedNumber> | \"E\" <signedNumber>  No matter which of the three exponent forms is used, no quantity may represent a number greater than 2^63-1 in magnitude, nor may it have more than 3 decimal places. Numbers larger or more precise will be capped or rounded up. (E.g.: 0.1m will rounded up to 1m.) This may be extended in the future if we require larger or smaller quantities.  When a Quantity is parsed from a string, it will remember the type of suffix it had, and will use the same type again when it is serialized.  Before serializing, Quantity will be put in \"canonical form\". This means that Exponent/suffix will be adjusted up or down (with a corresponding increase or decrease in Mantissa) such that:   a. No precision is lost   b. No fractional digits will be emitted   c. The exponent (or suffix) is as large as possible. The sign will be omitted unless the number is negative.  Examples:   1.5 will be serialized as \"1500m\"   1.5Gi will be serialized as \"1536Mi\"  Note that the quantity will NEVER be internally represented by a floating point number. That is the whole point of this exercise.  Non-canonical values will still parse as long as they are well formed, but will be re-emitted in their canonical form. (So always use canonical form, or don't diff.)  This format is intended to make it difficult to use these numbers without writing some sort of special handling code in the hopes that that will cause implementors to also use a fixed point implementation.")
    @JsonProperty(value="targetAverageValue")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTargetAverageValue() {
        return this.targetAverageValue;
    }

    public void setTargetAverageValue(String targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAutoscalingV2beta1ResourceMetricSource ioK8sApiAutoscalingV2beta1ResourceMetricSource = (IoK8sApiAutoscalingV2beta1ResourceMetricSource)o;
        return Objects.equals(this.name, ioK8sApiAutoscalingV2beta1ResourceMetricSource.name) && Objects.equals(this.targetAverageUtilization, ioK8sApiAutoscalingV2beta1ResourceMetricSource.targetAverageUtilization) && Objects.equals(this.targetAverageValue, ioK8sApiAutoscalingV2beta1ResourceMetricSource.targetAverageValue);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.targetAverageUtilization, this.targetAverageValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAutoscalingV2beta1ResourceMetricSource {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    targetAverageUtilization: ").append(this.toIndentedString(this.targetAverageUtilization)).append("\n");
        sb.append("    targetAverageValue: ").append(this.toIndentedString(this.targetAverageValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

