/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiAutoscalingV2beta2HPAScalingPolicy;

@ApiModel(description="HPAScalingRules configures the scaling behavior for one direction. These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.")
@JsonPropertyOrder(value={"policies", "selectPolicy", "stabilizationWindowSeconds"})
public class IoK8sApiAutoscalingV2beta2HPAScalingRules {
    public static final String JSON_PROPERTY_POLICIES = "policies";
    private List<IoK8sApiAutoscalingV2beta2HPAScalingPolicy> policies = null;
    public static final String JSON_PROPERTY_SELECT_POLICY = "selectPolicy";
    private String selectPolicy;
    public static final String JSON_PROPERTY_STABILIZATION_WINDOW_SECONDS = "stabilizationWindowSeconds";
    private Integer stabilizationWindowSeconds;

    public IoK8sApiAutoscalingV2beta2HPAScalingRules policies(List<IoK8sApiAutoscalingV2beta2HPAScalingPolicy> policies) {
        this.policies = policies;
        return this;
    }

    public IoK8sApiAutoscalingV2beta2HPAScalingRules addPoliciesItem(IoK8sApiAutoscalingV2beta2HPAScalingPolicy policiesItem) {
        if (this.policies == null) {
            this.policies = new ArrayList<IoK8sApiAutoscalingV2beta2HPAScalingPolicy>();
        }
        this.policies.add(policiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid")
    @JsonProperty(value="policies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiAutoscalingV2beta2HPAScalingPolicy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<IoK8sApiAutoscalingV2beta2HPAScalingPolicy> policies) {
        this.policies = policies;
    }

    public IoK8sApiAutoscalingV2beta2HPAScalingRules selectPolicy(String selectPolicy) {
        this.selectPolicy = selectPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="selectPolicy is used to specify which policy should be used. If not set, the default value MaxPolicySelect is used.")
    @JsonProperty(value="selectPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSelectPolicy() {
        return this.selectPolicy;
    }

    public void setSelectPolicy(String selectPolicy) {
        this.selectPolicy = selectPolicy;
    }

    public IoK8sApiAutoscalingV2beta2HPAScalingRules stabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
        this.stabilizationWindowSeconds = stabilizationWindowSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).")
    @JsonProperty(value="stabilizationWindowSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds;
    }

    public void setStabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
        this.stabilizationWindowSeconds = stabilizationWindowSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiAutoscalingV2beta2HPAScalingRules ioK8sApiAutoscalingV2beta2HPAScalingRules = (IoK8sApiAutoscalingV2beta2HPAScalingRules)o;
        return Objects.equals(this.policies, ioK8sApiAutoscalingV2beta2HPAScalingRules.policies) && Objects.equals(this.selectPolicy, ioK8sApiAutoscalingV2beta2HPAScalingRules.selectPolicy) && Objects.equals(this.stabilizationWindowSeconds, ioK8sApiAutoscalingV2beta2HPAScalingRules.stabilizationWindowSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.policies, this.selectPolicy, this.stabilizationWindowSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiAutoscalingV2beta2HPAScalingRules {\n");
        sb.append("    policies: ").append(this.toIndentedString(this.policies)).append("\n");
        sb.append("    selectPolicy: ").append(this.toIndentedString(this.selectPolicy)).append("\n");
        sb.append("    stabilizationWindowSeconds: ").append(this.toIndentedString(this.stabilizationWindowSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

