/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1PodTemplateSpec;
import net.stickycode.kuuty.model.v18.IoK8sApimachineryPkgApisMetaV1LabelSelector;

@ApiModel(description="JobSpec describes how the job execution will look like.")
@JsonPropertyOrder(value={"activeDeadlineSeconds", "backoffLimit", "completions", "manualSelector", "parallelism", "selector", "template", "ttlSecondsAfterFinished"})
public class IoK8sApiBatchV1JobSpec {
    public static final String JSON_PROPERTY_ACTIVE_DEADLINE_SECONDS = "activeDeadlineSeconds";
    private Long activeDeadlineSeconds;
    public static final String JSON_PROPERTY_BACKOFF_LIMIT = "backoffLimit";
    private Integer backoffLimit;
    public static final String JSON_PROPERTY_COMPLETIONS = "completions";
    private Integer completions;
    public static final String JSON_PROPERTY_MANUAL_SELECTOR = "manualSelector";
    private Boolean manualSelector;
    public static final String JSON_PROPERTY_PARALLELISM = "parallelism";
    private Integer parallelism;
    public static final String JSON_PROPERTY_SELECTOR = "selector";
    private IoK8sApimachineryPkgApisMetaV1LabelSelector selector;
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    private IoK8sApiCoreV1PodTemplateSpec template;
    public static final String JSON_PROPERTY_TTL_SECONDS_AFTER_FINISHED = "ttlSecondsAfterFinished";
    private Integer ttlSecondsAfterFinished;

    public IoK8sApiBatchV1JobSpec activeDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it; value must be positive integer")
    @JsonProperty(value="activeDeadlineSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public void setActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    public IoK8sApiBatchV1JobSpec backoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the number of retries before marking this job failed. Defaults to 6")
    @JsonProperty(value="backoffLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    public void setBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
    }

    public IoK8sApiBatchV1JobSpec completions(Integer completions) {
        this.completions = completions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the desired number of successfully finished pods the job should be run with.  Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    @JsonProperty(value="completions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCompletions() {
        return this.completions;
    }

    public void setCompletions(Integer completions) {
        this.completions = completions;
    }

    public IoK8sApiBatchV1JobSpec manualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector")
    @JsonProperty(value="manualSelector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getManualSelector() {
        return this.manualSelector;
    }

    public void setManualSelector(Boolean manualSelector) {
        this.manualSelector = manualSelector;
    }

    public IoK8sApiBatchV1JobSpec parallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    @JsonProperty(value="parallelism")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public IoK8sApiBatchV1JobSpec selector(IoK8sApimachineryPkgApisMetaV1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="selector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApimachineryPkgApisMetaV1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(IoK8sApimachineryPkgApisMetaV1LabelSelector selector) {
        this.selector = selector;
    }

    public IoK8sApiBatchV1JobSpec template(IoK8sApiCoreV1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IoK8sApiCoreV1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(IoK8sApiCoreV1PodTemplateSpec template) {
        this.template = template;
    }

    public IoK8sApiBatchV1JobSpec ttlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the TTLAfterFinished feature.")
    @JsonProperty(value="ttlSecondsAfterFinished")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    public void setTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiBatchV1JobSpec ioK8sApiBatchV1JobSpec = (IoK8sApiBatchV1JobSpec)o;
        return Objects.equals(this.activeDeadlineSeconds, ioK8sApiBatchV1JobSpec.activeDeadlineSeconds) && Objects.equals(this.backoffLimit, ioK8sApiBatchV1JobSpec.backoffLimit) && Objects.equals(this.completions, ioK8sApiBatchV1JobSpec.completions) && Objects.equals(this.manualSelector, ioK8sApiBatchV1JobSpec.manualSelector) && Objects.equals(this.parallelism, ioK8sApiBatchV1JobSpec.parallelism) && Objects.equals(this.selector, ioK8sApiBatchV1JobSpec.selector) && Objects.equals(this.template, ioK8sApiBatchV1JobSpec.template) && Objects.equals(this.ttlSecondsAfterFinished, ioK8sApiBatchV1JobSpec.ttlSecondsAfterFinished);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.backoffLimit, this.completions, this.manualSelector, this.parallelism, this.selector, this.template, this.ttlSecondsAfterFinished);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiBatchV1JobSpec {\n");
        sb.append("    activeDeadlineSeconds: ").append(this.toIndentedString(this.activeDeadlineSeconds)).append("\n");
        sb.append("    backoffLimit: ").append(this.toIndentedString(this.backoffLimit)).append("\n");
        sb.append("    completions: ").append(this.toIndentedString(this.completions)).append("\n");
        sb.append("    manualSelector: ").append(this.toIndentedString(this.manualSelector)).append("\n");
        sb.append("    parallelism: ").append(this.toIndentedString(this.parallelism)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    ttlSecondsAfterFinished: ").append(this.toIndentedString(this.ttlSecondsAfterFinished)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

