/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiBatchV1JobCondition;

@ApiModel(description="JobStatus represents the current state of a Job.")
@JsonPropertyOrder(value={"active", "completionTime", "conditions", "failed", "startTime", "succeeded"})
public class IoK8sApiBatchV1JobStatus {
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Integer active;
    public static final String JSON_PROPERTY_COMPLETION_TIME = "completionTime";
    private OffsetDateTime completionTime;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<IoK8sApiBatchV1JobCondition> conditions = null;
    public static final String JSON_PROPERTY_FAILED = "failed";
    private Integer failed;
    public static final String JSON_PROPERTY_START_TIME = "startTime";
    private OffsetDateTime startTime;
    public static final String JSON_PROPERTY_SUCCEEDED = "succeeded";
    private Integer succeeded;

    public IoK8sApiBatchV1JobStatus active(Integer active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of actively running pods.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getActive() {
        return this.active;
    }

    public void setActive(Integer active) {
        this.active = active;
    }

    public IoK8sApiBatchV1JobStatus completionTime(OffsetDateTime completionTime) {
        this.completionTime = completionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.")
    @JsonProperty(value="completionTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(OffsetDateTime completionTime) {
        this.completionTime = completionTime;
    }

    public IoK8sApiBatchV1JobStatus conditions(List<IoK8sApiBatchV1JobCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public IoK8sApiBatchV1JobStatus addConditionsItem(IoK8sApiBatchV1JobCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IoK8sApiBatchV1JobCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The latest available observations of an object's current state. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiBatchV1JobCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<IoK8sApiBatchV1JobCondition> conditions) {
        this.conditions = conditions;
    }

    public IoK8sApiBatchV1JobStatus failed(Integer failed) {
        this.failed = failed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pods which reached phase Failed.")
    @JsonProperty(value="failed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFailed() {
        return this.failed;
    }

    public void setFailed(Integer failed) {
        this.failed = failed;
    }

    public IoK8sApiBatchV1JobStatus startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.")
    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public IoK8sApiBatchV1JobStatus succeeded(Integer succeeded) {
        this.succeeded = succeeded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pods which reached phase Succeeded.")
    @JsonProperty(value="succeeded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiBatchV1JobStatus ioK8sApiBatchV1JobStatus = (IoK8sApiBatchV1JobStatus)o;
        return Objects.equals(this.active, ioK8sApiBatchV1JobStatus.active) && Objects.equals(this.completionTime, ioK8sApiBatchV1JobStatus.completionTime) && Objects.equals(this.conditions, ioK8sApiBatchV1JobStatus.conditions) && Objects.equals(this.failed, ioK8sApiBatchV1JobStatus.failed) && Objects.equals(this.startTime, ioK8sApiBatchV1JobStatus.startTime) && Objects.equals(this.succeeded, ioK8sApiBatchV1JobStatus.succeeded);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.completionTime, this.conditions, this.failed, this.startTime, this.succeeded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiBatchV1JobStatus {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    completionTime: ").append(this.toIndentedString(this.completionTime)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    failed: ").append(this.toIndentedString(this.failed)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    succeeded: ").append(this.toIndentedString(this.succeeded)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

