/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiBatchV2alpha1JobTemplateSpec;

@ApiModel(description="CronJobSpec describes how the job execution will look like and when it will actually run.")
@JsonPropertyOrder(value={"concurrencyPolicy", "failedJobsHistoryLimit", "jobTemplate", "schedule", "startingDeadlineSeconds", "successfulJobsHistoryLimit", "suspend"})
public class IoK8sApiBatchV2alpha1CronJobSpec {
    public static final String JSON_PROPERTY_CONCURRENCY_POLICY = "concurrencyPolicy";
    private String concurrencyPolicy;
    public static final String JSON_PROPERTY_FAILED_JOBS_HISTORY_LIMIT = "failedJobsHistoryLimit";
    private Integer failedJobsHistoryLimit;
    public static final String JSON_PROPERTY_JOB_TEMPLATE = "jobTemplate";
    private IoK8sApiBatchV2alpha1JobTemplateSpec jobTemplate;
    public static final String JSON_PROPERTY_SCHEDULE = "schedule";
    private String schedule;
    public static final String JSON_PROPERTY_STARTING_DEADLINE_SECONDS = "startingDeadlineSeconds";
    private Long startingDeadlineSeconds;
    public static final String JSON_PROPERTY_SUCCESSFUL_JOBS_HISTORY_LIMIT = "successfulJobsHistoryLimit";
    private Integer successfulJobsHistoryLimit;
    public static final String JSON_PROPERTY_SUSPEND = "suspend";
    private Boolean suspend;

    public IoK8sApiBatchV2alpha1CronJobSpec concurrencyPolicy(String concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies how to treat concurrent executions of a Job. Valid values are: - \"Allow\" (default): allows CronJobs to run concurrently; - \"Forbid\": forbids concurrent runs, skipping next run if previous run hasn't finished yet; - \"Replace\": cancels currently running job and replaces it with a new one")
    @JsonProperty(value="concurrencyPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getConcurrencyPolicy() {
        return this.concurrencyPolicy;
    }

    public void setConcurrencyPolicy(String concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
    }

    public IoK8sApiBatchV2alpha1CronJobSpec failedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
        this.failedJobsHistoryLimit = failedJobsHistoryLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of failed finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified.")
    @JsonProperty(value="failedJobsHistoryLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit;
    }

    public void setFailedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
        this.failedJobsHistoryLimit = failedJobsHistoryLimit;
    }

    public IoK8sApiBatchV2alpha1CronJobSpec jobTemplate(IoK8sApiBatchV2alpha1JobTemplateSpec jobTemplate) {
        this.jobTemplate = jobTemplate;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="jobTemplate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IoK8sApiBatchV2alpha1JobTemplateSpec getJobTemplate() {
        return this.jobTemplate;
    }

    public void setJobTemplate(IoK8sApiBatchV2alpha1JobTemplateSpec jobTemplate) {
        this.jobTemplate = jobTemplate;
    }

    public IoK8sApiBatchV2alpha1CronJobSpec schedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(required=true, value="The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.")
    @JsonProperty(value="schedule")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public IoK8sApiBatchV2alpha1CronJobSpec startingDeadlineSeconds(Long startingDeadlineSeconds) {
        this.startingDeadlineSeconds = startingDeadlineSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional deadline in seconds for starting the job if it misses scheduled time for any reason.  Missed jobs executions will be counted as failed ones.")
    @JsonProperty(value="startingDeadlineSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds;
    }

    public void setStartingDeadlineSeconds(Long startingDeadlineSeconds) {
        this.startingDeadlineSeconds = startingDeadlineSeconds;
    }

    public IoK8sApiBatchV2alpha1CronJobSpec successfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
        this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of successful finished jobs to retain. This is a pointer to distinguish between explicit zero and not specified.")
    @JsonProperty(value="successfulJobsHistoryLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit;
    }

    public void setSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
        this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
    }

    public IoK8sApiBatchV2alpha1CronJobSpec suspend(Boolean suspend) {
        this.suspend = suspend;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This flag tells the controller to suspend subsequent executions, it does not apply to already started executions.  Defaults to false.")
    @JsonProperty(value="suspend")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSuspend() {
        return this.suspend;
    }

    public void setSuspend(Boolean suspend) {
        this.suspend = suspend;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiBatchV2alpha1CronJobSpec ioK8sApiBatchV2alpha1CronJobSpec = (IoK8sApiBatchV2alpha1CronJobSpec)o;
        return Objects.equals(this.concurrencyPolicy, ioK8sApiBatchV2alpha1CronJobSpec.concurrencyPolicy) && Objects.equals(this.failedJobsHistoryLimit, ioK8sApiBatchV2alpha1CronJobSpec.failedJobsHistoryLimit) && Objects.equals(this.jobTemplate, ioK8sApiBatchV2alpha1CronJobSpec.jobTemplate) && Objects.equals(this.schedule, ioK8sApiBatchV2alpha1CronJobSpec.schedule) && Objects.equals(this.startingDeadlineSeconds, ioK8sApiBatchV2alpha1CronJobSpec.startingDeadlineSeconds) && Objects.equals(this.successfulJobsHistoryLimit, ioK8sApiBatchV2alpha1CronJobSpec.successfulJobsHistoryLimit) && Objects.equals(this.suspend, ioK8sApiBatchV2alpha1CronJobSpec.suspend);
    }

    public int hashCode() {
        return Objects.hash(this.concurrencyPolicy, this.failedJobsHistoryLimit, this.jobTemplate, this.schedule, this.startingDeadlineSeconds, this.successfulJobsHistoryLimit, this.suspend);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiBatchV2alpha1CronJobSpec {\n");
        sb.append("    concurrencyPolicy: ").append(this.toIndentedString(this.concurrencyPolicy)).append("\n");
        sb.append("    failedJobsHistoryLimit: ").append(this.toIndentedString(this.failedJobsHistoryLimit)).append("\n");
        sb.append("    jobTemplate: ").append(this.toIndentedString(this.jobTemplate)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    startingDeadlineSeconds: ").append(this.toIndentedString(this.startingDeadlineSeconds)).append("\n");
        sb.append("    successfulJobsHistoryLimit: ").append(this.toIndentedString(this.successfulJobsHistoryLimit)).append("\n");
        sb.append("    suspend: ").append(this.toIndentedString(this.suspend)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

