/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LeaseSpec is a specification of a Lease.")
@JsonPropertyOrder(value={"acquireTime", "holderIdentity", "leaseDurationSeconds", "leaseTransitions", "renewTime"})
public class IoK8sApiCoordinationV1LeaseSpec {
    public static final String JSON_PROPERTY_ACQUIRE_TIME = "acquireTime";
    private OffsetDateTime acquireTime;
    public static final String JSON_PROPERTY_HOLDER_IDENTITY = "holderIdentity";
    private String holderIdentity;
    public static final String JSON_PROPERTY_LEASE_DURATION_SECONDS = "leaseDurationSeconds";
    private Integer leaseDurationSeconds;
    public static final String JSON_PROPERTY_LEASE_TRANSITIONS = "leaseTransitions";
    private Integer leaseTransitions;
    public static final String JSON_PROPERTY_RENEW_TIME = "renewTime";
    private OffsetDateTime renewTime;

    public IoK8sApiCoordinationV1LeaseSpec acquireTime(OffsetDateTime acquireTime) {
        this.acquireTime = acquireTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MicroTime is version of Time with microsecond level precision.")
    @JsonProperty(value="acquireTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getAcquireTime() {
        return this.acquireTime;
    }

    public void setAcquireTime(OffsetDateTime acquireTime) {
        this.acquireTime = acquireTime;
    }

    public IoK8sApiCoordinationV1LeaseSpec holderIdentity(String holderIdentity) {
        this.holderIdentity = holderIdentity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="holderIdentity contains the identity of the holder of a current lease.")
    @JsonProperty(value="holderIdentity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHolderIdentity() {
        return this.holderIdentity;
    }

    public void setHolderIdentity(String holderIdentity) {
        this.holderIdentity = holderIdentity;
    }

    public IoK8sApiCoordinationV1LeaseSpec leaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds = leaseDurationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="leaseDurationSeconds is a duration that candidates for a lease need to wait to force acquire it. This is measure against time of last observed RenewTime.")
    @JsonProperty(value="leaseDurationSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLeaseDurationSeconds() {
        return this.leaseDurationSeconds;
    }

    public void setLeaseDurationSeconds(Integer leaseDurationSeconds) {
        this.leaseDurationSeconds = leaseDurationSeconds;
    }

    public IoK8sApiCoordinationV1LeaseSpec leaseTransitions(Integer leaseTransitions) {
        this.leaseTransitions = leaseTransitions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="leaseTransitions is the number of transitions of a lease between holders.")
    @JsonProperty(value="leaseTransitions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLeaseTransitions() {
        return this.leaseTransitions;
    }

    public void setLeaseTransitions(Integer leaseTransitions) {
        this.leaseTransitions = leaseTransitions;
    }

    public IoK8sApiCoordinationV1LeaseSpec renewTime(OffsetDateTime renewTime) {
        this.renewTime = renewTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MicroTime is version of Time with microsecond level precision.")
    @JsonProperty(value="renewTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getRenewTime() {
        return this.renewTime;
    }

    public void setRenewTime(OffsetDateTime renewTime) {
        this.renewTime = renewTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoordinationV1LeaseSpec ioK8sApiCoordinationV1LeaseSpec = (IoK8sApiCoordinationV1LeaseSpec)o;
        return Objects.equals(this.acquireTime, ioK8sApiCoordinationV1LeaseSpec.acquireTime) && Objects.equals(this.holderIdentity, ioK8sApiCoordinationV1LeaseSpec.holderIdentity) && Objects.equals(this.leaseDurationSeconds, ioK8sApiCoordinationV1LeaseSpec.leaseDurationSeconds) && Objects.equals(this.leaseTransitions, ioK8sApiCoordinationV1LeaseSpec.leaseTransitions) && Objects.equals(this.renewTime, ioK8sApiCoordinationV1LeaseSpec.renewTime);
    }

    public int hashCode() {
        return Objects.hash(this.acquireTime, this.holderIdentity, this.leaseDurationSeconds, this.leaseTransitions, this.renewTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoordinationV1LeaseSpec {\n");
        sb.append("    acquireTime: ").append(this.toIndentedString(this.acquireTime)).append("\n");
        sb.append("    holderIdentity: ").append(this.toIndentedString(this.holderIdentity)).append("\n");
        sb.append("    leaseDurationSeconds: ").append(this.toIndentedString(this.leaseDurationSeconds)).append("\n");
        sb.append("    leaseTransitions: ").append(this.toIndentedString(this.leaseTransitions)).append("\n");
        sb.append("    renewTime: ").append(this.toIndentedString(this.renewTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

