/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a Persistent Disk resource in AWS.  An AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.")
@JsonPropertyOrder(value={"fsType", "partition", "readOnly", "volumeID"})
public class IoK8sApiCoreV1AWSElasticBlockStoreVolumeSource {
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    private String fsType;
    public static final String JSON_PROPERTY_PARTITION = "partition";
    private Integer partition;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;
    public static final String JSON_PROPERTY_VOLUME_I_D = "volumeID";
    private String volumeID;

    public IoK8sApiCoreV1AWSElasticBlockStoreVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore")
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public IoK8sApiCoreV1AWSElasticBlockStoreVolumeSource partition(Integer partition) {
        this.partition = partition;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \"1\". Similarly, the volume partition for /dev/sda is \"0\" (or you can leave the property empty).")
    @JsonProperty(value="partition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPartition() {
        return this.partition;
    }

    public void setPartition(Integer partition) {
        this.partition = partition;
    }

    public IoK8sApiCoreV1AWSElasticBlockStoreVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify \"true\" to force and set the ReadOnly property in VolumeMounts to \"true\". If omitted, the default is \"false\". More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public IoK8sApiCoreV1AWSElasticBlockStoreVolumeSource volumeID(String volumeID) {
        this.volumeID = volumeID;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore")
    @JsonProperty(value="volumeID")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVolumeID() {
        return this.volumeID;
    }

    public void setVolumeID(String volumeID) {
        this.volumeID = volumeID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1AWSElasticBlockStoreVolumeSource ioK8sApiCoreV1AWSElasticBlockStoreVolumeSource = (IoK8sApiCoreV1AWSElasticBlockStoreVolumeSource)o;
        return Objects.equals(this.fsType, ioK8sApiCoreV1AWSElasticBlockStoreVolumeSource.fsType) && Objects.equals(this.partition, ioK8sApiCoreV1AWSElasticBlockStoreVolumeSource.partition) && Objects.equals(this.readOnly, ioK8sApiCoreV1AWSElasticBlockStoreVolumeSource.readOnly) && Objects.equals(this.volumeID, ioK8sApiCoreV1AWSElasticBlockStoreVolumeSource.volumeID);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.partition, this.readOnly, this.volumeID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1AWSElasticBlockStoreVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    partition: ").append(this.toIndentedString(this.partition)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    volumeID: ").append(this.toIndentedString(this.volumeID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

