/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.")
@JsonPropertyOrder(value={"cachingMode", "diskName", "diskURI", "fsType", "kind", "readOnly"})
public class IoK8sApiCoreV1AzureDiskVolumeSource {
    public static final String JSON_PROPERTY_CACHING_MODE = "cachingMode";
    private String cachingMode;
    public static final String JSON_PROPERTY_DISK_NAME = "diskName";
    private String diskName;
    public static final String JSON_PROPERTY_DISK_U_R_I = "diskURI";
    private String diskURI;
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    private String fsType;
    public static final String JSON_PROPERTY_KIND = "kind";
    private String kind;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;

    public IoK8sApiCoreV1AzureDiskVolumeSource cachingMode(String cachingMode) {
        this.cachingMode = cachingMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Host Caching mode: None, Read Only, Read Write.")
    @JsonProperty(value="cachingMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCachingMode() {
        return this.cachingMode;
    }

    public void setCachingMode(String cachingMode) {
        this.cachingMode = cachingMode;
    }

    public IoK8sApiCoreV1AzureDiskVolumeSource diskName(String diskName) {
        this.diskName = diskName;
        return this;
    }

    @ApiModelProperty(required=true, value="The Name of the data disk in the blob storage")
    @JsonProperty(value="diskName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDiskName() {
        return this.diskName;
    }

    public void setDiskName(String diskName) {
        this.diskName = diskName;
    }

    public IoK8sApiCoreV1AzureDiskVolumeSource diskURI(String diskURI) {
        this.diskURI = diskURI;
        return this;
    }

    @ApiModelProperty(required=true, value="The URI the data disk in the blob storage")
    @JsonProperty(value="diskURI")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDiskURI() {
        return this.diskURI;
    }

    public void setDiskURI(String diskURI) {
        this.diskURI = diskURI;
    }

    public IoK8sApiCoreV1AzureDiskVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public IoK8sApiCoreV1AzureDiskVolumeSource kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared")
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public IoK8sApiCoreV1AzureDiskVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1AzureDiskVolumeSource ioK8sApiCoreV1AzureDiskVolumeSource = (IoK8sApiCoreV1AzureDiskVolumeSource)o;
        return Objects.equals(this.cachingMode, ioK8sApiCoreV1AzureDiskVolumeSource.cachingMode) && Objects.equals(this.diskName, ioK8sApiCoreV1AzureDiskVolumeSource.diskName) && Objects.equals(this.diskURI, ioK8sApiCoreV1AzureDiskVolumeSource.diskURI) && Objects.equals(this.fsType, ioK8sApiCoreV1AzureDiskVolumeSource.fsType) && Objects.equals(this.kind, ioK8sApiCoreV1AzureDiskVolumeSource.kind) && Objects.equals(this.readOnly, ioK8sApiCoreV1AzureDiskVolumeSource.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.cachingMode, this.diskName, this.diskURI, this.fsType, this.kind, this.readOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1AzureDiskVolumeSource {\n");
        sb.append("    cachingMode: ").append(this.toIndentedString(this.cachingMode)).append("\n");
        sb.append("    diskName: ").append(this.toIndentedString(this.diskName)).append("\n");
        sb.append("    diskURI: ").append(this.toIndentedString(this.diskURI)).append("\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

