/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1SecretReference;

@ApiModel(description="Represents storage that is managed by an external CSI volume driver (Beta feature)")
@JsonPropertyOrder(value={"controllerExpandSecretRef", "controllerPublishSecretRef", "driver", "fsType", "nodePublishSecretRef", "nodeStageSecretRef", "readOnly", "volumeAttributes", "volumeHandle"})
public class IoK8sApiCoreV1CSIPersistentVolumeSource {
    public static final String JSON_PROPERTY_CONTROLLER_EXPAND_SECRET_REF = "controllerExpandSecretRef";
    private IoK8sApiCoreV1SecretReference controllerExpandSecretRef;
    public static final String JSON_PROPERTY_CONTROLLER_PUBLISH_SECRET_REF = "controllerPublishSecretRef";
    private IoK8sApiCoreV1SecretReference controllerPublishSecretRef;
    public static final String JSON_PROPERTY_DRIVER = "driver";
    private String driver;
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    private String fsType;
    public static final String JSON_PROPERTY_NODE_PUBLISH_SECRET_REF = "nodePublishSecretRef";
    private IoK8sApiCoreV1SecretReference nodePublishSecretRef;
    public static final String JSON_PROPERTY_NODE_STAGE_SECRET_REF = "nodeStageSecretRef";
    private IoK8sApiCoreV1SecretReference nodeStageSecretRef;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;
    public static final String JSON_PROPERTY_VOLUME_ATTRIBUTES = "volumeAttributes";
    private Map<String, String> volumeAttributes = null;
    public static final String JSON_PROPERTY_VOLUME_HANDLE = "volumeHandle";
    private String volumeHandle;

    public IoK8sApiCoreV1CSIPersistentVolumeSource controllerExpandSecretRef(IoK8sApiCoreV1SecretReference controllerExpandSecretRef) {
        this.controllerExpandSecretRef = controllerExpandSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="controllerExpandSecretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1SecretReference getControllerExpandSecretRef() {
        return this.controllerExpandSecretRef;
    }

    public void setControllerExpandSecretRef(IoK8sApiCoreV1SecretReference controllerExpandSecretRef) {
        this.controllerExpandSecretRef = controllerExpandSecretRef;
    }

    public IoK8sApiCoreV1CSIPersistentVolumeSource controllerPublishSecretRef(IoK8sApiCoreV1SecretReference controllerPublishSecretRef) {
        this.controllerPublishSecretRef = controllerPublishSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="controllerPublishSecretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1SecretReference getControllerPublishSecretRef() {
        return this.controllerPublishSecretRef;
    }

    public void setControllerPublishSecretRef(IoK8sApiCoreV1SecretReference controllerPublishSecretRef) {
        this.controllerPublishSecretRef = controllerPublishSecretRef;
    }

    public IoK8sApiCoreV1CSIPersistentVolumeSource driver(String driver) {
        this.driver = driver;
        return this;
    }

    @ApiModelProperty(required=true, value="Driver is the name of the driver to use for this volume. Required.")
    @JsonProperty(value="driver")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public IoK8sApiCoreV1CSIPersistentVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\".")
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public IoK8sApiCoreV1CSIPersistentVolumeSource nodePublishSecretRef(IoK8sApiCoreV1SecretReference nodePublishSecretRef) {
        this.nodePublishSecretRef = nodePublishSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="nodePublishSecretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1SecretReference getNodePublishSecretRef() {
        return this.nodePublishSecretRef;
    }

    public void setNodePublishSecretRef(IoK8sApiCoreV1SecretReference nodePublishSecretRef) {
        this.nodePublishSecretRef = nodePublishSecretRef;
    }

    public IoK8sApiCoreV1CSIPersistentVolumeSource nodeStageSecretRef(IoK8sApiCoreV1SecretReference nodeStageSecretRef) {
        this.nodeStageSecretRef = nodeStageSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="nodeStageSecretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1SecretReference getNodeStageSecretRef() {
        return this.nodeStageSecretRef;
    }

    public void setNodeStageSecretRef(IoK8sApiCoreV1SecretReference nodeStageSecretRef) {
        this.nodeStageSecretRef = nodeStageSecretRef;
    }

    public IoK8sApiCoreV1CSIPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: The value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public IoK8sApiCoreV1CSIPersistentVolumeSource volumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes;
        return this;
    }

    public IoK8sApiCoreV1CSIPersistentVolumeSource putVolumeAttributesItem(String key, String volumeAttributesItem) {
        if (this.volumeAttributes == null) {
            this.volumeAttributes = new HashMap<String, String>();
        }
        this.volumeAttributes.put(key, volumeAttributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Attributes of the volume to publish.")
    @JsonProperty(value="volumeAttributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    public void setVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes;
    }

    public IoK8sApiCoreV1CSIPersistentVolumeSource volumeHandle(String volumeHandle) {
        this.volumeHandle = volumeHandle;
        return this;
    }

    @ApiModelProperty(required=true, value="VolumeHandle is the unique volume name returned by the CSI volume plugin\u2019s CreateVolume to refer to the volume on all subsequent calls. Required.")
    @JsonProperty(value="volumeHandle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVolumeHandle() {
        return this.volumeHandle;
    }

    public void setVolumeHandle(String volumeHandle) {
        this.volumeHandle = volumeHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1CSIPersistentVolumeSource ioK8sApiCoreV1CSIPersistentVolumeSource = (IoK8sApiCoreV1CSIPersistentVolumeSource)o;
        return Objects.equals(this.controllerExpandSecretRef, ioK8sApiCoreV1CSIPersistentVolumeSource.controllerExpandSecretRef) && Objects.equals(this.controllerPublishSecretRef, ioK8sApiCoreV1CSIPersistentVolumeSource.controllerPublishSecretRef) && Objects.equals(this.driver, ioK8sApiCoreV1CSIPersistentVolumeSource.driver) && Objects.equals(this.fsType, ioK8sApiCoreV1CSIPersistentVolumeSource.fsType) && Objects.equals(this.nodePublishSecretRef, ioK8sApiCoreV1CSIPersistentVolumeSource.nodePublishSecretRef) && Objects.equals(this.nodeStageSecretRef, ioK8sApiCoreV1CSIPersistentVolumeSource.nodeStageSecretRef) && Objects.equals(this.readOnly, ioK8sApiCoreV1CSIPersistentVolumeSource.readOnly) && Objects.equals(this.volumeAttributes, ioK8sApiCoreV1CSIPersistentVolumeSource.volumeAttributes) && Objects.equals(this.volumeHandle, ioK8sApiCoreV1CSIPersistentVolumeSource.volumeHandle);
    }

    public int hashCode() {
        return Objects.hash(this.controllerExpandSecretRef, this.controllerPublishSecretRef, this.driver, this.fsType, this.nodePublishSecretRef, this.nodeStageSecretRef, this.readOnly, this.volumeAttributes, this.volumeHandle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1CSIPersistentVolumeSource {\n");
        sb.append("    controllerExpandSecretRef: ").append(this.toIndentedString(this.controllerExpandSecretRef)).append("\n");
        sb.append("    controllerPublishSecretRef: ").append(this.toIndentedString(this.controllerPublishSecretRef)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    nodePublishSecretRef: ").append(this.toIndentedString(this.nodePublishSecretRef)).append("\n");
        sb.append("    nodeStageSecretRef: ").append(this.toIndentedString(this.nodeStageSecretRef)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    volumeAttributes: ").append(this.toIndentedString(this.volumeAttributes)).append("\n");
        sb.append("    volumeHandle: ").append(this.toIndentedString(this.volumeHandle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

