/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1LocalObjectReference;

@ApiModel(description="Represents a source location of a volume to mount, managed by an external CSI driver")
@JsonPropertyOrder(value={"driver", "fsType", "nodePublishSecretRef", "readOnly", "volumeAttributes"})
public class IoK8sApiCoreV1CSIVolumeSource {
    public static final String JSON_PROPERTY_DRIVER = "driver";
    private String driver;
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    private String fsType;
    public static final String JSON_PROPERTY_NODE_PUBLISH_SECRET_REF = "nodePublishSecretRef";
    private IoK8sApiCoreV1LocalObjectReference nodePublishSecretRef;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;
    public static final String JSON_PROPERTY_VOLUME_ATTRIBUTES = "volumeAttributes";
    private Map<String, String> volumeAttributes = null;

    public IoK8sApiCoreV1CSIVolumeSource driver(String driver) {
        this.driver = driver;
        return this;
    }

    @ApiModelProperty(required=true, value="Driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.")
    @JsonProperty(value="driver")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public IoK8sApiCoreV1CSIVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. Ex. \"ext4\", \"xfs\", \"ntfs\". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.")
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public IoK8sApiCoreV1CSIVolumeSource nodePublishSecretRef(IoK8sApiCoreV1LocalObjectReference nodePublishSecretRef) {
        this.nodePublishSecretRef = nodePublishSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="nodePublishSecretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1LocalObjectReference getNodePublishSecretRef() {
        return this.nodePublishSecretRef;
    }

    public void setNodePublishSecretRef(IoK8sApiCoreV1LocalObjectReference nodePublishSecretRef) {
        this.nodePublishSecretRef = nodePublishSecretRef;
    }

    public IoK8sApiCoreV1CSIVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies a read-only configuration for the volume. Defaults to false (read/write).")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public IoK8sApiCoreV1CSIVolumeSource volumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes;
        return this;
    }

    public IoK8sApiCoreV1CSIVolumeSource putVolumeAttributesItem(String key, String volumeAttributesItem) {
        if (this.volumeAttributes == null) {
            this.volumeAttributes = new HashMap<String, String>();
        }
        this.volumeAttributes.put(key, volumeAttributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VolumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.")
    @JsonProperty(value="volumeAttributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    public void setVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1CSIVolumeSource ioK8sApiCoreV1CSIVolumeSource = (IoK8sApiCoreV1CSIVolumeSource)o;
        return Objects.equals(this.driver, ioK8sApiCoreV1CSIVolumeSource.driver) && Objects.equals(this.fsType, ioK8sApiCoreV1CSIVolumeSource.fsType) && Objects.equals(this.nodePublishSecretRef, ioK8sApiCoreV1CSIVolumeSource.nodePublishSecretRef) && Objects.equals(this.readOnly, ioK8sApiCoreV1CSIVolumeSource.readOnly) && Objects.equals(this.volumeAttributes, ioK8sApiCoreV1CSIVolumeSource.volumeAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.fsType, this.nodePublishSecretRef, this.readOnly, this.volumeAttributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1CSIVolumeSource {\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    nodePublishSecretRef: ").append(this.toIndentedString(this.nodePublishSecretRef)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    volumeAttributes: ").append(this.toIndentedString(this.volumeAttributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

