/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1LocalObjectReference;

@ApiModel(description="Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.")
@JsonPropertyOrder(value={"monitors", "path", "readOnly", "secretFile", "secretRef", "user"})
public class IoK8sApiCoreV1CephFSVolumeSource {
    public static final String JSON_PROPERTY_MONITORS = "monitors";
    private List<String> monitors = new ArrayList<String>();
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;
    public static final String JSON_PROPERTY_SECRET_FILE = "secretFile";
    private String secretFile;
    public static final String JSON_PROPERTY_SECRET_REF = "secretRef";
    private IoK8sApiCoreV1LocalObjectReference secretRef;
    public static final String JSON_PROPERTY_USER = "user";
    private String user;

    public IoK8sApiCoreV1CephFSVolumeSource monitors(List<String> monitors) {
        this.monitors = monitors;
        return this;
    }

    public IoK8sApiCoreV1CephFSVolumeSource addMonitorsItem(String monitorsItem) {
        this.monitors.add(monitorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it")
    @JsonProperty(value="monitors")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<String> monitors) {
        this.monitors = monitors;
    }

    public IoK8sApiCoreV1CephFSVolumeSource path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Used as the mounted root, rather than the full Ceph tree, default is /")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public IoK8sApiCoreV1CephFSVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public IoK8sApiCoreV1CephFSVolumeSource secretFile(String secretFile) {
        this.secretFile = secretFile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it")
    @JsonProperty(value="secretFile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecretFile() {
        return this.secretFile;
    }

    public void setSecretFile(String secretFile) {
        this.secretFile = secretFile;
    }

    public IoK8sApiCoreV1CephFSVolumeSource secretRef(IoK8sApiCoreV1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="secretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1LocalObjectReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(IoK8sApiCoreV1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
    }

    public IoK8sApiCoreV1CephFSVolumeSource user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1CephFSVolumeSource ioK8sApiCoreV1CephFSVolumeSource = (IoK8sApiCoreV1CephFSVolumeSource)o;
        return Objects.equals(this.monitors, ioK8sApiCoreV1CephFSVolumeSource.monitors) && Objects.equals(this.path, ioK8sApiCoreV1CephFSVolumeSource.path) && Objects.equals(this.readOnly, ioK8sApiCoreV1CephFSVolumeSource.readOnly) && Objects.equals(this.secretFile, ioK8sApiCoreV1CephFSVolumeSource.secretFile) && Objects.equals(this.secretRef, ioK8sApiCoreV1CephFSVolumeSource.secretRef) && Objects.equals(this.user, ioK8sApiCoreV1CephFSVolumeSource.user);
    }

    public int hashCode() {
        return Objects.hash(this.monitors, this.path, this.readOnly, this.secretFile, this.secretRef, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1CephFSVolumeSource {\n");
        sb.append("    monitors: ").append(this.toIndentedString(this.monitors)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretFile: ").append(this.toIndentedString(this.secretFile)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

