/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApimachineryPkgApisMetaV1ObjectMeta;

@ApiModel(description="ConfigMap holds configuration data for pods to consume.")
@JsonPropertyOrder(value={"apiVersion", "binaryData", "data", "immutable", "kind", "metadata"})
public class IoK8sApiCoreV1ConfigMap {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    private String apiVersion;
    public static final String JSON_PROPERTY_BINARY_DATA = "binaryData";
    private Map<String, byte[]> binaryData = null;
    public static final String JSON_PROPERTY_DATA = "data";
    private Map<String, String> data = null;
    public static final String JSON_PROPERTY_IMMUTABLE = "immutable";
    private Boolean immutable;
    public static final String JSON_PROPERTY_KIND = "kind";
    private String kind;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata;

    public IoK8sApiCoreV1ConfigMap apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public IoK8sApiCoreV1ConfigMap binaryData(Map<String, byte[]> binaryData) {
        this.binaryData = binaryData;
        return this;
    }

    public IoK8sApiCoreV1ConfigMap putBinaryDataItem(String key, byte[] binaryDataItem) {
        if (this.binaryData == null) {
            this.binaryData = new HashMap<String, byte[]>();
        }
        this.binaryData.put(key, binaryDataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.")
    @JsonProperty(value="binaryData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, byte[]> getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(Map<String, byte[]> binaryData) {
        this.binaryData = binaryData;
    }

    public IoK8sApiCoreV1ConfigMap data(Map<String, String> data) {
        this.data = data;
        return this;
    }

    public IoK8sApiCoreV1ConfigMap putDataItem(String key, String dataItem) {
        if (this.data == null) {
            this.data = new HashMap<String, String>();
        }
        this.data.put(key, dataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public IoK8sApiCoreV1ConfigMap immutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil. This is an alpha field enabled by ImmutableEphemeralVolumes feature gate.")
    @JsonProperty(value="immutable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getImmutable() {
        return this.immutable;
    }

    public void setImmutable(Boolean immutable) {
        this.immutable = immutable;
    }

    public IoK8sApiCoreV1ConfigMap kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public IoK8sApiCoreV1ConfigMap metadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApimachineryPkgApisMetaV1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ConfigMap ioK8sApiCoreV1ConfigMap = (IoK8sApiCoreV1ConfigMap)o;
        return Objects.equals(this.apiVersion, ioK8sApiCoreV1ConfigMap.apiVersion) && Objects.equals(this.binaryData, ioK8sApiCoreV1ConfigMap.binaryData) && Objects.equals(this.data, ioK8sApiCoreV1ConfigMap.data) && Objects.equals(this.immutable, ioK8sApiCoreV1ConfigMap.immutable) && Objects.equals(this.kind, ioK8sApiCoreV1ConfigMap.kind) && Objects.equals(this.metadata, ioK8sApiCoreV1ConfigMap.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.binaryData, this.data, this.immutable, this.kind, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ConfigMap {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    binaryData: ").append(this.toIndentedString(this.binaryData)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    immutable: ").append(this.toIndentedString(this.immutable)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

