/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node.")
@JsonPropertyOrder(value={"kubeletConfigKey", "name", "namespace", "resourceVersion", "uid"})
public class IoK8sApiCoreV1ConfigMapNodeConfigSource {
    public static final String JSON_PROPERTY_KUBELET_CONFIG_KEY = "kubeletConfigKey";
    private String kubeletConfigKey;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NAMESPACE = "namespace";
    private String namespace;
    public static final String JSON_PROPERTY_RESOURCE_VERSION = "resourceVersion";
    private String resourceVersion;
    public static final String JSON_PROPERTY_UID = "uid";
    private String uid;

    public IoK8sApiCoreV1ConfigMapNodeConfigSource kubeletConfigKey(String kubeletConfigKey) {
        this.kubeletConfigKey = kubeletConfigKey;
        return this;
    }

    @ApiModelProperty(required=true, value="KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.")
    @JsonProperty(value="kubeletConfigKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKubeletConfigKey() {
        return this.kubeletConfigKey;
    }

    public void setKubeletConfigKey(String kubeletConfigKey) {
        this.kubeletConfigKey = kubeletConfigKey;
    }

    public IoK8sApiCoreV1ConfigMapNodeConfigSource name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IoK8sApiCoreV1ConfigMapNodeConfigSource namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @ApiModelProperty(required=true, value="Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.")
    @JsonProperty(value="namespace")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public IoK8sApiCoreV1ConfigMapNodeConfigSource resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.")
    @JsonProperty(value="resourceVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public IoK8sApiCoreV1ConfigMapNodeConfigSource uid(String uid) {
        this.uid = uid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.")
    @JsonProperty(value="uid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ConfigMapNodeConfigSource ioK8sApiCoreV1ConfigMapNodeConfigSource = (IoK8sApiCoreV1ConfigMapNodeConfigSource)o;
        return Objects.equals(this.kubeletConfigKey, ioK8sApiCoreV1ConfigMapNodeConfigSource.kubeletConfigKey) && Objects.equals(this.name, ioK8sApiCoreV1ConfigMapNodeConfigSource.name) && Objects.equals(this.namespace, ioK8sApiCoreV1ConfigMapNodeConfigSource.namespace) && Objects.equals(this.resourceVersion, ioK8sApiCoreV1ConfigMapNodeConfigSource.resourceVersion) && Objects.equals(this.uid, ioK8sApiCoreV1ConfigMapNodeConfigSource.uid);
    }

    public int hashCode() {
        return Objects.hash(this.kubeletConfigKey, this.name, this.namespace, this.resourceVersion, this.uid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ConfigMapNodeConfigSource {\n");
        sb.append("    kubeletConfigKey: ").append(this.toIndentedString(this.kubeletConfigKey)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

