/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1KeyToPath;

@ApiModel(description="Adapts a ConfigMap into a volume.  The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.")
@JsonPropertyOrder(value={"defaultMode", "items", "name", "optional"})
public class IoK8sApiCoreV1ConfigMapVolumeSource {
    public static final String JSON_PROPERTY_DEFAULT_MODE = "defaultMode";
    private Integer defaultMode;
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<IoK8sApiCoreV1KeyToPath> items = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONAL = "optional";
    private Boolean optional;

    public IoK8sApiCoreV1ConfigMapVolumeSource defaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.")
    @JsonProperty(value="defaultMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
    }

    public IoK8sApiCoreV1ConfigMapVolumeSource items(List<IoK8sApiCoreV1KeyToPath> items) {
        this.items = items;
        return this;
    }

    public IoK8sApiCoreV1ConfigMapVolumeSource addItemsItem(IoK8sApiCoreV1KeyToPath itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<IoK8sApiCoreV1KeyToPath>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.")
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1KeyToPath> getItems() {
        return this.items;
    }

    public void setItems(List<IoK8sApiCoreV1KeyToPath> items) {
        this.items = items;
    }

    public IoK8sApiCoreV1ConfigMapVolumeSource name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IoK8sApiCoreV1ConfigMapVolumeSource optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify whether the ConfigMap or its keys must be defined")
    @JsonProperty(value="optional")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ConfigMapVolumeSource ioK8sApiCoreV1ConfigMapVolumeSource = (IoK8sApiCoreV1ConfigMapVolumeSource)o;
        return Objects.equals(this.defaultMode, ioK8sApiCoreV1ConfigMapVolumeSource.defaultMode) && Objects.equals(this.items, ioK8sApiCoreV1ConfigMapVolumeSource.items) && Objects.equals(this.name, ioK8sApiCoreV1ConfigMapVolumeSource.name) && Objects.equals(this.optional, ioK8sApiCoreV1ConfigMapVolumeSource.optional);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMode, this.items, this.name, this.optional);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ConfigMapVolumeSource {\n");
        sb.append("    defaultMode: ").append(this.toIndentedString(this.defaultMode)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

