/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1ContainerPort;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1EnvFromSource;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1EnvVar;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1Lifecycle;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1Probe;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1ResourceRequirements;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1SecurityContext;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1VolumeDevice;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1VolumeMount;

@ApiModel(description="A single application container that you want to run within a pod.")
@JsonPropertyOrder(value={"args", "command", "env", "envFrom", "image", "imagePullPolicy", "lifecycle", "livenessProbe", "name", "ports", "readinessProbe", "resources", "securityContext", "startupProbe", "stdin", "stdinOnce", "terminationMessagePath", "terminationMessagePolicy", "tty", "volumeDevices", "volumeMounts", "workingDir"})
public class IoK8sApiCoreV1Container {
    public static final String JSON_PROPERTY_ARGS = "args";
    private List<String> args = null;
    public static final String JSON_PROPERTY_COMMAND = "command";
    private List<String> command = null;
    public static final String JSON_PROPERTY_ENV = "env";
    private List<IoK8sApiCoreV1EnvVar> env = null;
    public static final String JSON_PROPERTY_ENV_FROM = "envFrom";
    private List<IoK8sApiCoreV1EnvFromSource> envFrom = null;
    public static final String JSON_PROPERTY_IMAGE = "image";
    private String image;
    public static final String JSON_PROPERTY_IMAGE_PULL_POLICY = "imagePullPolicy";
    private String imagePullPolicy;
    public static final String JSON_PROPERTY_LIFECYCLE = "lifecycle";
    private IoK8sApiCoreV1Lifecycle lifecycle;
    public static final String JSON_PROPERTY_LIVENESS_PROBE = "livenessProbe";
    private IoK8sApiCoreV1Probe livenessProbe;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PORTS = "ports";
    private List<IoK8sApiCoreV1ContainerPort> ports = null;
    public static final String JSON_PROPERTY_READINESS_PROBE = "readinessProbe";
    private IoK8sApiCoreV1Probe readinessProbe;
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    private IoK8sApiCoreV1ResourceRequirements resources;
    public static final String JSON_PROPERTY_SECURITY_CONTEXT = "securityContext";
    private IoK8sApiCoreV1SecurityContext securityContext;
    public static final String JSON_PROPERTY_STARTUP_PROBE = "startupProbe";
    private IoK8sApiCoreV1Probe startupProbe;
    public static final String JSON_PROPERTY_STDIN = "stdin";
    private Boolean stdin;
    public static final String JSON_PROPERTY_STDIN_ONCE = "stdinOnce";
    private Boolean stdinOnce;
    public static final String JSON_PROPERTY_TERMINATION_MESSAGE_PATH = "terminationMessagePath";
    private String terminationMessagePath;
    public static final String JSON_PROPERTY_TERMINATION_MESSAGE_POLICY = "terminationMessagePolicy";
    private String terminationMessagePolicy;
    public static final String JSON_PROPERTY_TTY = "tty";
    private Boolean tty;
    public static final String JSON_PROPERTY_VOLUME_DEVICES = "volumeDevices";
    private List<IoK8sApiCoreV1VolumeDevice> volumeDevices = null;
    public static final String JSON_PROPERTY_VOLUME_MOUNTS = "volumeMounts";
    private List<IoK8sApiCoreV1VolumeMount> volumeMounts = null;
    public static final String JSON_PROPERTY_WORKING_DIR = "workingDir";
    private String workingDir;

    public IoK8sApiCoreV1Container args(List<String> args) {
        this.args = args;
        return this;
    }

    public IoK8sApiCoreV1Container addArgsItem(String argsItem) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(argsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell")
    @JsonProperty(value="args")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public IoK8sApiCoreV1Container command(List<String> command) {
        this.command = command;
        return this;
    }

    public IoK8sApiCoreV1Container addCommandItem(String commandItem) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(commandItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell")
    @JsonProperty(value="command")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    public IoK8sApiCoreV1Container env(List<IoK8sApiCoreV1EnvVar> env) {
        this.env = env;
        return this;
    }

    public IoK8sApiCoreV1Container addEnvItem(IoK8sApiCoreV1EnvVar envItem) {
        if (this.env == null) {
            this.env = new ArrayList<IoK8sApiCoreV1EnvVar>();
        }
        this.env.add(envItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of environment variables to set in the container. Cannot be updated.")
    @JsonProperty(value="env")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1EnvVar> getEnv() {
        return this.env;
    }

    public void setEnv(List<IoK8sApiCoreV1EnvVar> env) {
        this.env = env;
    }

    public IoK8sApiCoreV1Container envFrom(List<IoK8sApiCoreV1EnvFromSource> envFrom) {
        this.envFrom = envFrom;
        return this;
    }

    public IoK8sApiCoreV1Container addEnvFromItem(IoK8sApiCoreV1EnvFromSource envFromItem) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<IoK8sApiCoreV1EnvFromSource>();
        }
        this.envFrom.add(envFromItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.")
    @JsonProperty(value="envFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1EnvFromSource> getEnvFrom() {
        return this.envFrom;
    }

    public void setEnvFrom(List<IoK8sApiCoreV1EnvFromSource> envFrom) {
        this.envFrom = envFrom;
    }

    public IoK8sApiCoreV1Container image(String image) {
        this.image = image;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.")
    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public IoK8sApiCoreV1Container imagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images")
    @JsonProperty(value="imagePullPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public IoK8sApiCoreV1Container lifecycle(IoK8sApiCoreV1Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="lifecycle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(IoK8sApiCoreV1Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public IoK8sApiCoreV1Container livenessProbe(IoK8sApiCoreV1Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="livenessProbe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    public void setLivenessProbe(IoK8sApiCoreV1Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    public IoK8sApiCoreV1Container name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IoK8sApiCoreV1Container ports(List<IoK8sApiCoreV1ContainerPort> ports) {
        this.ports = ports;
        return this;
    }

    public IoK8sApiCoreV1Container addPortsItem(IoK8sApiCoreV1ContainerPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<IoK8sApiCoreV1ContainerPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default \"0.0.0.0\" address inside a container will be accessible from the network. Cannot be updated.")
    @JsonProperty(value="ports")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1ContainerPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<IoK8sApiCoreV1ContainerPort> ports) {
        this.ports = ports;
    }

    public IoK8sApiCoreV1Container readinessProbe(IoK8sApiCoreV1Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="readinessProbe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    public void setReadinessProbe(IoK8sApiCoreV1Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    public IoK8sApiCoreV1Container resources(IoK8sApiCoreV1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(IoK8sApiCoreV1ResourceRequirements resources) {
        this.resources = resources;
    }

    public IoK8sApiCoreV1Container securityContext(IoK8sApiCoreV1SecurityContext securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="securityContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(IoK8sApiCoreV1SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public IoK8sApiCoreV1Container startupProbe(IoK8sApiCoreV1Probe startupProbe) {
        this.startupProbe = startupProbe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="startupProbe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1Probe getStartupProbe() {
        return this.startupProbe;
    }

    public void setStartupProbe(IoK8sApiCoreV1Probe startupProbe) {
        this.startupProbe = startupProbe;
    }

    public IoK8sApiCoreV1Container stdin(Boolean stdin) {
        this.stdin = stdin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.")
    @JsonProperty(value="stdin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getStdin() {
        return this.stdin;
    }

    public void setStdin(Boolean stdin) {
        this.stdin = stdin;
    }

    public IoK8sApiCoreV1Container stdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false")
    @JsonProperty(value="stdinOnce")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    public void setStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
    }

    public IoK8sApiCoreV1Container terminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.")
    @JsonProperty(value="terminationMessagePath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public void setTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
    }

    public IoK8sApiCoreV1Container terminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.")
    @JsonProperty(value="terminationMessagePolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTerminationMessagePolicy() {
        return this.terminationMessagePolicy;
    }

    public void setTerminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
    }

    public IoK8sApiCoreV1Container tty(Boolean tty) {
        this.tty = tty;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.")
    @JsonProperty(value="tty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTty() {
        return this.tty;
    }

    public void setTty(Boolean tty) {
        this.tty = tty;
    }

    public IoK8sApiCoreV1Container volumeDevices(List<IoK8sApiCoreV1VolumeDevice> volumeDevices) {
        this.volumeDevices = volumeDevices;
        return this;
    }

    public IoK8sApiCoreV1Container addVolumeDevicesItem(IoK8sApiCoreV1VolumeDevice volumeDevicesItem) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList<IoK8sApiCoreV1VolumeDevice>();
        }
        this.volumeDevices.add(volumeDevicesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeDevices is the list of block devices to be used by the container.")
    @JsonProperty(value="volumeDevices")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1VolumeDevice> getVolumeDevices() {
        return this.volumeDevices;
    }

    public void setVolumeDevices(List<IoK8sApiCoreV1VolumeDevice> volumeDevices) {
        this.volumeDevices = volumeDevices;
    }

    public IoK8sApiCoreV1Container volumeMounts(List<IoK8sApiCoreV1VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public IoK8sApiCoreV1Container addVolumeMountsItem(IoK8sApiCoreV1VolumeMount volumeMountsItem) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<IoK8sApiCoreV1VolumeMount>();
        }
        this.volumeMounts.add(volumeMountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pod volumes to mount into the container's filesystem. Cannot be updated.")
    @JsonProperty(value="volumeMounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<IoK8sApiCoreV1VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public IoK8sApiCoreV1Container workingDir(String workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.")
    @JsonProperty(value="workingDir")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1Container ioK8sApiCoreV1Container = (IoK8sApiCoreV1Container)o;
        return Objects.equals(this.args, ioK8sApiCoreV1Container.args) && Objects.equals(this.command, ioK8sApiCoreV1Container.command) && Objects.equals(this.env, ioK8sApiCoreV1Container.env) && Objects.equals(this.envFrom, ioK8sApiCoreV1Container.envFrom) && Objects.equals(this.image, ioK8sApiCoreV1Container.image) && Objects.equals(this.imagePullPolicy, ioK8sApiCoreV1Container.imagePullPolicy) && Objects.equals(this.lifecycle, ioK8sApiCoreV1Container.lifecycle) && Objects.equals(this.livenessProbe, ioK8sApiCoreV1Container.livenessProbe) && Objects.equals(this.name, ioK8sApiCoreV1Container.name) && Objects.equals(this.ports, ioK8sApiCoreV1Container.ports) && Objects.equals(this.readinessProbe, ioK8sApiCoreV1Container.readinessProbe) && Objects.equals(this.resources, ioK8sApiCoreV1Container.resources) && Objects.equals(this.securityContext, ioK8sApiCoreV1Container.securityContext) && Objects.equals(this.startupProbe, ioK8sApiCoreV1Container.startupProbe) && Objects.equals(this.stdin, ioK8sApiCoreV1Container.stdin) && Objects.equals(this.stdinOnce, ioK8sApiCoreV1Container.stdinOnce) && Objects.equals(this.terminationMessagePath, ioK8sApiCoreV1Container.terminationMessagePath) && Objects.equals(this.terminationMessagePolicy, ioK8sApiCoreV1Container.terminationMessagePolicy) && Objects.equals(this.tty, ioK8sApiCoreV1Container.tty) && Objects.equals(this.volumeDevices, ioK8sApiCoreV1Container.volumeDevices) && Objects.equals(this.volumeMounts, ioK8sApiCoreV1Container.volumeMounts) && Objects.equals(this.workingDir, ioK8sApiCoreV1Container.workingDir);
    }

    public int hashCode() {
        return Objects.hash(this.args, this.command, this.env, this.envFrom, this.image, this.imagePullPolicy, this.lifecycle, this.livenessProbe, this.name, this.ports, this.readinessProbe, this.resources, this.securityContext, this.startupProbe, this.stdin, this.stdinOnce, this.terminationMessagePath, this.terminationMessagePolicy, this.tty, this.volumeDevices, this.volumeMounts, this.workingDir);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1Container {\n");
        sb.append("    args: ").append(this.toIndentedString(this.args)).append("\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    envFrom: ").append(this.toIndentedString(this.envFrom)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imagePullPolicy: ").append(this.toIndentedString(this.imagePullPolicy)).append("\n");
        sb.append("    lifecycle: ").append(this.toIndentedString(this.lifecycle)).append("\n");
        sb.append("    livenessProbe: ").append(this.toIndentedString(this.livenessProbe)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("    readinessProbe: ").append(this.toIndentedString(this.readinessProbe)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    securityContext: ").append(this.toIndentedString(this.securityContext)).append("\n");
        sb.append("    startupProbe: ").append(this.toIndentedString(this.startupProbe)).append("\n");
        sb.append("    stdin: ").append(this.toIndentedString(this.stdin)).append("\n");
        sb.append("    stdinOnce: ").append(this.toIndentedString(this.stdinOnce)).append("\n");
        sb.append("    terminationMessagePath: ").append(this.toIndentedString(this.terminationMessagePath)).append("\n");
        sb.append("    terminationMessagePolicy: ").append(this.toIndentedString(this.terminationMessagePolicy)).append("\n");
        sb.append("    tty: ").append(this.toIndentedString(this.tty)).append("\n");
        sb.append("    volumeDevices: ").append(this.toIndentedString(this.volumeDevices)).append("\n");
        sb.append("    volumeMounts: ").append(this.toIndentedString(this.volumeMounts)).append("\n");
        sb.append("    workingDir: ").append(this.toIndentedString(this.workingDir)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

