/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describe a container image")
@JsonPropertyOrder(value={"names", "sizeBytes"})
public class IoK8sApiCoreV1ContainerImage {
    public static final String JSON_PROPERTY_NAMES = "names";
    private List<String> names = new ArrayList<String>();
    public static final String JSON_PROPERTY_SIZE_BYTES = "sizeBytes";
    private Long sizeBytes;

    public IoK8sApiCoreV1ContainerImage names(List<String> names) {
        this.names = names;
        return this;
    }

    public IoK8sApiCoreV1ContainerImage addNamesItem(String namesItem) {
        this.names.add(namesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Names by which this image is known. e.g. [\"k8s.gcr.io/hyperkube:v1.0.7\", \"dockerhub.io/google_containers/hyperkube:v1.0.7\"]")
    @JsonProperty(value="names")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public IoK8sApiCoreV1ContainerImage sizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The size of the image in bytes.")
    @JsonProperty(value="sizeBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ContainerImage ioK8sApiCoreV1ContainerImage = (IoK8sApiCoreV1ContainerImage)o;
        return Objects.equals(this.names, ioK8sApiCoreV1ContainerImage.names) && Objects.equals(this.sizeBytes, ioK8sApiCoreV1ContainerImage.sizeBytes);
    }

    public int hashCode() {
        return Objects.hash(this.names, this.sizeBytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ContainerImage {\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

