/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ContainerPort represents a network port in a single container.")
@JsonPropertyOrder(value={"containerPort", "hostIP", "hostPort", "name", "protocol"})
public class IoK8sApiCoreV1ContainerPort {
    public static final String JSON_PROPERTY_CONTAINER_PORT = "containerPort";
    private Integer containerPort;
    public static final String JSON_PROPERTY_HOST_I_P = "hostIP";
    private String hostIP;
    public static final String JSON_PROPERTY_HOST_PORT = "hostPort";
    private Integer hostPort;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROTOCOL = "protocol";
    private String protocol;

    public IoK8sApiCoreV1ContainerPort containerPort(Integer containerPort) {
        this.containerPort = containerPort;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.")
    @JsonProperty(value="containerPort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getContainerPort() {
        return this.containerPort;
    }

    public void setContainerPort(Integer containerPort) {
        this.containerPort = containerPort;
    }

    public IoK8sApiCoreV1ContainerPort hostIP(String hostIP) {
        this.hostIP = hostIP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="What host IP to bind the external port to.")
    @JsonProperty(value="hostIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostIP() {
        return this.hostIP;
    }

    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    public IoK8sApiCoreV1ContainerPort hostPort(Integer hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.")
    @JsonProperty(value="hostPort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(Integer hostPort) {
        this.hostPort = hostPort;
    }

    public IoK8sApiCoreV1ContainerPort name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IoK8sApiCoreV1ContainerPort protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Protocol for port. Must be UDP, TCP, or SCTP. Defaults to \"TCP\".")
    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ContainerPort ioK8sApiCoreV1ContainerPort = (IoK8sApiCoreV1ContainerPort)o;
        return Objects.equals(this.containerPort, ioK8sApiCoreV1ContainerPort.containerPort) && Objects.equals(this.hostIP, ioK8sApiCoreV1ContainerPort.hostIP) && Objects.equals(this.hostPort, ioK8sApiCoreV1ContainerPort.hostPort) && Objects.equals(this.name, ioK8sApiCoreV1ContainerPort.name) && Objects.equals(this.protocol, ioK8sApiCoreV1ContainerPort.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.containerPort, this.hostIP, this.hostPort, this.name, this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ContainerPort {\n");
        sb.append("    containerPort: ").append(this.toIndentedString(this.containerPort)).append("\n");
        sb.append("    hostIP: ").append(this.toIndentedString(this.hostIP)).append("\n");
        sb.append("    hostPort: ").append(this.toIndentedString(this.hostPort)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

